function [y,psnr] = RippletNLA(x,nCoef,fltname1,fltname2,d,c)

lseed = 1:floor(log2(min(size(x))))-4;
level = floor(max(lseed*(1-1/d-log2(c)),0));


C = DRT(x,level,fltname1,fltname2);
cfs=[];
for s=1:length(C)
    for w=1:length(C{s})
        cfs = [cfs; abs(C{s}{w}(:))];
    end
end



cfs = sort(cfs); cfs = cfs(end:-1:1);
cutoff = cfs(nCoef);

for s=1:length(C)
    for w=1:length(C{s})
        D{s}{w} = C{s}{w} .* (abs(C{s}{w})>cutoff);
    end
end
y = InverseDRT(D,level,fltname1,fltname2);

x=double(real(x));
y=double(real(double(y)));
mse=sum(sum((y-x).^2))/(prod(size(x)));
psnr = 10*log10(1/mse);