dir='C:\Documents and Settings\ruigangfang\My Documents\MATLAB\3d\database\livephase2\Phase2';
load ([dir,'\3DDmosRelease.mat'])

addpath ( genpath ( 'BRISQUE_release' ) );

[mm,nn]=size(Dmos);

for i=1:360
    i
    tic
    path=[dir,'\Stimuli\',StiFilename{i}];
    img=imread(path);
    %% image preprocessing
    [m,n,t]=size(img);
    img_left=img(:,1:n/2,:);
    img_right=img(:,n/2+1:n,:);
    
    imgl=double(rgb2gray(img(:,1:n/2,:)));
    imgr=double(rgb2gray(img(:,n/2+1:n,:)));
    [m,n,t]=size(imgl);
    rate=0.1; % rate is the ratio to be detected to find the bias
    D=zeros(1,floor(n*rate));
    for j=1:floor(n*rate)
        img11=imgl(:,j:n,:);
        img22=imgr(:,1:n+1-j,:);
        %[D(j),temp]=ssim_index(img11,img22,blocksize);
        difference=abs(img11-img22);
        D(j)=sum(sum(difference));
    end
    [gg,DD]=min(D);
    
    templ=imgl(:,DD:n);
    tempr=imgr(:,1:n+1-DD);
    clear img1 img2
    iml=templ;
    imr=tempr;
    
    maxs=25;
    %% for left image based search
    [disparity,similarity,rivalry,rivalry1] = disparity_search_ssim(iml,imr,maxs);
    filename=['data\phase2\disparity_similarity_L\',num2str(i),'.mat'];
    data={disparity,similarity,rivalry,rivalry1};
    save(filename,'data');
    
    %% for right image based search
    [disparity,similarity,rivalry,rivalry1] = disparity_search_ssim(imr,iml,maxs);
    filename=['data\phase2\disparity_similarity_R\',num2str(i),'.mat'];
    data={disparity,similarity,rivalry,rivalry1};
    save(filename,'data');
    clear data
    
%     %% for cyclopean image
%     score_l= brisquescore(img_left);
%     score_r= brisquescore(img_right);
%     
%     if score_l>=score_r 
%         index(i)=1;%%% 1: the left image is the based image
%                      %%% -1: the right image is the based image
%         load(['data\phase2\disparity_similarity_L\',num2str(i),'.mat']);
%         image= cyclopean_image(iml,imr,data{1});
%     else
%         index(i)=-1;%%% 1: the left image is the based image
%                      %%% -1: the right image is the based image
%         load(['data\phase2\disparity_similarity_R\',num2str(i),'.mat']);
%         image= cyclopean_image(imr,iml,data{1});
%     end
%     filename=['data\phase2\cyclopean_image\',num2str(i),'.mat'];
%     save(filename,'image');
%     clear data
%     clear image
    
   
    toc
end
filename=['data\phase2\cyclopean_image\index.mat'];
save(filename,'index')


