function d = kld(hist1, hist2)


 ind = hist1>0 & hist2>0;
% 
% d = sum(hist1(ind).*abs(log(hist1(ind)./hist2(ind))))/sum(hist1(ind));
hist1=hist1(ind);
hist2=hist2(ind);

hist1 = hist1/sum(hist1);
hist2 = hist2/sum(hist2);

[m,n]=size(hist1);

d=zeros(1,5);
for i=1:n*m
    %% city block
    d(1)=d(1)+abs(hist1(i)-hist2(i));
    %% kld
    d(2)=d(2)+hist1(i)*abs(log(hist1(i)/hist2(i)));
    %% .....
    d(3)=d(3)+hist1(i)*abs(hist1(i)/hist2(i));
    %%  jeffreys
    d(4)=d(4)+(hist1(i)-hist2(i))*log(hist1(i)/hist2(i));
    %% k divergence
    d(5)=d(5)+0.5*hist1(i)*log(2*hist1(i)/(hist1(i)+hist2(i)))+0.5*hist2(i)*log(2*hist2(i)/(hist1(i)+hist2(i)));
end

return