
function value=blockvalue_size4_new(img, blocksize)
%blocksize=8;
[m,n,t]=size(img);
if t>1
    img=rgb2gray(img);
end

% img([1:blocksize]+150,[1:blocksize]+150)=255;
% imshow(img);

img=double(img);
mm=floor(m/blocksize);
nn=floor(n/blocksize);

%% for horizontal direction
imgh1=img([1:mm-1]*blocksize-1,:);
imgh2=img([1:mm-1]*blocksize,:);
imgh3=img([1:mm-1]*blocksize+1,:);
gh_1=imgh2-imgh1;
gh_2=imgh3-imgh2;

%% for vertical direction
imgv1=img(:,[1:nn-1]*blocksize-1);
imgv2=img(:,[1:nn-1]*blocksize);
imgv3=img(:,[1:nn-1]*blocksize+1);
gv_1=imgv2-imgv1;
gv_2=imgv3-imgv2;

hist_h1=hist(gh_1(:),[-100:100]);
hist_h2=hist(gh_2(:),[-100:100]);

hist_v1=hist(gv_1(:),[-100:100]);
hist_v2=hist(gv_2(:),[-100:100]);

value1=kld(hist_h1,hist_h2);
value2=kld(hist_v1,hist_v2);

% subplot(2,2,1)
% hist(gh_1(:),[-100:100])
% subplot(2,2,2)
% hist(gv_1(:),[-100:100])
% 
% subplot(2,2,3)
% hist(gh_2(:),[-100:100])
% subplot(2,2,4)
% hist(gv_2(:),[-100:100])



value=value1+value2;
end

























