dir='C:\Documents and Settings\ruigangfang\My Documents\MATLAB\3d\database\livephase2\Phase2';
load ([dir,'\3DDmosRelease.mat'])

addpath ( genpath ( 'BRISQUE_release' ) );


img=imread('test2.bmp');
%% image preprocessing
[m,n,t]=size(img);
img_left=img(:,1:n/2,:);
img_right=img(:,n/2+1:n,:);

imgl=double(rgb2gray(img(:,1:n/2,:)));
imgr=double(rgb2gray(img(:,n/2+1:n,:)));
[m,n,t]=size(imgl);
rate=0.1; % rate is the ratio to be detected to find the bias
D=zeros(1,floor(n*rate));
for j=1:floor(n*rate)
    img11=imgl(:,j:n,:);
    img22=imgr(:,1:n+1-j,:);
    %[D(j),temp]=ssim_index(img11,img22,blocksize);
    difference=abs(img11-img22);
    D(j)=sum(sum(difference));
end
[gg,DD]=min(D);

templ=imgl(:,DD:n);
tempr=imgr(:,1:n+1-DD);
clear img1 img2
iml=templ;
imr=tempr;

maxs=25;
%% for left image based search
[disparity_L,similarity,rivalry,rivalry1] = disparity_search_ssim(iml,imr,maxs);

%% for right image based search
[disparity_R,similarity,rivalry,rivalry1] = disparity_search_ssim(imr,iml,maxs);

%% for cyclopean image
score_l= brisquescore(img_left);
score_r= brisquescore(img_right);

if score_l>=score_r
    num=1;
else
    num=0;
end

image_L= cyclopean_image(iml,imr,disparity_L);
image_R= cyclopean_image(imr,iml,disparity_R);

figure(1)
imshow(img_left)
figure(2)
imshow(img_right)
figure(3)
imshow(image_L)
figure(4)
imshow(image_R)


