clear
clc

img=imread('half_blur.bmp');
[m,n,t]=size(img);
img_left=img(:,1:n/2,:);
imgl=double(rgb2gray(img(:,1:n/2,:)));
imgr=double(rgb2gray(img(:,n/2+1:n,:)));
%%
% img11=imread('imR.png');
% img22=imread('imL.png');
% imgl=double(rgb2gray(img11));
% imgr=double(rgb2gray(img22));
%% find the bias for two images 
[m,n,t]=size(imgl);
rate=0.1; % rate is the ratio to be detected to find the bias 
D=zeros(1,floor(n*rate));
for i=1:floor(n*rate)
    img11=imgl(:,i:n,:);
    img22=imgr(:,1:n+1-i,:);
    %[D(i),temp]=ssim_index(img11,img22,blocksize);
    difference=abs(img11-img22);
    D(i)=sum(sum(difference));
end
[index,DD]=min(D);

templ=imgl(:,DD:n);
tempr=imgr(:,1:n+1-DD);
clear img1 img2
iml=templ;
imr=tempr;

%%
maxs=25;

tic
[disparity,similarity,rivalry,rivalry1] = disparity_search_ssim(iml,imr,maxs);
toc

cc=cyclopean_image(iml,imr,disparity);

%%
 maxs=max(max(disparity));
 mins=min((min(disparity)));
 dept=uint8((disparity-mins)/(maxs-mins)*256);

%%
%dept=uint8(abs(disparity)/(maxs)*256);

figure(1)

imshow(img)

figure(2)
imshow(uint8(cc))

figure(24)
imshow(dept)

% [fdsp dis1 confidence diff] = mj_stereo_SSIM(iml,imr, maxs);
% maxmax=max(max(dis1));
% minmin=min(min(dis1));
% dis1=uint8(dis1./(maxmax-minmin)*255);
% %subplot(2,2,3)
% figure(3)
% imshow(dis1)


