clear
clc
%%
% result1: 3 10 27 29 30 38 39 50 51  (node 10)
% result2: 2 10 27 31 32 40 41 50 51   (node 10)
% result3: 3 10 28 29 30  42 43 50 51  (node 10)
% result4: 22 37 27 29 30 38 39 50 51 (node 10)
% result5: 3 10 27 29 30 38 39 50 51 (node 4)
% result6: 3 10 27 29 30 38 39 50 51 (node 3)
% result7: 3 10 27 29 30 38 39 50 51  (node 5)
% result8: 6 10 19 20 27 29 30 38 39 50 51(node 4, rate 0.8)0.8716 0.8676
% 
%%
load feature.mat
[m,n]=size(feature);
%feature=feature(:,[3 10 19 20 27 29 30 38 39 50 51 n]);
rate=0.8;
for i=1:1000
    i/100
    tic
    [train_index,test_index]=data_seperate(rate);
    train_data=feature(train_index,:);
    test_data=feature(test_index,:);
    
    [m,n]=size(feature);
    in=train_data(:,1:n-1);
    out=train_data(:,n);
    test=test_data(:,1:n-1);
    groundtruth=test_data(:,n);
    
    [result,msev(i)]=neural_fitting(in, out, test);
    
    spear(i)=corr(result',groundtruth,'type','spearman');
    pear(i)=corr(result',groundtruth,'type','pearson');
    spearma=mean(spear)
    pearso= mean(pear)
    
    figure(2)
    subplot(3,1,1)
    plot(1:i,spear,'*')
    hold on
    plot([1,i],[mean(spear),mean(spear)],'r')
    hold off
    subplot(3,1,2)
    plot(1:i,pear,'*')
    hold on
    plot([1,i],[mean(pear),mean(pear)],'r')
    hold off
    subplot(3,1,3)
    plot(msev,spear,'*')
    
    figure(3)
    plot(result',groundtruth,'.')
    
    toc
end
mean(spear)
mean(pear)