addpath ( genpath ( 'BRISQUE_release' ) );
dir='C:\Documents and Settings\ruigangfang\My Documents\MATLAB\3d\database\livephase2\Phase2';
load ([dir,'\3DDmosRelease.mat'])

[mm,nn]=size(Dmos);

%%
for i=1:mm
    i
    tic
    path=[dir,'\Stimuli\',StiFilename{i}];
    img=imread(path);
    %% image preprocessing
    [m,n,t]=size(img);
    
    img_left=img(:,1:n/2,:);
    img_right=img(:,n/2+1:n,:);
    score_l= brisquescore(img_left);
    score_r= brisquescore(img_right);

    imgl=double(rgb2gray(img_left));
    imgr=double(rgb2gray(img_right));
    
    [m,n,t]=size(imgl);
    rate=0.1; % rate is the ratio to be detected to find the bias
    D=zeros(1,floor(n*rate));
    for j=1:floor(n*rate)
        img11=imgl(:,j:n,:);
        img22=imgr(:,1:n+1-j,:);
        %[D(j),temp]=ssim_index(img11,img22,blocksize);
        difference=abs(img11-img22);
        D(j)=sum(sum(difference));
    end
    [ttt,DD]=min(D);
    
    templ=imgl(:,DD:n);
    tempr=imgr(:,1:n+1-DD);
    clear img1 img2
    iml=templ;
    imr=tempr;
    
    
    if score_l>=score_r 
        index(i)=1;%%% 1: the left image is the based image
                     %%% 0: the right image is the based image
        load(['data\phase2\disparity_similarity_L\',num2str(i),'.mat']);
        image= cyclopean_image(iml,imr,data{1});
    else
        index(i)=0;%%% 1: the left image is the based image
                     %%% 0: the right image is the based image
        load(['data\phase2\disparity_similarity_R\',num2str(i),'.mat']);
        image= cyclopean_image(imr,iml,data{1});
    end
    filename=['data\phase2\cyclopean_image\',num2str(i),'.mat'];
    save(filename,'image');
    clear data
    clear image
    toc
end

filename=['data\phase2\cyclopean_image\index.mat'];
save(filename,'index')












