function [disparity,similarity,rivalry,rivalry1] =disparity_search_ssim(i1,i2, maxs)
win_size  = 25; %-- size of window used when smoothing

[dimy,dimx] = size(i1);
disparity = zeros(dimy,dimx);    %-- init outputs
similarity = zeros(dimy,dimx);
rivalry = zeros(dimy,dimx);
rivalry1 = zeros(dimy,dimx);

 %h = ones(win_size)/win_size.^2;  %-- averaging filter
 h=fspecial('gaussian',[win_size,win_size],win_size);

[g1x,g1y] = gradient(double(i1)); %-- get gradient for each image
[g2x,g2y] = gradient(double(i2));

g1x=(g1x+255)/510;
g1y=(g1y+255)/510;
g2x=(g2x+255)/510;
g2y=(g2y+255)/510;

for(i=-maxs:maxs)
    [s index]  = shift_image(i2,i);        %-- shift image and derivs
    [sx index] = shift_image(g2x,i);
    [sy index] = shift_image(g2y,i);
    
    
  
    
    %-- get CSAD and CGRAD
    [s1 ,ssimmap]=   ssim_index(i1, s, win_size);        % -- MJ use SSIM
    [sg1,gxssimmap]= ssim_index(g1x,sx,win_size);   	 % -- MJ use SSIM
    [sg2,gyssimmap]= ssim_index(g1y,sy,win_size);   	 % -- MJ use SSIM
    fssimmap= imfilter(ssimmap,h); 
    fgxssimmap= imfilter(gxssimmap,h); 
    fgyssimmap= imfilter(gyssimmap,h); 
    
    d = 0.5*fssimmap+0.25*fgxssimmap+0.25*fgyssimmap;          %-- total 'difference' score
    d(:,index(1):index(2))=0;
    
    idx = find(d>similarity);          %-- put corresponding disarity
    disparity(idx) = -i;        %   into correct place in image
    
    d1 = 0.5*ssimmap+0.25*gxssimmap+0.25*gyssimmap; 
    similarity(idx) = d(idx); %% filtered ssim and which is combined
    rivalry(idx)=ssimmap(idx);%% original block ssim without filter
    rivalry1(idx)=d1(idx);%% combined ssim without filter
    
    
    
end
end