function [image weight_1]= cyclopean_image(img1,img2,disparity)

[Ref_L_Gabor_RS,Ref_L_Gabor_Bound]=ExtractGaborResponse(img1);
[Syn_R_Gabor_RS,Syn_R_Gabor_Bound]=ExtractGaborResponse(img2);
imsz = size(img1);
RL_en=zeros(imsz(1),imsz(2),2); %4-scales
RS_en=zeros(imsz(1),imsz(2),2); %4-scales
for mm=1:4
    RL_en(:,:,mm) = Ref_L_Gabor_RS{2+mm,1}+Ref_L_Gabor_RS{2+mm,3}+Ref_L_Gabor_RS{2+mm,5}+Ref_L_Gabor_RS{2+mm,7};
    RS_en(:,:,mm) = Syn_R_Gabor_RS{2+mm,1}+Syn_R_Gabor_RS{2+mm,3}+Syn_R_Gabor_RS{2+mm,5}+Syn_R_Gabor_RS{2+mm,7};
end

gabor1 = RL_en(:,:,1) ;
gabor2 = RS_en(:,:,1) ;


c_img=compensated_image(img2,disparity);
c_gabor=compensated_image(gabor2,disparity);

EN_L=gabor1;
EN_R=c_gabor;
imL=img1;
imR=c_img;

minT = min(min(EN_L(:)),min(EN_R(:)));
maxT = max(max(EN_L(:)),max(EN_R(:)));

EN_L=EN_L-minT;
EN_R=EN_R-minT;
EN_L=EN_L+0.01; %%% avoid 0
EN_R=EN_R+0.01; %%%avoid 0
EN_Sum=EN_L+EN_R;


weight_1 = EN_L./EN_Sum;
weight_2 = EN_R./EN_Sum;


image=uint8(double(imL).*weight_1+double(imR).*weight_2);

end