clc; clear all;
%% setups 1 for ROCPCA
n = 100;  pGrid = [200];
r = 3; Sigma = diag([64,36,16]);%diag([100,60,20]);%
sigma2Grid = [0.5,1]; % noise level: sigma squared
sprGrid = [0.04,0.08,0.12];
L = 20;   % outlier magnitude
RESULTS={}
totalRunNum=20;
% fid1=fopen(['./sim1/Estimation_eOrS_n',num2str(n),'p', num2str(pGrid(1)),'.txt'],'w');
% fid2=fopen(['./sim1/Identification_eOrS_n',num2str(n),'p',num2str(pGrid(1)),'.txt'],'w');
% fprintf(fid1,  '%s %-9s %-9s %-9s %-9s %-9s\r\n', 'Result format', 'RRPCA', 'CPCA','PCP','RAPCA','ROBPCA');
% fprintf(fid2,  '%s\r\n', 'Result format (O (M S JD)) (S (M S JD))');
%options for RRPCA
optsRRPCA.record=1; optsRRPCA.ftol=1e-10; optsRRPCA.PVperptol=1e-7; optsRRPCA.initNum=2; optsRRPCA.maxIter=50;
optsRRPCA.initOptNum=1;
optsRRPCA.numbatches=5;
% pars for stiefel manifold optimization
optsStiefel.record=0; optsStiefel.gtol=1e-6;
optsStiefel.ftol=1e-5; optsStiefel.xtol=1e-6;
optsStiefel.maxiter=30; optsStiefel.orth=0;
pIndex = 1
p = pGrid(pIndex); d=p-r;
sigma2Index = 1
sigma2 = sigma2Grid(sigma2Index);
sprIndex =2
spr = sprGrid(sprIndex);
%randn('state', 0); rand('state', 0);
% generate the data matrix according to X=CV^T+O+ (1*mu^T + S)*V_perp^T+E
C=mvnrnd(zeros(r,1),Sigma,n);
V=orth(randn(p)); Vperpo=V(:,r+1:end); V(:,r+1:end)=[];
S=zeros(n,p-r); O=zeros(n,p);
%% 2. element-O + row-S
outlierType=21;
outlierNumS=n*spr/2; qs=ceil(1*n*spr);
outlierLocS=1:outlierNumS;
S(outlierLocS,:)=repmat(L*ones(1,p-r),outlierNumS,1);
outlierNumO=n*p*spr/2; qo=ceil(1*outlierNumO);
perm=randperm(n*p); outlierLocO=perm(1:outlierNumO);
O(outlierLocO)=L;
corrRRPCA = zeros(1,totalRunNum); corrSPCA = zeros(1,totalRunNum);
corrPCP = zeros(1,totalRunNum); corrROBPCA = zeros(1,totalRunNum);
corrRAPCA = zeros(1,totalRunNum); corrCPCA = zeros(1,totalRunNum);
corrGoDec = zeros(1,totalRunNum); corrROSL = zeros(1,totalRunNum);
maskingO = zeros(1,totalRunNum); maskingS = zeros(1,totalRunNum);
swampingO = zeros(1,totalRunNum); swampingS = zeros(1,totalRunNum);
maskNumO=0; maskNumS=0;
runNum = 1
E=mvnrnd(zeros(p,1),sigma2*eye(p),n);
X=C*V'+E; Xe=X+O+S*Vperpo';
%% RRPCA computation
% - estimation
tic;
[hatVperp,hatMu,hatS,hatOu,outinfo] =RRPCA_linear(Xe,r,d,outlierType,qo,qs,optsRRPCA,optsStiefel);
toc
hatPv = eye(p)-hatVperp*hatVperp';   %signal subspace
[hatV,eigValhat,temp]=svds(hatPv,r);
corrRRPCA(runNum) = cos(subspace(hatV,V))