function [Vperp,outinfoStiefel]= StiefelLinear(Vperp, optsStiefel, Xctr,Ou, fixedTerm)
if isfield(optsStiefel, 'maxIter')
    if optsStiefel.maxIter < 0 || optsStiefel.maxIter > 2^20
        optsStiefel.maxIter = 30;
    end
else
    optsStiefel.maxIter = 30;
end
alpha=(0.9/ norm(Xctr-Ou,'fro')^2);
%mom=0.1; % momentum
SLF=(Xctr-Ou)'*(Xctr-Ou);
CRS=(Xctr-Ou)'*fixedTerm;
maxiter=optsStiefel.maxiter;
d=size(fixedTerm,2);
fval0 = norm((Xctr-Ou)*Vperp-fixedTerm,'fro');
lam=[];
lam(1)=0;
Y_prev=zeros(size(Vperp));
for iter=1:maxiter
    Vperp0=Vperp; 
    del=alpha* (SLF*Vperp0-CRS);
    if iter==1
        del0=del;
    end
    Y_s=Vperp0-(del);
    lam(iter+1)=(1+sqrt(4*lam(iter)^2+1))/2;
    W=Y_s-(1-lam(iter))/(lam(iter+1))*[Y_s-Y_prev];
    
    % Find a W that is closest to Vperp but is also orthogonal
    [U2,E2,V2]=svd(W,0);
    Vperp=(U2*V2');
    fval = norm((Xctr-Ou)*Vperp-fixedTerm,'fro');
    fvalDiff=abs(fval0-fval)/(abs(fval0)+1);
    if fvalDiff<optsStiefel.ftol
        outinfoStiefel.msg='preconverge';
        break;
    end
    fval0=fval;
    Y_prev=Y_s;
    %disp(fval)
end

outinfoStiefel.iter=iter;
outinfoStiefel.fval=fval;
if iter>=maxiter
    outinfoStiefel.msg='wentalltheway';
end

end
    

    