function [Vperp,outinfoStiefel]= StiefelLinear2(Vperp, optsStiefel, Xctr, fixedTerm)
alpha=(1/ norm(Xctr,'fro')^2);
mom=0.4; % momentum
SLF=(Xctr)'*(Xctr);
CRS=(Xctr)'*fixedTerm;
maxiter=optsStiefel.maxiter;
d=size(fixedTerm,2);
fval0 = norm((Xctr)*Vperp-fixedTerm,'fro');
for iter=1:maxiter
    Vperp0=Vperp; 
    del=alpha* (SLF*Vperp0-CRS);
    if iter==1
        del0=del;
    end
    W=Vperp0-(del+mom*del0);
    % Find a W that is closest to Vperp but is also orthogonal
    [U2,E2,V2]=svd(W,0);
    Vperp=(U2*V2');
    fval = norm((Xctr)*Vperp-fixedTerm,'fro');
    fvalDiff=abs(fval0-fval)/(abs(fval0)+1);
    if fvalDiff<optsStiefel.ftol
        outinfoStiefel.msg='preconverge';
        break;
    end
    fval0=fval;
    del0=del;
    %disp(fval)
end

outinfoStiefel.iter=iter;
outinfoStiefel.fval=fval;
if iter>=maxiter
    outinfoStiefel.msg='wentalltheway';
end

end
    

    