clear all
clc
S=importdata('yaleB22_P00.info');
X=[];
for i=5:35
    I=imread(string(S{i}));
    I2=imresize(I,1/6);
    X(i,:)=I2(:)';
end
X(1,:)=abs(rand(896,1))*255;  % adding random non-face images
X(2,:)=abs(rand(896,1))*255;
X(3,:)=abs(rand(896,1))*255;
X(4,:)=abs(rand(896,1))*255;
%% PCP first
r=9;
[A_hat E_hat iter] = inexact_alm_rpca(X);
[UY,SY,VY]=svds(A_hat,r);
%imshow(reshape(VY(:,1),32,28),[])
% see the eigenfaces like the above

%% Now R2PCP
optsRRPCA.record=0; optsRRPCA.ftol=1e-6; optsRRPCA.PVperptol=1e-6; optsRRPCA.initNum=10;
% pars for stiefel manifold optimization
optsStiefel.record=0; optsStiefel.gtol=1e-6;
optsStiefel.ftol=1e-8; optsStiefel.xtol=1e-6;
r=9;
qs=4;
qo=25088;
d=896-r;
outlierType=21;   % row type S plus element type O
[hatVperp,hatMu,hatS,hatOu,outinfo] =RRPCA(X,r,d,outlierType,qo,qs,optsRRPCA,optsStiefel);
hatV = null(hatVperp*hatVperp');
hatOutlierLocS=find(sum(hatS.^2,2)~=0); hatOutlierLocO=find(sum(hatOu.^2,2)~=0);
%imshow(reshape(hatV(:,1),32,28),[])
% see the eigenfaces like the above