%   Notes by Yiyuan She (Feb 2017): This is a demo of the robust PCA approach for
%   "Reinforced Robust Principal Component Pursuit" in IEEE-TNNLS, by
%   Brahma, She, Li, Li and Wu. The code was written by Pratik Prabhanjan 
%   Brahma and Shijie Li and is maintained by Dr. Brahma (prprbr@gmail.com). 
%   The code mainly provides the implementations of two algorithms (Alg. 3
%   and Alg 4 in the paper). Currently, Alg 3, which was first proposed in 
%   "Robust Orthogonal Complement Principal Component Analysis" by Yiyuan She, 
%   Shijie Li, and Dapeng Wu, is recommended. In some hard problems, one
%   may want to increase the number of initial starting values, which is
%   set by optsRRPCA.initNum.
%   This only gives a demonstration on a single dataset (instead of checking the
%   average performance on a series of iid datasets). So we set totalRunNum=1. 
%   A loop version of the simulation studies is seen in simulationeOrS.m.
%clc; 
clear all;
rng('default')
rng(0)


%% Set these if simulation, or else get it from the shape of input matrix
n = 100;    % number of obs  
pGrid = [250];   % number of features/variables

%% more parameters describing the data, 
r = 3;    % intrinsic dimensionality, basically the low rank subspace dimension 
Sigma = diag([64,36,16]);  % variance across the 3 principal directions, ignore this if demo
sigma2Grid = [0.5,1]; % Various choices for noise level: sigma squared
sprGrid = [0.04,0.08,0.12]; % Various choices for sparsity level
L = 20;   % outlier magnitude
RESULTS={}
totalRunNum=1;     % number of monte carlo simulations to average the cosine affinity results

%% RRPCA parameters

%options for RRPCA
optsRRPCA.record=1;   % just to print out results while every epoch
optsRRPCA.ftol=1e-10;   % function tolerance  fval=norm((Xctr-Ou)*Vperp-S-ones(n,1)*Mu','fro');
                        % fvalDiff=abs(fval0-fval)/(abs(fval0)+1);
optsRRPCA.PVperptol=5e-7;  % PV tolerance PVperpDiff=max(max(abs(Vperp*Vperp'-Vperp0*Vperp0')))/p;
% POINT TO NOTE
% BOth ftol and especially PVperptol needs to carefully crafted for your
% convergence of the algorithm for each data and each choice of algo too

optsRRPCA.initNum=2;  % initial few trials to see which starting point is best. If not imp, can be set to 1 to make it fast.
optsRRPCA.maxIter=50; % the maximum iterations the main RRPCA algorithm runs for
optsRRPCA.initOptNum=1;  % the actual number of the initNum trials you choose the proceed with, please always keep 1
optsRRPCA.numbatches=5; % to be used for batch processing

%% Manifold optimization parameters
% Lets not mess much with these
% For both OptStiefelAFBB and StiefelLinear, the same parameter struct
optsStiefel.record=0;  % do not output the results of individual iterations in each manopt
optsStiefel.gtol=1e-6; % only used by  OptStiefelAFBB
optsStiefel.ftol=1e-5; % only used by  OptStiefelAFBB
optsStiefel.xtol=1e-6; % only used by  OptStiefelAFBB as per the ManOPt package
optsStiefel.maxiter=30; % max number iterations a manifold opt algorithm can run for
optsStiefel.orth=0;   % used in the batch version BatchStiefelLinear
optsStiefel.method2choose=3;  % 3 refers to Alg 3 ManOpt, 4 for Alg 4 linear+PR, 5 for batch version


%% Following is to generate the simulated data, ignore for Demo data

p = pGrid(1); d=p-r;   % d is the dimensionality of the OC subspace
sigma2Index = 1  % which noise variance to choose, high(2) or low (1)
sigma2 = sigma2Grid(sigma2Index);
sprIndex =2    % which sparsity level to choose
spr = sprGrid(sprIndex); 
%randn('state', 0); rand('state', 0);
% generate the data matrix according to X=CV^T+O+ (1*mu^T + S)*V_perp^T+E
C=mvnrnd(zeros(r,1),Sigma,n);
V=orth(randn(p)); Vperpo=V(:,r+1:end); V(:,r+1:end)=[];
S=zeros(n,p-r); O=zeros(n,p);   % initialize the matrices required for the equation
outlierType=21;   % everything is specifically for eOrS type of R2PCP set up only
outlierNumS=n*spr/2; qs=ceil(1*n*spr);
outlierLocS=1:outlierNumS;
S(outlierLocS,:)=repmat(L*ones(1,p-r),outlierNumS,1);
outlierNumO=n*p*spr/2; qo=ceil(1*outlierNumO);
perm=randperm(n*p); outlierLocO=perm(1:outlierNumO);
O(outlierLocO)=L;
% now both the outlier matrices O and S are created
corrRRPCA = zeros(1,totalRunNum);  % to record the cosine affinity results

% IF you want to compute the masking results
maskingO = zeros(1,totalRunNum); maskingS = zeros(1,totalRunNum);
swampingO = zeros(1,totalRunNum); swampingS = zeros(1,totalRunNum);
maskNumO=0; maskNumS=0;
runNum = 1
% Now actually add the matrices to get the simulation data
E=mvnrnd(zeros(p,1),sigma2*eye(p),n);  % generate noise
X=C*V'+E; % data without the observation space outliers
Xe=X+O+S*Vperpo';  % noisy and outlier filled simulated data

%% If this is a demo, then these needs to be computed from arguments given by user
% the user provides Xe, r, qo, qs and 
% sets up optsStiefel and  optsRRPCA or  uses defaults values

% note that n, d, p, can all be calculated using the shape of Xe and r.
tic;
[hatVperp,hatMu,hatS,hatOu,outinfo] =RRPCA_linear(Xe,r,d,outlierType,qo,qs,optsRRPCA,optsStiefel);
% What I am printing for each iteration is [ iter, fval, fvalDiff, PVperpDiff]
toc

hatPv = eye(p)-hatVperp*hatVperp';   % compute the signal subspace from the estimated V_perp
[hatV,eigValhat,temp]=svds(hatPv,r);   % get the principal components which you will compare with the true PCs
corrRRPCA(runNum) = cos(subspace(hatV,V))  % this requires that you know the true low rank subspace, if not it doesn;t make sense to compute cosine affinity
