function [mu,O,S] = uOSopt(X,Vperp,outlierType,qo,qs,initOpt)
% FUNCTION: (mu,O,S)-optimization solver
% INPUT:
%   X: data
%   Vperp: orthogonal complement basis
%   outlierType: 1-row O ans row S; 2-element O and row S
% OUTPUT: estimators

n = size(X,1); [p,d] = size(Vperp);
Minner = 100; Moutter = 500;
tolInner=1e-3; tolOutter=1e-6;
if isfield(initOpt, 'mu0'); mu0=initOpt.mu0; else mu0=zeros(d,1); end
if isfield(initOpt, 'O0');  O0=initOpt.O0;   else O0=zeros(n,p); end
if isfield(initOpt, 'S0');  S0=initOpt.S0;   else S0=zeros(n,d); end

switch outlierType
    case 11  % row O + row S
        XVperp = X*Vperp; D = [Vperp;eye(d)]; alpha = 1/(norm(D,2)^2);
        Gamma0 = [O0,S0]; Gamma1=Gamma0; mu1=mu0;
        k=0; q=qo; zeroNum=n-q;
        while 1
            k=k+1; mu0=mu1; Gamma0=Gamma1; % update for outter iterations
            % inner iteration
            j=0; Gamma0bar=Gamma0; Gamma1bar=Gamma0bar; %initialization for inner iterations
            while 1
                j=j+1; Gamma0bar = Gamma1bar;
                Gamma1bar = Gamma0bar-alpha*(Gamma0bar*D+ones(n,1)*mu0'-XVperp)*D';
                rowSum = sum(Gamma1bar.^2,2); [sortedSum,idx] = sort(rowSum);
                Gamma1bar(idx(1:zeroNum),:) = zeros(zeroNum,(p+d));
                if(j>Minner || norm(Gamma1bar-Gamma0bar,'fro')<tolInner)
                    break;
                end
            end
            Gamma1 = Gamma1bar; mu1 = mean(XVperp-Gamma1*D)';
            if(k>Moutter || norm(Gamma1-Gamma0,'fro')<tolOutter)
                break;
            end
        end
        O1=Gamma1(:,1:p); S1=Gamma1(:,(p+1):end);
        
    case 12  % element O + element S (jointly)
        XVperp = X*Vperp; D = [Vperp;eye(d)]; alpha = 1/(norm(D,2)^2);
        Gamma0 = [O0,S0]; Gamma1=Gamma0; mu1=mu0;
        k=0; q=qo+qs; zeroNum=n*(p+d)-q;
        while 1
            k=k+1; mu0=mu1; Gamma0=Gamma1; % update for outter iterations
            % inner iteration
            j=0; Gamma0bar=Gamma0; Gamma1bar=Gamma0bar; %initialization for inner iterations
            while 1
                j=j+1; Gamma0bar = Gamma1bar;
                Gamma1bar = (Gamma0bar-alpha*(Gamma0bar*D+ones(n,1)*mu0'-XVperp)*D');
                [sortedSum,idx] = sort(abs(Gamma1bar(:)));
                Gamma1bar(idx(1:zeroNum)) = 0;
                if(j>Minner || norm(Gamma1bar-Gamma0bar,'fro')<tolInner)
                    break;
                end
            end
            
            Gamma1 = Gamma1bar; mu1 = mean(XVperp-Gamma1*D)';
            if(k>Moutter || norm(Gamma1-Gamma0,'fro')<tolOutter)
                break;
            end
        end
        O1=Gamma1(:,1:p); S1=Gamma1(:,(p+1):end);
        
    case 13 % element O + element S (seperately)
        O1=O0; S1=S0;
        k=0; zeroNumS=(n*d-qs); zeroNumO=(n*p-qo);
        while 1
            k=k+1; O0=O1; S0=S1;
            % mu+S update
            j=0; S0bar=S0; S1bar=S0bar;
            XOVperp=(X-O0)*Vperp;
            while 1
                j=j+1; S0bar=S1bar;
                S1bar=(XOVperp-ones(n,1)*mean(XOVperp-S0bar))/1.01; [sortedSum,idx]=sort(abs(S1bar(:)));
                
                S1bar(idx(1:zeroNumS))=0;
                if(j>Minner || norm(S1bar-S0bar,'fro')<tolInner)
                    break;
                end
            end
            S1=S1bar; mu1=mean(XOVperp-S1)';
            % O update
            j=0; O0bar=O0; O1bar=O0bar;
            Pv=eye(p)-Vperp*Vperp'; fixedTerm=(X*Vperp-ones(n,1)*mu1'-S1)*Vperp';
            while 1
                j=j+1; O0bar=O1bar;
                O1bar=(O0bar*Pv+fixedTerm)/1.01; [sortedSum,idx]=sort(abs(O1bar(:)));
                O1bar(idx(1:zeroNumO))=0;
                if(j>Minner || norm(O1bar-O0bar,'fro')<tolInner)
                    break;
                end
            end
            O1=O1bar;
            % stopping criteria
            if(k>Moutter || (norm(S1-S0,'fro')<tolOutter && norm(O1-O0,'fro')<tolOutter))
                break;
            end
        end
        
    case 21  % element O + row S
        O1=O0; S1=S0;
        k=0; zeroNumS=(n-qs); zeroNumO=(n*p-qo);
        while 1
            k=k+1; O0=O1; S0=S1;
            % mu+S update
            j=0; S0bar=S0; S1bar=S0bar;
            XOVperp=(X-O0)*Vperp;
            while 1
                j=j+1; S0bar=S1bar;
                S1bar = XOVperp-ones(n,1)*mean(XOVperp-S0bar);
                rowSum = sum(S1bar.^2,2); [sortedSum,idx] = sort(rowSum);
                S1bar(idx(1:zeroNumS),:) = zeros(zeroNumS,d);
                if(j>Minner || norm(S1bar-S0bar,'fro')<tolInner)
                    break;
                end
            end
            S1=S1bar; mu1=mean(XOVperp-S1)';
            % O update
            j=0; O0bar=O0; O1bar=O0bar;
            %Pv=eye(p)-Vperp*Vperp'; fixedTerm=(X*Vperp-ones(n,1)*mu1'-S1)*Vperp';
            %alpha=0.1/norm(Vperp);
            alpha=1;
            Pv=eye(p)-alpha*Vperp*Vperp'; fixedTerm=alpha*(X*Vperp-ones(n,1)*mu1'-S1)*Vperp';
            while 1
                j=j+1; O0bar=O1bar;
                O1bar = O0bar*Pv+fixedTerm; [sortedSum,idx] = sort(abs(O1bar(:)));
                O1bar(idx(1:zeroNumO))=0;
                if(j>Minner || norm(O1bar-O0bar,'fro')<tolInner)
                    break;
                end
            end
            O1=O1bar;
            % stopping criteria
            if(k>Moutter || (norm(S1-S0,'fro')<tolOutter && norm(O1-O0,'fro')<tolOutter))
                break;
            end
        end
        
    case 22  % row O + element S
        O1=O0; S1=S0; mu1=mu0;
        k=0; zeroNumS=(n*d-qs); zeroNumO=(n-qo);
        while 1
            k=k+1; O0=O1; S0=S1;
            % O update
            j=0; O0bar=O0; O1bar=O0bar;
            Pv=eye(p)-Vperp*Vperp'; fixedTerm=(X*Vperp-ones(n,1)*mu1'-S1)*Vperp';
            while 1
                j=j+1; O0bar=O1bar;
                O1bar = (O0bar*Pv+fixedTerm); 
                rowSum = sum(O1bar.^2,2); [sortedSum,idx] = sort(rowSum);
                O1bar(idx(1:zeroNumO),:) = zeros(zeroNumO,p);
                if(j>Minner || norm(O1bar-O0bar,'fro')<tolInner)
                    break;
                end
            end
            O1=O1bar;
            
            % mu+S update
            j=0; S0bar=S0; S1bar=S0bar;
            XOVperp=(X-O1)*Vperp;
            while 1
                j=j+1; S0bar=S1bar;
                S1bar = (XOVperp-ones(n,1)*mean(XOVperp-S0bar));
                [sortedSum,idx] = sort(abs(S1bar(:)));
                S1bar(idx(1:zeroNumS))=0;
                if(j>Minner || norm(S1bar-S0bar,'fro')<tolInner)
                    break;
                end
            end
            S1=S1bar; mu1=mean(XOVperp-S1)';
            
            % stopping criteria
            if(k>Moutter || (norm(S1-S0,'fro')<tolOutter && norm(O1-O0,'fro')<tolOutter))
                break;
            end
        end
        
    otherwise
        fprintf('Check outlier type combination! No such combination!')
        
end
mu=mu1; O=O1; S=S1;
end