clc; clear all;
%% MAC directory style
% addpath('../../ROCPCA/Code/FOptM-WotaoYin/'); addpath('../../ROCPCA/Code/LIBRA_31okt11');
% addpath('../../ROCPCA/Code/PCP/'); addpath('../../ROCPCA/Code/PCP/PROPACK/');

% %% setups 1 for RPCA
n = 50;  pGrid = [15,50,100];
r = 3; Sigma = diag([64,36,9]);%diag([100,60,20]);%
sigma2Grid = [0.5];%[0.5,1]; % noise level: sigma squared
sprGrid = [0.04, 0.1];
L = 20;   % outlier magnitude

% %% setups 2 for ROBPCA to fail
% n = 500;  pGrid = [15];
% r = 3; Sigma = diag([64,36,9]);%diag([100,60,20]);%
% sigma2Grid = [0.001];% noise level: sigma squared
% sprGrid = [0.004];
% L = 20;   % outlier magnitude


totalRunNum=2;

% fid1=fopen(['./sim1/Estimation_rOrS_n',num2str(n),'p',num2str(pGrid(1)),'.txt'],'w');
% fid2=fopen(['./sim1/Identification_rOrS_n',num2str(n),'p',num2str(pGrid(1)),'.txt'],'w');
% fprintf(fid1,  '%s %-9s %-9s %-9s %-9s %-9s\r\n', 'Result format', 'RRPCA', 'CPCA','PCP','RAPCA','ROBPCA');
% fprintf(fid2,  '%s\r\n', 'Result format (O (M S JD)) (S (M S JD))');

%options for RRPCA
optsRRPCA.record=0; optsRRPCA.ftol=1e-6; optsRRPCA.PVperptol=1e-6; optsRRPCA.initNum=10;
% pars for stiefel manifold optimization
optsStiefel.record=0; optsStiefel.gtol=1e-6;
optsStiefel.ftol=1e-8; optsStiefel.xtol=1e-6;


for pIndex = 1:size(pGrid,2)
    p = pGrid(pIndex); d=p-r;
    for sigma2Index = 1:size(sigma2Grid,2)
        sigma2 = sigma2Grid(sigma2Index);
%         fprintf(fid1,'%s %3.0f %s %2.0f %s %2.2f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);
%         fprintf(fid2,'%s %3.0f %s %2.0f %s %2.2f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);

        for sprIndex = 1:size(sprGrid,2)    % choices of sparsity ratio
            spr = sprGrid(sprIndex);           
            
            randn('state', 0); rand('state', 0);
            % generate the data matrix according to X=CV^T+O+ (1*mu^T + S)*V_perp^T+E
            C=mvnrnd(zeros(r,1),Sigma,n);
            %             U = orth(randn(n,r));
            V=orth(randn(p)); Vperp=V(:,r+1:end); V(:,r+1:end)=[];
            S=zeros(n,p-r); O=zeros(n,p);
            %% 1. row-O + row-S
            outlierType=11; q = ceil(1.5*n*spr); qo=q; qs=q;
            outlierNumS = floor(n*spr/2); outlierNumO = n*spr-outlierNumS;
            outlierLocS = 1:outlierNumS; outlierLocO = (outlierNumS+1):(n*spr);
            outlierLocGamma=union(outlierLocS,outlierLocO); outlierNumGamma=length(outlierLocGamma);
            S(outlierLocS,:)=repmat(L*ones(1,p-r),outlierNumS,1);
            O(outlierLocO,:)=repmat(L*ones(1,p),outlierNumO,1);
            
            
            fprintf('%s %3.0f %s %2.0f %s %2.2f %s %2.2f  %s %3.0f\r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2, 'spr = ',spr,'q = ',q);
            
            corrRRPCA = zeros(1,totalRunNum); corrSPCA = zeros(1,totalRunNum);
            corrPCP = zeros(1,totalRunNum); corrROBPCA = zeros(1,totalRunNum);
            corrRAPCA = zeros(1,totalRunNum); corrCPCA = zeros(1,totalRunNum);
            
            maskingO = zeros(1,totalRunNum);  swampingO = zeros(1,totalRunNum);
            maskingS = zeros(1,totalRunNum);  swampingS = zeros(1,totalRunNum);
            maskingGamma = zeros(1,totalRunNum);  swampingGamma = zeros(1,totalRunNum);
            
            maskNumO=0; maskNumS=0;maskNumGamma=0; JDO=0; JDS=0; JDGamma=0;
            for runNum = 1:totalRunNum
                E=mvnrnd(zeros(p,1),sigma2*eye(p),n);
                X=C*V'+E; 
                Xe=X+O+S*Vperp';
                
                %% RRPCA computation
                % - estimation
                [hatVperp,hatMu,hatS,hatOu,outinfo] =RRPCA(Xe,r,d,outlierType,qo,qs,optsRRPCA,optsStiefel);
                hatV = null(hatVperp*hatVperp');   %signal subspace
                corrRRPCA(runNum) = cos(subspace(hatV,V));
                disp([num2str(runNum),': RRPCA:Final correlation:',num2str(100*corrRRPCA(runNum))]);
                
                % - outlier detection
                hatOutlierLocS=find(sum(hatS.^2,2)~=0); hatOutlierLocO=find(sum(hatOu.^2,2)~=0);
                maskingS(runNum) = 1-sum(intersect(outlierLocS,hatOutlierLocS)~=0)/outlierNumS;
                swampingS(runNum) = sum(setdiff(hatOutlierLocS,outlierLocS)~=0)/(n-outlierNumS);
                maskingO(runNum) = 1-sum(intersect(outlierLocO,hatOutlierLocO)~=0)/outlierNumO;
                swampingO(runNum) = sum(setdiff(hatOutlierLocO,outlierLocO)~=0)/(n-outlierNumO);
                hatGamma=[hatOu,hatS];
                hatOutlierLocGamma=find(sum(hatGamma.^2,2)~=0); 
                maskingGamma(runNum)=1-sum(intersect(outlierLocGamma,hatOutlierLocGamma)~=0)/outlierNumGamma;
                swampingGamma(runNum) = sum(setdiff(hatOutlierLocGamma,outlierLocGamma)~=0)/(n-outlierNumGamma);

                
                
                
                if maskingO(runNum)==0; maskNumO = maskNumO+1; end
                if maskingS(runNum)==0; maskNumS = maskNumS+1; end
                if maskingGamma(runNum)==0; maskNumGamma = maskNumGamma+1; end
%                 
                %% compare with other algorithms
                % - test PCP algorithm
                if size(Xe,1)>=size(Xe,2)
                    [A_hat E_hat iter] = inexact_alm_rpca(Xe);
                
                    [UY,SY,VY]=svds(A_hat,r);   %Y stands for Yi Ma's work
                else
                    [A_hat E_hat iter] = inexact_alm_rpca(Xe');
                    [UY,SY,VY]=svds(A_hat',r);   %Y stands for Yi Ma's work
                end
                
                corrPCP(runNum) = cos(subspace(VY,V));
                disp([num2str(runNum),': PCP:Final correlation:',num2str(100*corrPCP(runNum))]);
%                 
                % - test RAPCA algorithm
                result=rapca(Xe,'k',r,'plots',0);
                corrRAPCA(runNum) = cos(subspace(result.P,V));
                disp([num2str(runNum),': RAPCA:Final correlation:',num2str(100*corrRAPCA(runNum))]);
%                 
%                 
%                 % - test ROBPCA algorithm
%                 result=robpca(Xe,'k',r,'plots',0);
%                 corrROBPCA(runNum) = cos(subspace(result.P,V));
%                 disp([num2str(runNum),': ROBPCA:Final correlation:',num2str(100*corrROBPCA(runNum))]);
                
%                 % test spherical PCA algorithm
%                 VS=sphericalPCA(Xe,r);
%                 corrSPCA(runNum) = cos(subspace(VS,V));
%                 disp([num2str(runNum),': SPCA:Final correlation:',num2str(100*corrSPCA(runNum))]);

                
                % - test CPCA algorithm
                [UC,SC,VC]=svds(Xe,r);
                corrCPCA(runNum) = cos(subspace(VC,V));
                disp([num2str(runNum),': PCA:Final correlation:',num2str(100*corrCPCA(runNum))]);
            end
%             JDS=maskNumS/runNum; JDO=maskNumO/runNum;JDGamma=maskNumGamma/runNum;
%             fprintf('%-6s %s %1.6f\r\n',  'RRPCA',   ':',  100*mean(corrRRPCA));
%             fprintf('%-6s %s %1.6f\r\n',  'CPCA  ',       ':',  100*mean(corrCPCA));
%             fprintf('%-6s %s %1.6f\r\n',  'PCP   ',         ':',  100*mean(corrPCP));
%             fprintf('%-6s %s %1.6f\r\n',  'RAPCA ',     ':',  100*mean(corrRAPCA));
%             fprintf('%-6s %s %1.6f\r\n',  'ROBPCA',   ':',  100*mean(corrROBPCA));
%             fprintf(fid1, '& %3.2f & %3.2f & %3.2f & %3.2f & %3.2f \\\\ \n', 100*mean(corrRRPCA),100*mean(corrCPCA),100*mean(corrPCP),100*mean(corrRAPCA),100*mean(corrROBPCA));
%             fprintf(fid2, '& %1.3f & %1.3f & %1.3f \\\\ \n', mean(maskingGamma),mean(swampingGamma),JDGamma);
disp('for RRPCA, mean is') 
fprintf('%3.2f\n',100*mean(corrRRPCA));
disp('for PCP, mean is') 
fprintf('%3.2f\n',100*mean(corrPCP));
disp('for RAPCA, mean is') 
fprintf('%3.2f\n',100*mean(corrRAPCA));


        end
    end
end
% fclose(fid1); fclose(fid2);



