clc; clear all;
%% MAC directory style
%addpath('../../ROCPCA/Code/FOptM-WotaoYin/'); addpath('../../ROCPCA/Code/LIBRA_31okt11');
%addpath('../../ROCPCA/Code/PCP/'); addpath('../../ROCPCA/Code/PCP/PROPACK/');

%% setups 1 for ROCPCA
n = 100;  pGrid = [15,50];
r = 3; Sigma = diag([64,36,16]);%diag([100,60,20]);%
sigma2Grid = [0.5];%[0.5,1]; % noise level: sigma squared
sprGrid = [0.04,0.08];
L = 20;   % outlier magnitude

totalRunNum=2;

% fid1=fopen(['./sim/Estimation_rOeS_n',num2str(n),'p', num2str(pGrid(1)),'.txt'],'w');
% fid2=fopen(['./sim/Identification_rOeS_n',num2str(n),'p',num2str(pGrid(1)),'.txt'],'w');
% fid3=fopen(['./sim/Estimation_rOeS_n',num2str(n),'p', num2str(pGrid(1)),'MiddleResult.txt'],'w');
% 
% fprintf(fid1,  '%s %-9s %-9s %-9s %-9s %-9s\r\n', 'Result format', 'RRPCA', 'CPCA','PCP','RAPCA','ROBPCA');
% fprintf(fid2,  '%s\r\n', 'Result format (O (M S JD)) (S (M S JD))');
% fprintf(fid3,  '%s %-9s %-9s %-9s %-9s %-9s\r\n', 'Result format', 'RRPCA','PCP','RAPCA','ROBPCA', 'CPCA');

%options for RRPCA
optsRRPCA.record=0; optsRRPCA.ftol=1e-6; optsRRPCA.PVperptol=1e-6;
optsRRPCA.initNum=10; optsRRPCA.initOptNum=2
% pars for stiefel manifold optimization
optsStiefel.record=0; optsStiefel.gtol=1e-6;
optsStiefel.ftol=1e-8; optsStiefel.xtol=1e-6;


for pIndex = 1:size(pGrid,2)
    p = pGrid(pIndex); d=p-r;
    for sigma2Index = 1:size(sigma2Grid,2)
        sigma2 = sigma2Grid(sigma2Index);
%         fprintf(fid1,'\r\n\r\n%s %3.0f %s %2.0f %s %2.2f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);
%         fprintf(fid2,'\r\n\r\n%s %3.0f %s %2.0f %s %2.2f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);
%         fprintf(fid3,'\r\n\r\n%s %3.0f %s %2.0f %s %2.2f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);
        
        for sprIndex = 1:size(sprGrid,2)    % choices of sparsity ratio
            spr = sprGrid(sprIndex);
%             fprintf(fid3,'\r\n%s %1.3f \r\n','spr=',spr);
            randn('state', 0); rand('state', 0);
            % generate the data matrix according to X=CV^T+O+ (1*mu^T + S)*V_perp^T+E
            C=mvnrnd(zeros(r,1),Sigma,n);
            V=orth(randn(p)); Vperp=V(:,r+1:end); V(:,r+1:end)=[];
            S=zeros(n,d); O=zeros(n,p);
            
            %% 2. row-O + element-S
            outlierType=22;
            
            outlierNumO=ceil(n*spr/2); qo=ceil(1.5*outlierNumO);
            outlierLocO=1:outlierNumO;
            O(outlierLocO,:)=repmat(L*ones(1,p),outlierNumO,1);
            
            outlierNumS=ceil(n*d*spr/2); qs=ceil(1.5*outlierNumS);
            perm=randperm(n*d); outlierLocS=perm(1:outlierNumS);
            S(outlierLocS)=L;
            
            fprintf('%s %3.0f %s %2.0f %s %2.2f %s %2.2f  %s %3.0f\r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2, 'spr = ',spr,'qo = ',qo);
            
            corrRRPCA = zeros(1,totalRunNum); corrSPCA = zeros(1,totalRunNum);
            corrPCP = zeros(1,totalRunNum); corrROBPCA = zeros(1,totalRunNum);
            corrRAPCA = zeros(1,totalRunNum); corrCPCA = zeros(1,totalRunNum);
            
            maskingO = zeros(1,totalRunNum); maskingS = zeros(1,totalRunNum);
            swampingO = zeros(1,totalRunNum); swampingS = zeros(1,totalRunNum);
            maskNumO=0; maskNumS=0;
            for runNum = 1:totalRunNum
                E=mvnrnd(zeros(p,1),sigma2*eye(p),n);
                X=C*V'+E; Xe=X+O+S*Vperp';
                
                %% RRPCA computation
                % - estimation
                [hatVperp,hatMu,hatS,hatOu,outinfo] =RRPCA(Xe,r,d,outlierType,qo,qs,optsRRPCA,optsStiefel);
                hatPv = eye(p)-hatVperp*hatVperp';   %signal subspace
                [hatV,eigValhat,temp]=svds(hatPv,r);
                corrRRPCA(runNum) = cos(subspace(hatV,V));
                disp([num2str(runNum),': RRPCA:Final correlation:',num2str(100*corrRRPCA(runNum))]);
%                 
%                 % - outlier detection
%                 hatOutlierLocO=find(sum(hatOu.^2,2)~=0);
%                 maskingO(runNum) = 1-sum(intersect(outlierLocO,hatOutlierLocO)~=0)/outlierNumO;
%                 swampingO(runNum) = sum(setdiff(hatOutlierLocO,outlierLocO)~=0)/(n-outlierNumO);
%                 
%                 
%                 hatOutlierLocS=find(hatS~=0); Stmp=S; Stmp(hatOutlierLocO,:)=zeros(qo,d);
%                 outlierLocS_revised=find(Stmp~=0);
%                 maskingS(runNum) = 1-sum(intersect(outlierLocS_revised,hatOutlierLocS)~=0)/nnz(outlierLocS_revised);
%                 swampingS(runNum) = sum(setdiff(hatOutlierLocS,outlierLocS_revised)~=0)/(n*d-nnz(outlierLocS_revised));
%                 
%                 
%                 
%                 if maskingO(runNum)==0; maskNumO = maskNumO+1; end
%                 if maskingS(runNum)==0; maskNumS = maskNumS+1; end
%                 
                %% compare with other algorithms
                % - test Yi Ma's algorithm
                lambda=1/sqrt(max(size(Xe)));

                if size(Xe,1)>=size(Xe,2)
                    [A_hat E_hat iter] = inexact_alm_rpca(Xe,lambda);
                
                    [UY,SY,VY]=svds(A_hat,r);   %Y stands for Yi Ma's work
                else
                    [A_hat E_hat iter] = inexact_alm_rpca(Xe',lambda);
                    [UY,SY,VY]=svds(A_hat',r);   %Y stands for Yi Ma's work
                end
                corrPCP(runNum) = cos(subspace(VY,V));
                disp([num2str(runNum),': PCP:Final correlation:',num2str(100*corrPCP(runNum))]);
%                 
%                 % - test RAPCA algorithm
%                 result=rapca(Xe,'k',r,'plots',0);
%                 corrRAPCA(runNum) = cos(subspace(result.P,V));
%                 disp([num2str(runNum),': RAPCA:Final correlation:',num2str(100*corrRAPCA(runNum))]);
%                 
%                 
%                 % - test ROBPCA algorithm
%                 result=robpca(Xe,'k',r,'plots',0);
%                 corrROBPCA(runNum) = cos(subspace(result.P,V));
%                 disp([num2str(runNum),': ROBPCA:Final correlation:',num2str(100*corrROBPCA(runNum))]);

%                 % test spherical PCA algorithm
%                 VS=sphericalPCA(Xe,r);
%                 corrSPCA(runNum) = cos(subspace(VS,V));
% %                 disp([num2str(runNum),': SPCA:Final correlation:',num2str(100*corrSPCA(runNum))]);
                 
%                 
%                 % - test CPCA algorithm
%                 [UC,SC,VC]=svds(Xe,r);
%                 corrCPCA(runNum) = cos(subspace(VC,V));
%                 disp([num2str(runNum),': PCA:Final correlation:',num2str(100*corrCPCA(runNum))]);
%                 % write intermidiate results
%                 fprintf(fid3, '%3d: %3.2f & %3.2f & %3.2f & %3.2f & %3.2f \\\\ \r\n', runNum, 100*corrRRPCA(runNum),100*corrPCP(runNum),100*corrRAPCA(runNum),100*corrROBPCA(runNum),100*corrCPCA(runNum));
                
            end
%             JDS=maskNumS/runNum; JDO=maskNumO/runNum;
%             fprintf('%-6s %s %1.6f\r\n',  'RRPCA',   ':',  100*mean(corrRRPCA));
%             fprintf('%-6s %s %1.6f\r\n',  'CPCA  ',       ':',  100*mean(corrCPCA));
%             fprintf('%-6s %s %1.6f\r\n',  'PCP   ',         ':', 100*mean(corrPCP));
%             fprintf('%-6s %s %1.6f\r\n',  'RAPCA ',     ':',  100*mean(corrRAPCA));
%             fprintf('%-6s %s %1.6f\r\n',  'ROBPCA',   ':',  100*mean(corrROBPCA));
%             fprintf(fid1, '& %3.2f & %3.2f & %3.2f & %3.2f & %3.2f \\\\ \r\n', 100*mean(corrRRPCA),100*mean(corrCPCA),100*mean(corrPCP),100*mean(corrRAPCA),100*mean(corrROBPCA));
%             fprintf(fid2, '& %1.3f & %1.3f & %1.3f & %1.3f & %1.3f & %1.3f \\\\ \r\n', mean(maskingO),mean(swampingO),JDO,mean(maskingS),mean(swampingS),JDS);
 %fprintf('%3.2f\n',100*mean(corrPCP));
  disp('for RRPCA, mean is') 
fprintf('%3.2f\n',100*mean(corrRRPCA));
disp('for PCP, mean is') 
fprintf('%3.2f\n',100*mean(corrPCP));
        end
    end
end
% fclose(fid1); fclose(fid2); fclose(fid3);



