clc; clear all;
%% MAC directory style
addpath('../../ROCPCA/Code/FOptM-WotaoYin/'); addpath('../../ROCPCA/Code/LIBRA_31okt11');
addpath('../../ROCPCA/Code/PCP/'); addpath('../../ROCPCA/Code/PCP/PROPACK/');

%% setups 1 for ROCPCA
n=50; pGrid=[1000]; batchNumSequence=[200,200,200,200,100,97];
r=3; Sigma=diag([64,36,16]); sigma2Grid=[0.001];
sprGrid=[0.04]; L=20;   

totalRunNum=10;

% fid1=1; fid2=1; fid3=1;
fid1=fopen(['./sim/batchVS_Estimation_eOrS_n',num2str(n),'p', num2str(pGrid(1)),'.txt'],'w');
fid2=fopen(['./sim/batchVS_Identification_eOrS_n',num2str(n),'p',num2str(pGrid(1)),'.txt'],'w');
fid3=fopen(['./sim/batchVS_Estimation_eOrS_n',num2str(n),'p', num2str(pGrid(1)),'MiddleResult.txt'],'w');

fprintf(fid1,  '%s %-9s %-9s %s %s\r\n', 'Format:', 'RRPCA_batch', 'RRPCA','time(RRPCA_batchV)','time(RRPCA)');
fprintf(fid2,  '%s\r\n', 'Result format (O (M S JD)) (S (M S JD))');
fprintf(fid3,  '%s %-9s %-9s %s %s %s %s %s\r\n', 'Format:', 'RRPCA_batch', 'RRPCA','time(RRPCA_batchV)','time(RRPCA)','M','JD','S');

%options for RRPCA
optsRRPCA.record=1; optsRRPCA.ftol=1e-4; optsRRPCA.PVperptol=1e-6; 
optsRRPCA.initNum=5; optsRRPCA.initOptNum=2;

% pars for stiefel manifold optimization
optsStiefel.record=0; optsStiefel.gtol=1e-6;
optsStiefel.ftol=1e-8; optsStiefel.xtol=1e-6;

for pIndex = 1:size(pGrid,2)
    p = pGrid(pIndex); d=p-r;
    for sigma2Index = 1:size(sigma2Grid,2)
        sigma2 = sigma2Grid(sigma2Index);
        fprintf(fid1,'%s %3.0f %s %2.0f %s %2.5f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);
        fprintf(fid2,'%s %3.0f %s %2.0f %s %2.5f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);
        fprintf(fid3,'\r\n\r\n%s %3.0f %s %2.0f %s %2.5f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);
        
        for sprIndex = 1:size(sprGrid,2)    % choices of sparsity ratio
            spr = sprGrid(sprIndex);
            fprintf(fid3,'\r\n%s %1.3f \r\n','spr=',spr);
            
            randn('state', 0); rand('state', 0);
            % generate the data matrix according to X=CV^T+O+ (1*mu^T + S)*V_perp^T+E
            C=mvnrnd(zeros(r,1),Sigma,n);
            V=orth(randn(p)); Vperp=V(:,r+1:end); V(:,r+1:end)=[];
            S=zeros(n,p-r); O=zeros(n,p);
            
            %% 2. element-O + row-S
            outlierType=21;
            
            outlierNumS=n*spr; qs=ceil(1.5*n*spr);
            outlierLocS=1:outlierNumS;
            S(outlierLocS,:)=repmat(L*ones(1,p-r),outlierNumS,1);
            
            outlierNumO=n*p*spr/2; qo=ceil(1.5*outlierNumO);
            perm=randperm(n*p); outlierLocO=perm(1:outlierNumO);
            O(outlierLocO)=L;
            
            fprintf('%s %4.0f %s %4.0f %s %2.5f %s %2.5f  %s %3.0f\r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2, 'spr = ',spr,'qo = ',qo);
            
            corrRRPCAbatchV=zeros(1,totalRunNum); corrRRPCA=zeros(1,totalRunNum);
            timeRRPCA_batchV=zeros(1,totalRunNum); timeRRPCA=zeros(1,totalRunNum);
            
            maskingO = zeros(1,totalRunNum); maskingS = zeros(1,totalRunNum);
            swampingO = zeros(1,totalRunNum); swampingS = zeros(1,totalRunNum);
            maskNumO=0; maskNumS=0;
            for runNum = 1:totalRunNum
                fprintf('%s %4d \r\n','----------------------- run#:',runNum);
                E=mvnrnd(zeros(p,1),sigma2*eye(p),n);
                X=C*V'+E; Xe=X+O+S*Vperp';
                
                %% RRPCA computation
                % - estimation
                tic
%                 [hatVperp,hatV,hatMu,hatS,hatOu] = RRPCA_batchVS(X,d,batchNumSequence,outlierType,qo,qs);
                [hatVperp,hatV,hatMu,hatS,hatOu]=RRPCA_batchVS(Xe,d,batchNumSequence,outlierType,qo,qs,optsRRPCA);
                timeRRPCA_batchV(runNum)=toc;
                %                 [hatVperp,hatMu,hatS,hatOu,outinfo] =RRPCA(Xe,r,d,outlierType,qo,qs,optsRRPCA,optsStiefel);
                %                 hatPv = eye(p)-hatVperp*hatVperp';   %signal subspace
                %                 [hatV,eigValhat,temp]=svds(hatPv,r);
                corrRRPCAbatchV(runNum) = cos(subspace(hatV,V));
                disp([num2str(runNum),': RRPCA_batchV:Final correlation:',num2str(100*corrRRPCAbatchV(runNum))]);
                
                % - outlier detection
                hatOutlierLocS=find(sum(hatS.^2,2)~=0); hatOutlierLocO=find(hatOu~=0);
                maskingS(runNum) = 1-sum(intersect(outlierLocS,hatOutlierLocS)~=0)/outlierNumS;
                swampingS(runNum) = sum(setdiff(hatOutlierLocS,outlierLocS)~=0)/(n-outlierNumS);
                
                Otmp=O; Otmp(hatOutlierLocS,:)=zeros(qs,p);
                outlierLocO_revised=find(Otmp~=0);
                maskingO(runNum) = 1-sum(intersect(outlierLocO_revised,hatOutlierLocO)~=0)/nnz(outlierLocO_revised);
                swampingO(runNum) = sum(setdiff(hatOutlierLocO,outlierLocO_revised)~=0)/(n*p-nnz(outlierLocO_revised));
                
                if maskingO(runNum)==0; maskNumO = maskNumO+1; end
                if maskingS(runNum)==0; maskNumS = maskNumS+1; end
                
                %% compare with standard RRPCA
                tic
                [hatVperp0,hatMu0,hatS0,hatOu0,outinfo] =RRPCA(Xe,r,d,outlierType,qo,qs,optsRRPCA,optsStiefel);
                hatV0=null(hatVperp0*hatVperp0');
                timeRRPCA(runNum)=toc;
                corrRRPCA(runNum)=cos(subspace(hatV0,V));
                disp([num2str(runNum),': RRPCA:Final correlation:',num2str(100*corrRRPCA(runNum))]);
                
                fprintf(fid3, '%3d: %3.2f & %3.2f & %8.2f & %8.2f & %1.3f & %1.3f \\\\ \r\n', runNum, 100*corrRRPCAbatchV(runNum),100*corrRRPCA(runNum),timeRRPCA_batchV(runNum),timeRRPCA(runNum),maskingO(runNum),maskingS(runNum));
                fprintf( '%3d: %3.2f & %3.2f & %8.2f & %8.2f & %1.3f & %1.3f \\\\ \r\n', runNum, 100*corrRRPCAbatchV(runNum),100*corrRRPCA(runNum),timeRRPCA_batchV(runNum),timeRRPCA(runNum),maskingO(runNum),maskingS(runNum));
                          
            end
            JDS=maskNumS/runNum; JDO=maskNumO/runNum;
            fprintf('%-6s %s %1.6f\r\n',  'RRPCA_batchV',   ':',  100*mean(corrRRPCAbatchV));
            fprintf('%-6s %s %1.6f\r\n',  'RRPCA  ',       ':',  100*mean(corrRRPCA));
            fprintf(fid1, '& %3.2f & %3.2f & %8.2f & %8.2f \\\\ \r\n', 100*mean(corrRRPCAbatchV),100*mean(corrRRPCA),mean(timeRRPCA_batchV),mean(timeRRPCA));
            fprintf(fid2, '& %1.3f & %1.3f & %1.3f & %1.3f & %1.3f & %1.3f \\\\ \r\n', mean(maskingO),mean(swampingO),JDO,mean(maskingS),mean(swampingS),JDS);
        end
    end
end
fclose(fid1); fclose(fid2); fclose(fid3);



