function [hatVperp,hatV,hatS]= batchVS(X,batchNumSequence,qs,optsVSupdate,optsStiefel)
%FUNCTION: batch ROC-PCA for robust PCA in ultra-high dimensions
%Input:
%       X: given contaminated data matrix
%       batchNumSequence: a sequence of numbers of OC loadings to be estimated
%       q: number of outleirs in the data samples
%       optsVSupdate: options for ROCPCA
%Output:
%       hatV: PC loadings estimate
%       hatS: n-by-1 vector with the magnitude of each entry indicating the outlying ness of that sample

% optsVSupdate.ftol=optsVSupdate.ftol*1e3; optsVSupdate.PVperptol=optsVSupdate.PVperptol*1e3;
optsVSupdate.record=0;
optsVSupdate.ftol=1e-3; optsVSupdate.PVperptol=1e-3;
optsVSupdate.initialNum=2; optsVSupdate.initialOptNum=1;

optsStiefel.record=0;
optsStiefel.gtol=1e-3; optsStiefel.ftol=1e-3; optsStiefel.xtol=1e-3;
optsStiefel.mxitr=50;
% optsStiefel.gtol=optsStiefel.gtol*1e3; optsStiefel.ftol=optsStiefel.ftol*1e3;
% optsStiefel.xtol=optsStiefel.xtol*1e3;

[n,p]=size(X); 
batchNumSequenceSize=size(batchNumSequence,2);
XVar=X; hatV=eye(p); hatS=zeros(n,1);

for batchNumIndex = 1:batchNumSequenceSize
    if (batchNumIndex == batchNumSequenceSize)
        optsVSupdate.ftol=optsVSupdate.ftol*0.5; optsVSupdate.PVperptol=optsVSupdate.PVperptol*1e-2;
        optsVSupdate.initialNum=5; optsVSupdate.initialOptNum=2;
        optsStiefel.ftol=optsStiefel.ftol*1e-2; optsStiefel.xtol=optsStiefel.xtol*1e-2;
        optsStiefel.gtol=optsStiefel.gtol*1e-2; optsStiefel.mxitr=10*optsStiefel.mxitr;
    end
    
    d=batchNumSequence(batchNumIndex);
    
    [hatVperpReduced,hatSReduced] = VSupdate(XVar,d,qs,optsVSupdate,optsStiefel);
    hatS = hatS+sum(hatSReduced.^2,2);   % accumulating the outlyingness magnitude
    
    % SVD reduction step
    tildeV=null(hatVperpReduced*hatVperpReduced'); hatV=hatV*tildeV;%     Vsequence{batchNumIndex} = tildeV;
    XVar = XVar*tildeV;
end
hatVperp=null(hatV*hatV');
return;