function [hatVperp,hatV]= batchV(X,batchNumSequence,optsStiefel)

% change opts for the first few batches except the last batch
% optsROCPCA.ftol=optsROCPCA.ftol*1e3; optsROCPCA.PVperptol=optsROCPCA.PVperptol*1e3;

optsStiefel.gtol=optsStiefel.gtol*1e4;
optsStiefel.ftol=optsStiefel.ftol*1e4;
optsStiefel.xtol=optsStiefel.xtol*1e4;

[n,p]=size(X); batchNumSequenceSize=size(batchNumSequence,2);% Vsequence = cell(1,batchNumSequenceSize);
XVar=X; hatV = eye(p);

for batchNumIndex = 1:batchNumSequenceSize
    if (batchNumIndex == batchNumSequenceSize)
        optsStiefel.gtol = optsStiefel.gtol*1e-4;
        optsStiefel.ftol = optsStiefel.ftol*1e-4;
        optsStiefel.xtol = optsStiefel.xtol*1e-4;
    end
    
    currentP=size(XVar,2); d=batchNumSequence(batchNumIndex);
    Vperp0=orth(randn(currentP,d)); Y=zeros(n,d);
    [VperpReduced] = OptStiefelAFBB(Vperp0, @procrustes, optsStiefel, XVar, Y);
    % SVD reduction step
    PvperpReduced = VperpReduced*VperpReduced';    
    tildeV=null(PvperpReduced); hatV=hatV*tildeV;%     Vsequence{batchNumIndex} = tildeV;
    XVar = XVar*tildeV;
end

% % back transformation of the PC loadings
% hatV = eye(r);
% for ii=size(Vsequence,2):-1:1
%     hatV = Vsequence{ii}*hatV;
% end
hatVperp=null(hatV*hatV');
return;