function [Vperp,S,Mu] = VSupdate(X,d,qs,opts,optsStiefel)
%FUNCTION: VSupdae for RRPCA_batchVS, in fact, just ROC-PCA

% copy parameters // I have deleted the process to decide if these parameters are available
[n,p]=size(X);  maxIter=400; record=opts.record; 
ftol=opts.ftol; PVperptol=opts.PVperptol;
initialNum=opts.initialNum; initialOptNum=opts.initialOptNum;

%% Vperp sampling
VperpOpt=cell(initialOptNum,1); SOpt=cell(initialOptNum,1);
MuOpt=cell(initialOptNum,1); fvalOpt=ones(initialOptNum,1)*Inf;

% initialization of  hatVperp by subsampling
optsStiefel1.record=0; optsStiefel1.gtol=1e-2; optsStiefel1.ftol=1e-2; optsStiefel1.xtol=1e-2;
optsStiefel1.mxitr=15;
for initialIndex = 1:initialNum
    VperpP=orth(randn(p,d)); SP=zeros(n,d);
    for iter = 1:2        
        [S,Mu]=Supdate(X*VperpP,qs,SP);
        [Vperp] = OptStiefelAFBB(VperpP, @procrustes, optsStiefel1, X, (ones(n,1)*Mu'+S));
        VperpP=Vperp; SP=S;
    end
    fval = norm(X*Vperp-S-ones(n,1)*Mu','fro');
    [maxFval,maxIndex] = max(fvalOpt);
    if fval<maxFval
        fvalOpt(maxIndex)=fval;
        VperpOpt{maxIndex}=Vperp; SOpt{maxIndex}=S;
    end
end
clear temp tempu temps tempv;

for iIndex = 1:initialOptNum
    VperpP=VperpOpt{iIndex}; SP=SOpt{iIndex}; fvalP=fvalOpt(iIndex);
    for iter = 1:maxIter
        [S,Mu]=Supdate(X*VperpP,qs,SP);
        [Vperp] = OptStiefelAFBB(VperpP, @procrustes, optsStiefel, X, (ones(n,1)*Mu'+S));
        
        PVperpDiff = max(max(abs(Vperp*Vperp'-VperpP*VperpP')))/p;%,'fro');
        fval = norm(X*Vperp-S-ones(n,1)*Mu','fro');
        fvalDiff = abs(fval-fvalP)/(abs(fvalP)+1);
        
        if (record == 1)
            fprintf('\\#%1d %3d:  %2.4e %2.4e  %3.2e \\\\ \n', iIndex, iter, fval, fvalDiff, PVperpDiff);%, cos(subspace(hatVperp,testVperp)));% ...  %3.2e  %3.2e  %2
        end
        
        if ( PVperpDiff < PVperptol || abs(fvalDiff) < ftol )
            if iter <= 2
                ftol=0.1*ftol;
                PVperptol=0.1*PVperptol;
            else
                if record==1
                    fprintf('converge\n')
                end
                break;
            end
        end
        fvalP=fval; VperpP=Vperp; SP=S;
    end

    VperpOpt{iIndex}=Vperp; MuOpt{iIndex}=Mu;
    SOpt{iIndex}=S; fvalOpt(iIndex)=fval;
end


[minFval,minIndex]=min(fvalOpt); Vperp=VperpOpt{minIndex};
S=SOpt{minIndex}; Mu=MuOpt{minIndex};
end