function [Vperp,V,Mu,S,Ou,outinfo] = RRPCA_batchV(X,d,batchNumSequence,outlierType,qo,qs,opts,optsStiefel)
%FUNCTION: Reinforced Robust Principal Component Analysis (RRPCA) Algorithm
%Input:
%       X: given n-by-p X matrix
%       r: true rank of X
%       d: number of OC loading vectors
%       outlierType: 1-row O ans row S; 2-element O and row S
%       qo: quantile threshold for O
%       qs: quantile threshold for S
%       opts: options for RRPCA function
%       optsStiefel: options for Stiefel manifold optimization function
%Output:
%       [Vperp,Mu,S,O] estimators
%       outinfo: output information
%% parameter
if isfield(opts, 'maxIter')
    if opts.maxIter < 0 || opts.maxIter > 2^20
        opts.maxIter = 400;
    end
else
    opts.maxIter = 1000;
end

if isfield(opts, 'PVperptol')
    if opts.PVperptol < 0 || opts.PVperptol > 1
        opts.PVperptol = 1e-6;
    end
else
    opts.PVperptol = 1e-6;
end

if isfield(opts, 'ftol')
    if opts.ftol < 0 || opts.ftol > 1
        opts.ftol = 1e-5;
    end
else
    opts.ftol = 1e-5;
end


if ~isfield(opts, 'record')
    opts.record = 1;
end

if isfield(opts,'initNum') % number of initials tried
    if opts.initNum < 0 
        opts.initNum = 10;
    end
else
    opts.initNum = 10;
end

if isfield(opts,'initOptNum')% number of optimal initials (min fval) kept after 2 iterations
    if opts.initOptNum < 0 || opts.initOptNum > opts.initNum
        opts.initOptNum = 4;
    end
else
    opts.initOptNum = 4;
end

% copy parameters
PVperptol = opts.PVperptol; ftol = opts.ftol;
record = opts.record; maxIter = opts.maxIter;
initNum = opts.initNum; initOptNum = opts.initOptNum;

[n,p] = size(X); Xctr = X;%-repmat(mean(X),n,1);

%% Vperp sampling
fvalOpt = ones(initOptNum,1)*Inf; VperpOpt = cell(initOptNum,1); VOpt = cell(initOptNum,1);
MuOpt = cell(initOptNum,1); SOpt = cell(initOptNum,1); OuOpt = cell(initOptNum,1);

% initialization of  hatVperp by subsampling
for initialIndex = 1:initNum
    Vperp = orth(randn(p,d)); %randomly generate the initial projection direction
    
    % run the algorithm for two iterations and find the minimal fval
    S=zeros(n,d); Mu=zeros(d,1); Ou=zeros(n,p);
    for iter = 1:2       
        Vperp0=Vperp; initOpt.S0=S; initOpt.mu0=Mu; initOpt.O0=Ou;      
        [Mu,Ou,S] = uOSopt(X,Vperp0,outlierType,qo,qs,initOpt);
        fixedTerm = Xctr-Ou-(ones(n,1)*Mu'+S)*Vperp0';
        [Vperp,V]=batchV(fixedTerm,batchNumSequence,optsStiefel);
%         [Vperp,V] = batchVS(X-Ou,batchNumSequence,qs);
    end
    fval = norm((Xctr-Ou)*Vperp-S-ones(n,1)*Mu','fro');
    if (record==2)
        fprintf('Stiefel Opt iter# %4d\n', outinfoStiefel.itr);
        fprintf('fval %1d: %4.3e\n', initialIndex, fval);
    end
    [maxFval,maxIndex]=max(fvalOpt);
    if fval<maxFval
        fvalOpt(maxIndex)=fval; VperpOpt{maxIndex}=Vperp; VOpt{maxIndex}=V;
        MuOpt{maxIndex}=Mu; SOpt{maxIndex}=S; OuOpt{maxIndex}=Ou;
    end
    fprintf([num2str(initialIndex) ' initials done!\n']);
end
clear temp tempu temps tempv;

if (record==2)
    fprintf('chosen opt fval:\n');
    disp(fvalOpt);
end

%% optimization algorithm
outinfo.iter = 0;
for iIndex = 1:initOptNum
    Vperp0=VperpOpt{iIndex}; fval0=fvalOpt(iIndex);
    initOpt.S0=SOpt{iIndex}; initOpt.mu0=MuOpt{iIndex}; initOpt.O0=OuOpt{iIndex};
    for iter = 1:maxIter
        [Mu,Ou,S]=uOSopt(X,Vperp0,outlierType,qo,qs,initOpt);
        fixedTerm=Xctr-Ou-(ones(n,1)*Mu'+S)*Vperp0';
        [Vperp,V]=batchV(fixedTerm,batchNumSequence,optsStiefel);
%         [Vperp,V] = batchVS(X-Ou,batchNumSequence,qs);        % compute stop criteria
        PVperpDiff=max(max(abs(Vperp*Vperp'-Vperp0*Vperp0')))/p;
        fval=norm((Xctr-Ou)*Vperp-S-ones(n,1)*Mu','fro');
        fvalDiff=abs(fval0-fval)/(abs(fval0)+1);
        % update value
        fval0=fval; Vperp0=Vperp; 
        initOpt.S0=S; initOpt.mu0=Mu; initOpt.O0=Ou;
        
        if (record == 1)
            fprintf('\\#%1d %3d:  %2.4e %2.4e  %3.2e \\\\ \n', iIndex, iter, fval, fvalDiff, PVperpDiff);%, cos(subspace(hatVperp,testVperp)));% ...  %3.2e  %3.2e  %2
        end
        
        if (PVperpDiff<PVperptol || abs(fvalDiff)<ftol)
            if record == 1; fprintf('converge\n'); end
            outinfo.msg='converge'; break;          
        end
    end
    if iter>maxIter; outinfo.msg='exceed maxIter'; end
    
    VperpOpt{iIndex}=Vperp; VOpt{iIndex}=V; fvalOpt(iIndex)=fval;
    MuOpt{iIndex}=Mu; SOpt{iIndex}=S; OuOpt{iIndex}=Ou;
    outinfo.iter = outinfo.iter+iter;
end

[minFval,minIndex] = min(fvalOpt);
Vperp=VperpOpt{minIndex}; V=VOpt{minIndex}; Mu=MuOpt{minIndex}; S=SOpt{minIndex}; Ou=OuOpt{minIndex};
end