function [hatOu] = OuOpt(OuP, A,B, thresholdingWay, lambda, tol, maxIter)
n= size(OuP,1);
if nargin < 4
    thresholdingWay = 'group_quantile_no_ridge';
end
if nargin < 5
    lambda = 0.2*n;  % conservative choice of number of outliers
end
if nargin < 6
    tol = 1e-6;
end
if nargin < 7
    maxIter = 1000;
end

iter = 0;
converged = false;
Lambda = ones(n,1)*lambda; %vector form
Ou = OuP;%zeros(size(OuP));

%% main loop
while ~converged
    iter = iter+1;
    OuP = Ou; %save the last Ou
    Ou_tmp = OuP*A+B;
    % chosing the thresholding way
    switch lower(thresholdingWay)
        case {'soft'}
            Ou(:) = 0;
            Ou(Ou_tmp>Lambda) = Ou_tmp(Ou_tmp>Lambda) - Lambda(Ou_tmp>Lambda);
            Ou(Ou_tmp<-Lambda) = Ou_tmp(Ou_tmp<-Lambda) + Lambda(Ou_tmp<-Lambda);
        case {'hard'}
            Ou(:) = 0;
            Ou(abs(Ou_tmp)>Lambda) = Ou_tmp(abs(Ou_tmp)>Lambda);
        case {'scad'}
            a = 3.7;
            Ou(:) = 0;
            Ou(Ou_tmp>Lambda) =  Ou_tmp(Ou_tmp>Lambda) - Lambda(Ou_tmp>Lambda);
            Ou(Ou_tmp<-Lambda) = Ou_tmp(Ou_tmp<-Lambda) + Lambda(Ou_tmp<-Lambda);
            
            Ou(Ou_tmp>2*Lambda) =  ( (a-1)*Ou_tmp(Ou_tmp>2*Lambda) - a * Lambda(Ou_tmp>2*Lambda) ) / (a-2);
            Ou(Ou_tmp<-2*Lambda) =  ( (a-1)*Ou_tmp(Ou_tmp<-2*Lambda) + a * Lambda(Ou_tmp<-2*Lambda) ) / (a-2);
            Ou(abs(Ou_tmp)>a*Lambda) = Ou_tmp(abs(Ou_tmp)>a*Lambda);
        case {'ridge'}
            Ou =  Ou_tmp ./ (1+Lambda);
        case {'group_quantile'}
            rowSum = sum(Ou_tmp.^2,2);
            [sortedSum,idx] = sort(rowSum);
            temp = zeros(1,size(rowSum,1));
            temp((idx(end-lambda+1:end))) = rowSum(idx(end-lambda+1:end))/(1+0.1);
            Ou = diag(temp)*pinv(diag(temp))*Ou_tmp;
        case {'group_quantile_no_ridge'}
            rowSum = sum(Ou_tmp.^2,2);
            [sortedSum,idx] = sort(rowSum);
            Ou(idx(end-lambda+1:end),:) = Ou_tmp(idx(end-lambda+1:end),:);
        case {'elementwise_quantile'}
            Ou(:)=0;
            [sortedSum,idx] = sort(abs(Ou_tmp(:)));
            Ou(idx(end-lambda+1:end)) = Ou_tmp(idx(end-lambda+1:end))./(1+0.1);
        case {'none'}
            Ou = Ou_tmp; % no thresholding -- usually takes more iterations
        otherwise
            error('not implemented yet')
    end
    % stopping criterion
    stopCriterion = norm(Ou-OuP,'fro');
    if stopCriterion < tol
        converged = true;
    end
    if ~converged && iter>=maxIter
        disp('MuSOpt:Maximum iteration reached');
        converged = true;
    end 
end
hatOu = Ou;
end