clc; clear all;
%% MAC directory style
addpath('../../ROCPCA/Code/FOptM-WotaoYin/'); addpath('../../ROCPCA/Code/LIBRA_31okt11');
addpath('../../ROCPCA/Code/PCP/'); addpath('../../ROCPCA/Code/PCP/PROPACK/');

%% setups 1 for ROCPCA
n = 160;  pGrid = [1600];
r = 3; Sigma = diag([64,36,16]);%diag([100,60,20]);%
sigma2Grid = [0.5]; % noise level: sigma squared
sprGrid = [0.15];
L = 20;   % outlier magnitude
RESULTS={}
totalRunNum=5;

% fid1=fopen(['./sim1/Estimation_eOrS_n',num2str(n),'p', num2str(pGrid(1)),'.txt'],'w');
% fid2=fopen(['./sim1/Identification_eOrS_n',num2str(n),'p',num2str(pGrid(1)),'.txt'],'w');
% fprintf(fid1,  '%s %-9s %-9s %-9s %-9s %-9s\r\n', 'Result format', 'RRPCA', 'CPCA','PCP','RAPCA','ROBPCA');
% fprintf(fid2,  '%s\r\n', 'Result format (O (M S JD)) (S (M S JD))');

%options for RRPCA
optsRRPCA.record=1; optsRRPCA.ftol=1e-6; optsRRPCA.PVperptol=1e-8; optsRRPCA.initNum=1; optsRRPCA.maxIter=100;
optsRRPCA.initOptNum=1;
optsRRPCA.numbatches=5;
% pars for stiefel manifold optimization
optsStiefel.record=0; optsStiefel.gtol=1e-6;
optsStiefel.ftol=1e-5; optsStiefel.xtol=1e-6;
optsStiefel.maxiter=30; optsStiefel.orth=0;

for pIndex = 1:size(pGrid,2)
    p = pGrid(pIndex); d=p-r;
    for sigma2Index = 1:size(sigma2Grid,2)
        sigma2 = sigma2Grid(sigma2Index);
%         fprintf(fid1,'%s %3.0f %s %2.0f %s %2.2f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);
%         fprintf(fid2,'%s %3.0f %s %2.0f %s %2.2f \r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2);
        
        for sprIndex = 1:size(sprGrid,2)    % choices of sparsity ratio
            spr = sprGrid(sprIndex);
            
            randn('state', 0); rand('state', 0);
            % generate the data matrix according to X=CV^T+O+ (1*mu^T + S)*V_perp^T+E
            C=mvnrnd(zeros(r,1),Sigma,n);
            V=orth(randn(p)); Vperp=V(:,r+1:end); V(:,r+1:end)=[];
            S=zeros(n,p-r); O=zeros(n,p);
            
            %% 2. element-O + row-S
            outlierType=21;
            
            outlierNumS=n*spr/2; qs=ceil(1*n*spr);
            outlierLocS=1:outlierNumS;
            S(outlierLocS,:)=repmat(L*ones(1,p-r),outlierNumS,1);
            
            outlierNumO=n*p*spr/2; qo=ceil(1*outlierNumO);
            perm=randperm(n*p); outlierLocO=perm(1:outlierNumO);
            O(outlierLocO)=L;
            
            
            
            corrRRPCA = zeros(1,totalRunNum); corrSPCA = zeros(1,totalRunNum);
            corrPCP = zeros(1,totalRunNum); corrROBPCA = zeros(1,totalRunNum);
            corrRAPCA = zeros(1,totalRunNum); corrCPCA = zeros(1,totalRunNum);
            corrGoDec = zeros(1,totalRunNum); corrROSL = zeros(1,totalRunNum);
            maskingO = zeros(1,totalRunNum); maskingS = zeros(1,totalRunNum);
            swampingO = zeros(1,totalRunNum); swampingS = zeros(1,totalRunNum);
            maskNumO=0; maskNumS=0;
            for runNum = 1:totalRunNum
                E=mvnrnd(zeros(p,1),sigma2*eye(p),n);
                X=C*V'+E; Xe=X+O+S*Vperp';
                
                %% RRPCA computation
                % - estimation
                tic;  
                [hatVperp,hatMu,hatS,hatOu,outinfo] =RRPCA_linear(Xe,r,d,outlierType,qo,qs,optsRRPCA,optsStiefel);
                toc
                hatPv = eye(p)-hatVperp*hatVperp';   %signal subspace
                [hatV,eigValhat,temp]=svds(hatPv,r);
                corrRRPCA(runNum) = cos(subspace(hatV,V));
                %disp([num2str(runNum),': RRPCA:Final correlation:',num2str(100*corrRRPCA(runNum))]);
%                 
                % - outlier detection
                hatOutlierLocS=find(sum(hatS.^2,2)~=0); hatOutlierLocO=find(hatOu~=0);
                maskingS(runNum) = 1-sum(intersect(outlierLocS,hatOutlierLocS)~=0)/outlierNumS;
                swampingS(runNum) = sum(setdiff(hatOutlierLocS,outlierLocS)~=0)/(n-outlierNumS);
                
                Otmp=O; Otmp(hatOutlierLocS,:)=zeros(qs,p);
                outlierLocO_revised=find(Otmp~=0);
                maskingO(runNum) = 1-sum(intersect(outlierLocO_revised,hatOutlierLocO)~=0)/nnz(outlierLocO_revised);
                swampingO(runNum) = sum(setdiff(hatOutlierLocO,outlierLocO_revised)~=0)/(n*p-nnz(outlierLocO_revised));
                
                if maskingO(runNum)==0; maskNumO = maskNumO+1; end
                if maskingS(runNum)==0; maskNumS = maskNumS+1; end
                
%                 %% compare with other algorithms
                % - PCP
                lambda=1/sqrt((size(Xe,2)));
                %condn=size(Xe,1)>=size(Xe,2);
                
                    [A_hat E_hat iter] = inexact_alm_rpca(Xe',lambda);
                    [UY,SY,VY]=svds(A_hat',r);   %Y stands for Yi Ma's work
                
                %cos(subspace(VY,V))
                corrPCP(runNum) = cos(subspace(VY,V));
               %disp([num2str(runNum),': PCP:Final correlation:',num2str(100*corrPCP(runNum))]);
%                 
                % - test RAPCA algorithm
                result=rapca(Xe,'k',r,'plots',0);
                corrRAPCA(runNum) = cos(subspace(result.P,V));
                %disp([num2str(runNum),': RAPCA:Final correlation:',num2str(100*corrRAPCA(runNum))]);
%               
                % - test ROSL Xianbao Shu
                Ko = p;      %   The initialiation of the subspace dimension
                Lo = 10;     %   The size of submatrix
                tolo = 1e-6;
                maxItero =100;
                lambdao =lambda; %
                 [Dict, alpha, E_hat, A_hat] = inexact_alm_rosl(Xe', Ko, lambdao, tolo, maxItero);
                [UY,SY,VY]=svds(A_hat',r);
                 corrROSL(runNum) =cos(subspace(VY,V));
                 %disp([num2str(runNum),': ROSL:Final correlation:',num2str(100*corrROSL(runNum))]);

%                 
                % - test ROBPCA algorithm
                result=robpca(Xe,'k',r,'plots',0);
                corrROBPCA(runNum) = cos(subspace(result.P,V));
                %disp([num2str(runNum),': ROBPCA:Final correlation:',num2str(100*corrROBPCA(runNum))]);
            
                % test spherical PCA algorithm
                VS=sphericalPCA(Xe,r);
                corrSPCA(runNum) = cos(subspace(VS,V));
                %disp([num2str(runNum),': SPCA:Final correlation:',num2str(100*corrSPCA(runNum))]);
                % Go-Dec
                [Lhat,Sp,RMSE,error]=GoDec(X',r,1,0);
                [UY,SY,VY]=svds(Lhat',r);
                corrGoDec(runNum)=cos(subspace(VY,V));
                %disp([num2str(runNum),': GoDec:Final correlation:',num2str(100*corrGoDec(runNum))]); 
%                 
                % - test CPCA algorithm
                [UC,SC,VC]=svds(Xe-repmat(mean(Xe),size(Xe,1),1),r);
                corrCPCA(runNum) = cos(subspace(VC,V));
                %disp([num2str(runNum),': PCA:Final correlation:',num2str(100*corrCPCA(runNum))]);
                runNum
            end
%             JDS=maskNumS/runNum; JDO=maskNumO/runNum;
fprintf('%s %3.0f %s %2.0f %s %2.2f %s %2.2f  %s %3.0f\r\n' ,'n = ', n,'p = ', p, 'sigma2 = ', sigma2, 'spr = ',spr,'qo = ',qo);
            fprintf('%-6s %s %1.6f\r\n',  'RRPCA',   ':',  100*mean(corrRRPCA));
            fprintf('%-6s %s %1.6f\r\n',  'CPCA  ',       ':',  100*mean(corrCPCA));
            fprintf('%-6s %s %1.6f\r\n',  'PCP   ',         ':',  100*mean(corrPCP));
            fprintf('%-6s %s %1.6f\r\n',  'RAPCA ',     ':',  100*mean(corrRAPCA));
            fprintf('%-6s %s %1.6f\r\n',  'ROBPCA',   ':',  100*mean(corrROBPCA));
            fprintf('%-6s %s %1.6f\r\n',  'GoDec',   ':',  100*mean(corrGoDec));
                        fprintf('%-6s %s %1.6f\r\n',  'ROSL',   ':',  100*mean(corrROSL));
                        
                        RESULTS{pIndex,sprIndex,sigma2Index}=[100*mean(corrRRPCA) 100*mean(corrCPCA) 100*mean(corrPCP) 100*mean(corrRAPCA) 100*mean(corrROBPCA) 100*mean(corrGoDec) 100*mean(corrROSL)];

%             fprintf(fid1, '& %3.2f & %3.2f & %3.2f & %3.2f & %3.2f \\\\ \n', 100*mean(corrRRPCA),100*mean(corrCPCA),100*mean(corrPCP),100*mean(corrRAPCA),100*mean(corrROBPCA));
%             fprintf(fid2, '& %1.3f & %1.3f & %1.3f & %1.3f & %1.3f & %1.3f \\\\ \n', mean(maskingO),mean(swampingO),JDO,mean(maskingS),mean(swampingS),JDS);
% disp('for RRPCA ') 
% fprintf('%3.2f\n',100*mean(corrRRPCA));
% disp('for PCP ') 
%   fprintf('%3.2f\n',100*mean(corrPCP));

        end
    end
end
% fclose(fid1); fclose(fid2);



