% This Matlab program fits the hard-ridge penalized model. (Y. She)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Get and set data
dataX = X; dataY = y;
    if exist('tstX', 'var')
        tstDataAvail = true; 
    else
        tstDataAvail = false; 
    end
    if exist('valX', 'var')
        valDataAvail = true; 
    else
        valDataAvail = false; 
    end
    
    if tstDataAvail
        predDataX = tstX; predDataY = tstY;
        if size(dataX, 2) == size(predDataX, 2)
            standData = 1;
        end        
    end
    if valDataAvail
        valiDataX = tstX; valiDataY = tstY;
        if size(dataX, 2) == size(valiDataX, 2)
            standData = 1;
        end        
    end
    
    if exist('idenAug', 'var') && idenAug
        standData = 2;
        if ~exist('origP', 'var')
            error('No original P (# of preds) found')
        end
    end     
    % Standardize data. (No operations for Y, because this may not be gaussian)
    if standData == 1 % size(dataX, 2) == size(predDataX, 2)
        % Center dataX
        centers = mean(dataX);
        dataX = dataX - repmat(centers, size(dataX, 1), 1);
        % Col-normalize dataX
        scales = sqrt(sum(dataX.^2)/(size(dataX, 1)-0));
        dataX = dataX ./ repmat(scales, size(dataX, 1), 1); % or dataX * diag(1./(scales)); 
        % The scaling may change betaTrue
        if exist('betaTrue', 'var')
            betaTrue = betaTrue .* scales'; 
            trnScales = trnScales .* scales;
        end
        
        if tstDataAvail
        % Center & Scale predDataX, using the centers and scales of the training data        
            predDataX = predDataX - repmat(centers, size(predDataX, 1), 1);
            predDataX = predDataX ./ repmat(scales, size(predDataX, 1), 1); % or predDataX * diag(1./(scales));
        end
        if valDataAvail
        % Center & Scale predDataX, using the centers and scales of the training data        
            valiDataX = valiDataX - repmat(centers, size(valiDataX, 1), 1);
            valiDataX = valiDataX ./ repmat(scales, size(valiDataX, 1), 1); % or predDataX * diag(1./(scales));
        end
        alphaCenterAdj = [];
    elseif standData == 2 % % dataX may be augmented, but the prediction data are not
        if valDataAvail 
            numStandPreds = size(valiDataX,2);
        elseif tstDataAvail 
            numStandPreds = size(predDataX,2);
        else
            numStandPreds = origP;
        end        
        % Center dataX
        centers = mean(dataX);
%         centers((numStandPreds+1):end) = 0; 
        dataX(:, 1:numStandPreds) = dataX(:, 1:numStandPreds) - repmat(centers(1:numStandPreds), size(dataX, 1), 1);
        % Col-normalize dataX
        scales = sqrt(sum(dataX.^2)/(size(dataX, 1)-0));
        dataX = dataX ./ repmat(scales, size(dataX, 1), 1); % or dataX * diag(1./(scales)); 
        if exist('betaTrue', 'var')
            betaTrue = betaTrue .* scales'; 
            trnScales = trnScales .* scales;
        end
        
        if tstDataAvail
        % Center & Scale predDataX, using the centers and scales of the training data        
            predDataX = predDataX - repmat(centers(1:numStandPreds), size(predDataX, 1), 1);
            predDataX = predDataX ./ repmat(scales(1:numStandPreds), size(predDataX, 1), 1); % or predDataX * diag(1./(scales(1:numStandPreds)));                 
        end
        if valDataAvail
        % Center & Scale predDataX, using the centers and scales of the training data        
            valiDataX = valiDataX - repmat(centers(1:numStandPreds), size(valiDataX, 1), 1);
            valiDataX = valiDataX ./ repmat(scales(1:numStandPreds), size(valiDataX, 1), 1); % or predDataX * diag(1./(scales));
        end
        alphaCenterAdj = -centers(:) ./ scales(:);
    end
    X = dataX; y = dataY; 
    if tstDataAvail
        tstX = predDataX; tstY = predDataY;
    end
    if valDataAvail
        valX = valiDataX; valY = valiDataY;
    end
    [n ,d] = size(X);
    
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % Specify the parameters
%     thresholdingWay = 'hybrid' %'scad' %'soft' %'hard' %    'none' %
% %     tuningMethod = 'selCV' %'BICm' %'validation' %'BIC' %  
%     unpenCorr = false; % true %   
%     output = false; %true; %  
% 
%     nCV = 5; %10 %20 % round( size(X, 1)/1 )%5; % LOOCV
%     minTh0 = 0;
%     [nCV, dataIndsCV, dataIndsCVStarts, dataIndsCVEnds] = CVSplit(size(X, 1), nCV); % make sure it runs only ONCE when fitting the path using both more than 1 paths.
%     disp(nCV)
% 
%     intercptchoice = 'simuopt2'; %'none' %'simuopt' %   'fixedopt' %  
%         % simuopt2: faster than 'simuopt'
%     nPoints = 100; %50; %100; %   
%     maxIT = 1e+2 % 1e+6 %1e+5 %1e+4 %  5e+3 %   
%     errBnd = 1e-5; %1e-7% 
%     nzUBnd = n/2; %n; %200; %inf; % 
%     updating = 'synchronous'; %'coordes' % 'asynchronous' %  
%             % 'synchronous' faster than 'coordes' faster than 'asynchronous' 
%     relaxWay = 1; %0 %          
%             % 1 is faster than 0, but the two estimates can be different??
% 
% %     scvbiascorrt0 = scvbiascorrtRef; % the scv bias correction for the ridge path
% %     scvbiascorrt1 = scvbiascorrtRef; % the scv bias correction for the tuning paths
% %     matchLocEst0 = matchLocEstRef;   % how to find the appropriate eta's in cv, for the ridge path
% %     matchLocEst1 = matchLocEstRef;   % how to find the appropriate eta's in cv, for the tuning paths     
%
%     nzExpected = 0.8*n %0.75*n %0.7*n %   0.5*n % 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    

        if exist('betaTrue', 'var')
            oriBetaTrue = betaTrue; 
            clear betaTrue;
        end
    
    if ~strcmp(screening, 'none') 
        if output>0, disp('==================== Screening stage starts ============================'), end


        if strcmp(screening, 'tisp')
%         % %%%%%%%%%%%%%
%             run TISPScreening_PHTISP;
%         % %%%%%%%%%%%%%
        % %%%%%%%%%%%%%
            coolingmanner = 'sigmoid';
            stayTime = 1; % run only 1 iteration step in cooling
            squeezing = 1; % screeze the design
            keptTime = 0;
%             [predScreened, alphaOpt, betaOpt, dimCooling, Nu, tmpRes] = ...
%                     Func_ScrnCooling(X, y, family, coolingmanner, [], [], keptTime, nzExpected, stayTime, errBnd, squeezing, ...
%                     tuningMethod, nCV, dataIndsCV, dataIndsCVStarts, dataIndsCVEnds, valX, valY, tstX, tstY, intercptchoice, grps);
            
            [predScreened, alphaOpt, betaOpt, dimCooling, Nu] = ...
                Func_QTISPCooling(X, y, family, coolingmanner, [], keptTime, nzExpected, stayTime, squeezing, 1e-2, ...
                                  intercptchoice, grps, ones(size(X,2),1));      
            predScreened = [predScreened{1}];
        % %%%%%%%%%%%%%
        elseif strcmp(screening, 't-test')
            [h,p,ci,stats] = ttest2(X(y==0, :),X(y==1, :));
            quan = 1 - nzExpected / d;
            quan(quan < 0) =0; 
            thval = quantile(abs(stats.tstat), quan); % Lambda of the components of beta are nonzeros                    
            thval(quan==0) = 0;
            predScreened = find(abs(stats.tstat)>thval)';

        elseif strcmp(screening, 'read')
            pvalsTrnFromR = dlmread([pathinit, 'pvalsTrnFromR_', num2str(dataInd), '.txt'], ' '); 
            quan = 1 - nzExpected / d;
            quan(quan < 0) =0; 
            thval = quantile(1 - pvalsTrnFromR, quan); % Lambda of the components of beta are nonzeros                    
            thval(quan==0) = 0;
            predScreened = find((1 - pvalsTrnFromR)>thval);

        end
        oriX = X; 
        X = X(:,predScreened);
        if exist('grps', 'var') && ~isempty(grps) % We need to re-index the grp numbers
            oriGrps = grps;
            grps = grps(predScreened);
            screened_uniq_grps = unique(grps);
            tgrps = zeros(size(grps));
            for tgrpind = 1:numel(screened_uniq_grps)
                tgrps(grps ==  screened_uniq_grps(tgrpind)) = tgrpind;
            end
            grps = tgrps;
        end        
        if tstDataAvail
            oriTstX = tstX; 
            tstX = tstX(:,predScreened(predScreened<=size(tstX,2))); 
        end
        if valDataAvail
            oriValX = valX; 
            valX = valX(:,predScreened(predScreened<=size(valX,2))); 
        end
        if exist('betaTrue', 'var')
            oriBetaTrue = betaTrue; 
            betaTrue = betaTrue(predScreened(predScreened<=numel(betaTrue))); 
        end
        d = size(X, 2);
        if ~isempty(alphaCenterAdj)
            alphaCenterAdj = alphaCenterAdj(predScreened);
        end
    end
    if output>0, disp('==================== Fitting stage starts =============================='), end
          
    % %%%%%%%%%%%%%
    % tuningMethod = 'validation' %'BICm' %  'BIC' %
    run hybridTISP_Tuned;
    % %%%%%%%%%%%%%

    if ~strcmp(screening, 'none') 
        X = oriX; 
        if tstDataAvail
            tstX = oriTstX; 
        end
        if valDataAvail
            valX = oriValX; 
        end
        if exist('oriBetaTrue', 'var')
            betaTrue = oriBetaTrue; 
        end
        if exist('grps', 'var') && ~isempty(grps), grps = oriGrps; end
        d = size(X, 2);
        betaOpt0 = betaOpt; 
        betaOpt = zeros(d, 1); betaOpt(predScreened) = betaOpt0;
    end
