function [val] = GLM_negLogLik(X, y, betas, family, alphas)
% Compute the negative log-likelihood for the given estimates
if nargin == 4 | ~exist('alphas', 'var') | isempty(alphas)
    alphas = zeros(size(X, 1), size(betas, 2));
end
if size(y, 2) == 1
    switch lower(family)
       case {'binomial'}
    %       val = -y'*(X*betas+alphas) + sum(log(1+exp(X*betas+alphas))); %get Inf if X*betas+alphas>800
          eta = X * betas+alphas; % val = -y'*(eta) + sum(eta(eta>500)) + sum(log(1+exp(eta(eta<=500))));
          val = -y'*eta;
          for i = 1:size(betas,2)
              val(i) = val(i) + sum((eta(:,i)>500) .* eta(:,i)) + sum(log(1+exp(eta(eta(:,i)<=500, i))));
          end

       case 'poisson'
          val = -y'*(X*betas+alphas) + sum(exp(X*betas+alphas));
       case 'gaussian'
           %scaled -- assume sigma=1
          val = sum((y * ones(1, size(betas,2)) - X * betas-alphas).^2)/2;  
       otherwise
          error('not implemented yet')
    end
else
    oriBetas = betas;
    oriAlphas = alphas;
    oriYs = y;
    val = 0;
    switch lower(family)
        case {'binomial'}
            for iResp = 1:size(oriBetas,2)
                betas = squeeze(oriBetas(:, iResp, :));
                alphas = squeeze(oriAlphas(:, iResp, :));
                y = oriYs(:, iResp);
                %val = -y'*(X*betas+alphas) + sum(log(1+exp(X*betas+alphas))); %get Inf if X*betas+alphas>800
                eta = X * betas+alphas; % val = -y'*(eta) + sum(eta(eta>500)) + sum(log(1+exp(eta(eta<=500))));
                tval = -y'*eta;
                for i = 1:size(betas,2)
                  tval(i) = tval(i) + sum((eta(:,i)>500) .* eta(:,i)) + sum(log(1+exp(eta(eta(:,i)<=500, i))));
                end
                val = val + tval;
            end
        case 'poisson'
            for iResp = 1:size(oriBetas,2)
                betas = squeeze(oriBetas(:, iResp, :));
                alphas = squeeze(oriAlphas(:, iResp, :));
                y = oriYs(:, iResp);           
                tval = -y'*(X*betas+alphas) + sum(exp(X*betas+alphas));
                val = val + tval;
            end
        case 'gaussian'
            for iResp = 1:size(oriBetas,2)
                betas = squeeze(oriBetas(:, iResp, :));
                alphas = squeeze(oriAlphas(:, iResp, :));
                y = oriYs(:, iResp);
                %scaled -- assume sigma=1
                tval = sum((y * ones(1, size(betas,2)) - X * betas-alphas).^2)/2; 
                val = val + tval;
            end
        otherwise
          error('not implemented yet')
    end;
    
end