function [predScreened, alphaOpt, betaOpt, dimCooling, Nu, tmpRes] = ...
    Func_ScrnCooling(X, y, family, coolingmanner, polyIndex, coolingTime, keptTime, coolingLbnd, grpSelMaxIT, errBnd, squeezing, ...
                            tuningMethod, nCV, dataIndsCV, dataIndsCVStarts, dataIndsCVEnds, valX, valY, tstX, tstY, ...
                            intercptchoice, grps)
% squeezing: 0: no squeezing; 1: for RRR problems; 2: for PCA problems
% grpSelMaxIT: how many steps to run at each given cardinality level (before possible screezing)

[n, d] = size(X); 
nzExpected = coolingLbnd;
thresholdingWay = 'hybrid-prop';
coolingUbnd = d;
if strcmp(coolingmanner, 'fixed') %L
    dimCooling = coolingLbnd * ones(1, coolingTime);
elseif strcmp(coolingmanner, 'halving') %U/(2^t)
    dimCooling = round( coolingUbnd * 2.^[0:-1:(log2(coolingLbnd/coolingUbnd)-1)] );
    dimCooling(dimCooling < coolingLbnd) = coolingLbnd;
elseif strcmp(coolingmanner, 'inverse') %U/t
    dimCooling = round(coolingUbnd./[1:(coolingUbnd/coolingLbnd+1)]);
    dimCooling(dimCooling < coolingLbnd) = coolingLbnd;
elseif strcmp(coolingmanner, 'poly-0.5') %U/(t^0.5)
    alpha = 0.5;
    dimCooling = round(coolingUbnd./([1:((coolingUbnd/coolingLbnd+1)^(1/alpha))].^alpha));
    dimCooling(dimCooling < coolingLbnd) = coolingLbnd;
elseif strcmp(coolingmanner, 'dec1') %U-t
    dimCooling = [coolingUbnd:-1:coolingLbnd];
elseif strcmp(coolingmanner, 'poly-GivenCoolingTime') % inverse decay with fixed cooling time (given in coolingTime)
    alpha = polyIndex;
    dimCooling = round( 1./(1/coolingUbnd + (1/coolingLbnd - 1/coolingUbnd)*([1:coolingTime]/coolingTime).^alpha) );
        % This cooling schedule has a function: 1/[1/U + (1/L - 1/U) * (t/M)^alpha]. 
        % So when t=0, we get U, and when t=M, we get L. 
elseif strcmp(coolingmanner, 'sigmoid') % U*2/(1+exp(alpha*t))
    alpha = 0.1; %0.4; %
    dimCooling = round(coolingUbnd * 2 ./(1+exp(alpha* [0:log(2 * coolingUbnd/ coolingLbnd - 1)/alpha+1])));
    dimCooling(dimCooling < coolingLbnd) = coolingLbnd;     
end
if keptTime > 0
    dimCooling = [dimCooling, ones(1, keptTime) * coolingLbnd]; % We let the algorithm run for a few more iterations with tempreture fixed at the target
end
% dimCooling
oriX = X;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    ridgeEta = 1; % reference value, which may change in applications
    etaRatios =  1e-2; %10.^[-3:-1]; %10.^[-5:0]; %10.^[-6:0]; %  
    tmpRes = []; tmpBetas = []; tmpAlphas = [];
    for scrPathInd = 1:size(etaRatios,2)
%         disp(['++++++++++++++++++++ lambda-path-', num2str(scrPathInd), ',eta=', num2str(etaRatios(scrPathInd)), ' ++++++++++++++++++++++++++'])    

            finalRemainingDims = [1:d];
            curGrps = grps;
            X = oriX;
            for dimInd = 1:numel(dimCooling)
                Lambda = dimCooling(dimInd);
%                 fprintf(['lambda=', num2str(Lambda), '\n'])
                
                [alphaOpt, betaOpt, X_scl, Nu, k0, intercept] = HybridTISP_SingleRun(X, y, family, Lambda, ridgeEta * etaRatios(scrPathInd), 'hybrid-prop', errBnd, grpSelMaxIT, ...
                    intercptchoice, 'synchronous', 1, curGrps);
                
                remainingDims = find(betaOpt~=0);
                
                if strcmp(intercptchoice, 'simuopt2') % the 1st column of X is unpenalized.
                                                    % In all cases, beta corresponds to X
                    remainingDims = unique([1; remainingDims]);
                end
           
                if isempty(remainingDims)
                    break;
                end
                % Squeeze the design (and maybe the response) for the purpose of screening/computational efficiency
                if squeezing == 1
                    finalRemainingDims = finalRemainingDims(remainingDims);
                    betaOpt = betaOpt(remainingDims); 
                    X = X(:,remainingDims);
                    if exist('grps', 'var') && ~isempty(grps) % We need to re-index the grp numbers
                        curGrps = curGrps(remainingDims);
                        screened_uniq_grps = unique(curGrps);
                        tgrps = zeros(size(curGrps));
                        for tgrpind = 1:numel(screened_uniq_grps)
                            tgrps(curGrps ==  screened_uniq_grps(tgrpind)) = tgrpind;
                        end
                        curGrps = tgrps;
                    end
                 
                elseif squeezing == 2
                    error('This was designed for a matrix Y, but not needed so far.')
%                     finalRemainingDims = finalRemainingDims(remainingDims);
%                     betaOpt = betaOpt(remainingDims); 
%                     X = X(:,remainingDims);
%                     Y = Y(:,remainingDims);
                end    
        

            end

            if squeezing == 0
                finalRemainingDims = finalRemainingDims(remainingDims);
            end
            if squeezing == 1
                tmpBeta = zeros(size(oriX, 2), 1);
                tmpBeta(finalRemainingDims) = betaOpt;
                betaOpt = tmpBeta;
            end
            X = oriX;

        matBetaEsts = betaOpt;
        alphaEsts = alphaOpt;
        
%         tuningMethod =  'selCV'; % 'validation' % 
        minTh0 = 0;
        output = false;
        
        unpenCorr = false; %true % 
        scvbiascorrt = 'bic';%'aic'; %[]; %  
        matchLocEst = 'naive'; % 'df';
        
        run TISPTuning_GLM; % lambdas not defined
        tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; nzExpected; Nu; sum(betaOpt~=0); sum(log(find(betaOpt~=0)))]];
        tmpBetas = [tmpBetas, betaOpt];
        tmpAlphas = [tmpAlphas, alphaOpt];
        disp(['# of nonzeros: ', num2str(sum(betaOpt~=0))])
        if scrPathInd>= 3 && (tmpRes(1,end) > 1.2 * tmpRes(1,end-1) && tmpRes(1,end-1) > 1.2* tmpRes(1, end-2))
            break;
        end
    end
    
    optInd = 0 + find(tmpRes(1, 1:end) == min(tmpRes(1, 1:end)), 1, 'first'); %find(tmpRes(1,:) == min(tmpRes(1,:)), 1, 'first');
    betaOpt = tmpBetas(:, optInd); alphaOpt = tmpAlphas(optInd);

%     disp(num2str(tmpRes))
    disp(['optInd: ', num2str(optInd), '; # of nonzeros: ', num2str(sum(betaOpt~=0))])

    predScreened = finalRemainingDims; %find(betaOpt~=0);