function [dims, alphas, betas, dimCooling, Nus] = ...
    Func_QTISPCooling(X, y, family, coolingmanner, coolingTime, keptTime, coolingLbnd, stayTime, squeezing, Nus, ...
                      intercptchoice, grps, wts) 
% Main quantile TISP screening function (by Y. She)
% squeezing: 0: no squeezing; 1: squeeze X (e.g., for RRR problems); 2: squeeze both X and Y (e.g., for PCA problems)
% stayTime: how many steps needed to run at each given cardinality level (before screezing)
% Nus: the ridge parameter value grid (a vector)
% wts: dimension weights. 
%       In QIPOD, wts(1:n) = 0 and wts(n+1:n+p) = 1, which means only the last p coefficients are desired to be sparse.
%       (Maybe nonidentical weights can be useful later.)

% Do not forget for 'simuopt2', X has the first column not penalized (form an intercept column outside the function)

% Generate coolling schedule
[n, d] = size(X); 
nzExpected = coolingLbnd;
coolingUbnd = sum(wts~=0); % d;
if strcmp(coolingmanner, 'fixed') %L
    dimCooling = coolingLbnd * ones(1, coolingTime);
elseif strcmp(coolingmanner, 'halving') %U/(2^t)
    dimCooling = round( coolingUbnd * 2.^[0:-1:(log2(coolingLbnd/coolingUbnd)-1)] );
    dimCooling(dimCooling < coolingLbnd) = coolingLbnd;
elseif strcmp(coolingmanner, 'inverse') %U/t
    dimCooling = round(coolingUbnd./[1:(coolingUbnd/coolingLbnd+1)]);
    dimCooling(dimCooling < coolingLbnd) = coolingLbnd;
elseif strcmp(coolingmanner, 'poly-0.5') %U/(t^0.5)
    alpha = 0.5;
    dimCooling = round(coolingUbnd./([1:((coolingUbnd/coolingLbnd+1)^(1/alpha))].^alpha));
    dimCooling(dimCooling < coolingLbnd) = coolingLbnd;
elseif strcmp(coolingmanner, 'dec1') %U-t
    dimCooling = [coolingUbnd:-1:coolingLbnd];
elseif strcmp(coolingmanner, 'poly-GivenCoolingTime') % inverse decay with fixed cooling time (given in coolingTime)
    alpha = 0.5; %polyIndex;
    dimCooling = round( 1./(1/coolingUbnd + (1/coolingLbnd - 1/coolingUbnd)*([1:coolingTime]/coolingTime).^alpha) );
        % This cooling schedule has a function: 1/[1/U + (1/L - 1/U) * (t/M)^alpha]. 
        % So when t=0, we get U, and when t=M, we get L. 
elseif strcmp(coolingmanner, 'sigmoid') % U*2/(1+exp(alpha*t))
    alpha = 0.01; %0.4; %
    dimCooling = round(coolingUbnd * 2 ./(1+exp(alpha* [0:log(2 * coolingUbnd/ coolingLbnd - 1)/alpha+1])));
    dimCooling(dimCooling < coolingLbnd) = coolingLbnd;     
end
if keptTime > 0
    dimCooling = [dimCooling, ones(1, keptTime) * coolingLbnd]; % We let the algorithm run for a few more iterations with tempreture fixed at the target
end
% dimCooling
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Compute k0
switch lower(family)
   case {'binomial'}
        k0 = .5*norm(X, 2);
   case 'poisson'
        %sprintf('no universal bound!')
        warning('off')
        k0 = max(exp(X* glmfit(X, y, 'poisson', 'constant', 'off')/2)) * norm(X, 2);  
        warning('on')
   case 'gaussian'
        k0 = norm(X, 2);  
   otherwise
      error('not implemented yet')
end  
X_scl = X ./ k0;
%%%%%%%%%%%%%%%
X_ref = X_scl;
wts_ref = wts;
grps_ref = grps;
thresholdingWay = 'hybrid-prop';
updating = 'synchronous'; % Use the synchronous form
relaxWay = 0; % 1; %
% errBnd = inf; % 1e-4; % Do NOT perform final fit correction in the cooling!
% maxIT = 1e+2; %1e2; % # of iterations

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
betas = zeros(d, numel(Nus)); 
alphas = zeros(numel(Nus));
dims = cell(numel(Nus), 1);
for scrPathInd = 1:size(Nus,2)
% 	disp(['++++++++++++++++++++ ', num2str(scrPathInd), ',eta=', num2str(Nus(scrPathInd)), ' ++++++++++++++++++++++++++'])    
    Nu = Nus(scrPathInd) * wts_ref;

    finalRemainingDims = [1:d];
    grps = grps_ref;    
    curGrps = grps;
    X = X_ref;
    wts = wts_ref;

    for dimInd = 1:numel(dimCooling)
        Lambda = dimCooling(dimInd) * wts;
        Lambda(wts==0) = inf;
%                 fprintf(['lambda=', num2str(Lambda), '\n'])

        % Perform Q-TISP for stayTime many steps
        if dimInd > 1
            betaInit = betaOpt;
        else
            betaInit = zeros(size(X, 2), 1);
        end
        [betaOpt, alphaOpt, totNum] = TISP_GLM(X, y, Lambda, family, thresholdingWay, inf, stayTime, betaInit, Nu, ...
            intercptchoice, [], updating, relaxWay, curGrps);   
        
        remainingDims = find(betaOpt~=0);
        if strcmp(intercptchoice, 'simuopt2') % the 1st column of X is unpenalized. % In all cases, beta corresponds to X
            remainingDims = unique([1; remainingDims]);
        end

        if isempty(remainingDims)
            break;
        end
        % Squeeze the design (and maybe the response) for the purpose of screening/computational efficiency
        if squeezing == 1
            finalRemainingDims = finalRemainingDims(remainingDims);
            betaOpt = betaOpt(remainingDims); 
            X = X(:,remainingDims);
            wts = wts(remainingDims);
            Nu = Nu(remainingDims);
            if exist('grps', 'var') && ~isempty(grps) % We need to re-index the grp numbers
                curGrps = curGrps(remainingDims);
                screened_uniq_grps = unique(curGrps);
                tgrps = zeros(size(curGrps));
                for tgrpind = 1:numel(screened_uniq_grps)
                    tgrps(curGrps ==  screened_uniq_grps(tgrpind)) = tgrpind;
                end
                curGrps = tgrps;
            end
        elseif squeezing == 2
            error('This was designed for a matrix Y, but not needed so far.')
%                     finalRemainingDims = finalRemainingDims(remainingDims);
%                     betaOpt = betaOpt(remainingDims); 
%                     X = X(:,remainingDims);
%                     Y = Y(:,remainingDims);
        end    
    end
    if squeezing == 0
        finalRemainingDims = finalRemainingDims(remainingDims);
    end
    if squeezing == 1
        tmpBeta = zeros(size(X_ref, 2), 1);
        tmpBeta(finalRemainingDims) = betaOpt;
        betaOpt = tmpBeta;
    end
    betaOpt = betaOpt / k0; % alpha: not necessary    
          
    betas(:, scrPathInd) = betaOpt;
    alphas(scrPathInd) = alphaOpt(1);
    dims{scrPathInd} = finalRemainingDims;
end


if strcmp(intercptchoice, 'simuopt2')
    alphas = betas(1,:);
    betas = betas(2:end, :);
end
