function [matBetaEsts, alphaEsts] = EstsCorrection(corrt, thresholdingWay, matBetaEsts, alphaEsts, X, X_scl, y, k0, family, Nu, intercept)
[n, d] = size(X_scl);
% Correct the obtained estimate. If corrt=0, no correction. If corrt=1,
% correct the slope parameters. If corrt=2, correct the intercept estimate.
% If corrt=3, correct both.
if numel(Nu) > 1
        Nu = reshape(Nu, 1, size(matBetaEsts, 2));
end
switch lower(thresholdingWay)
%     case {'soft'}
%         ;
    case {'soft', 'scad', 'hard', 'hybrid', 'hybrid-prop'}
        if corrt == 1 
            % beta is the unpenalized est (hard) or penalized (hybrid) both via Nu with zero or fixed intercept 
            for tmpai = 1:size(matBetaEsts, 2)
                if size(Nu, 2) > 1
                    tmpNu = Nu(tmpai);
                else
                    tmpNu = Nu;
                end
                tmpNzs = matBetaEsts(:, tmpai)~=0;
                tmpw = GLM_opt(X_scl(:, tmpNzs), y, tmpNu, family, intercept)/k0;
                matBetaEsts(tmpNzs, tmpai) = tmpw;
            end                    
        elseif corrt == 2
            % alpha is the unpenalized est (hard) or or penalized (hybrid) both via Nu (with no intercept param)
            for tmpai = 1:size(matBetaEsts, 2)
                if size(Nu, 2) > 1
                    tmpNu = Nu(tmpai);
                else
                    tmpNu = Nu;
                end
                tmpNzs = matBetaEsts(:, tmpai)~=0;
                tmpw = GLM_opt([ones(n, 1),X_scl(:, tmpNzs)], y, [0; tmpNu*ones(sum(tmpNzs),1)], family);
                        %GLM_opt([ones(n, 1),X(:, tmpNzs)], y, 1e-8, family);
%                     logRegFun(y, [ones(n, 1),X(:, tmpNzs)], 1e-8); % only applies to logistic!!
                alphaEsts(tmpai) = tmpw(1);
            end
        elseif corrt == 3
            % alpha and beta are the unpenalized est (hard) or or penalized (hybrid) both via Nu (with no intercept param)
            for tmpai = 1:size(matBetaEsts, 2)
                if size(Nu, 2) > 1
                    tmpNu = Nu(tmpai);
                else
                    tmpNu = Nu;
                end
                tmpNzs = matBetaEsts(:, tmpai)~=0;
                tmpw = GLM_opt([ones(n, 1),X_scl(:, tmpNzs)], y, [0; tmpNu*ones(sum(tmpNzs),1)], family);
                matBetaEsts(tmpNzs, tmpai) = tmpw(2:end)/k0; 
                alphaEsts(tmpai) = tmpw(1);
            end
            
%             % The following is for 'simuopt2', but is usually not necessary because in that case corrt=0
%             for tmpai = 1:size(matBetaEsts, 2)
%                 tmpNzs = matBetaEsts(:, tmpai)~=0;
%                 tmpw = GLM_opt(X_scl(:, [1; 1+find(tmpNzs)]), y, [0; Nu*ones(sum(tmpNzs),1)], family);
%                 matBetaEsts(tmpNzs, tmpai) = tmpw(2:end)/k0; 
%                 alphaEsts(tmpai) = tmpw(1)/k0;
%             end            
        end
    otherwise
        error('Not implemented yet!')
end             