function [betaEst, alpha, totNum] = TISP_GLM(X, y, Lambda, family, thresholdingWay, errBnd, maxIT, betaInit, Nu, intercptchoice, intercept, updating, relaxWay, grps)
% This is the main TISP procedure (Y. She) 
% Arguements:   X -- model matrix which does not contain the shift column unless when intercptchoice='simuopt2', 
%               y -- responses, 
%               Lambda -- the lambda parameter, 
%               family -- glm family, 
%               thresholdingWay -- the threshold function, 
%               errBnd -- error tolerance, 
%               maxIT -- max iteration number allowed,
%               betaInit -- initial estimate, 
%               Nu -- the ridge parameter, 
%               intercptchoice -- how to estimate the intercept, 
%               intercept -- initial intercept estimate, 
%               updating -- the way to update TISP (synchrnous or others), 
%               relaxWay -- relaxation form ,
%               grps -- grouping indices
%%%%%
% More about the 'intercptchoice': none: no intercept included, 'fixedopt':
% the intercept is from the unpenalized MLE and fixed during the iteration,
% 'simuopt': use alternative optimization to solve for the intercept and
% slope, 'simuopt2': use the weighted form (setting the first component of
% lambda to be zero) -- recommended. In all cases, beta is associated with X.
%%%%%
% Values: betaEst and alpha are the slope and intercept estimates. The
%           number of iterations performed is recorded in totNum.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% X has been scaled

%%%%%%%%%%%%% To be implemented!!
T = eye(size(X, 2));
%initWay ??

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%% Initionaliztion starts %%%%%%%%%%%%%%%%%%%%
if ~exist('updating', 'var')  | isempty(updating)
    updating = 'synchronous' % 'asynchronous' % 'coordes' %
end

[n, d] = size(X); %d = size(X, 2); 

%%%% Group form only %%%%%
if ~exist('grps', 'var') | isempty(grps)
    grps = [];
else
    % The predictors are grouped
    if strcmp(intercptchoice, 'simuopt2')
        grps = [1, 1+grps]; % there's an additional intercept term 
    end
    grps = reshape(grps, 1, d);
    numGrps = max(grps);
    % Extract the predictor indices for each group
    if numGrps < sqrt(numel(grps))  % not too many groups
        % Use a cell array to store the predictor indices of each group
        grpForm = 0;
        groups = cell(numGrps, 1);
        for grpInd = 1:numGrps
            groups{grpInd} = find(grps==grpInd);
        end
    else  % too many groups
        % Use a two-dim matrix to store the predictor indices of each group
        % For a smaller group, we fill in the largest index+1
        grpForm = 1;
        [grps_b, grps_m] = unique(sort(grps), 'last');
        maxGrpSize = max( [grps_m(1), grps_m(2:end)-grps_m(1:(end-1))] );
        groups = (numel(grps) + 1) *ones(maxGrpSize, numGrps);
        for grpInd = 1:numGrps
            tmpGrpElems = find(grps==grpInd);
            groups(1:numel(tmpGrpElems), grpInd) = tmpGrpElems;
        end
    end    
end
%%%%% Group form done %%%%
if strcmp(intercptchoice, 'none') | strcmp(intercptchoice, 'simuopt2') % alpha is forced to be 0s
    alpha = zeros(n, 1); % size: nx1
elseif strcmp(intercptchoice, 'fixedopt')   % alpha must be transferred in
    if numel(intercept) == 1
        alpha = intercept * ones(n, 1);
    else
        alpha = reshape(intercept, n, 1);
    end
end % 'simuopt': no need of alpha from outside

if isempty(betaInit)
    betaInit = zeros(d, 1); % glmfit(X, y, 'binomial', 'constant', 'off') %  
else
    betaInit = reshape(betaInit, d, 1);
end
beta_cur =  betaInit;

if numel(Lambda) == 1
    Lambda_new = Lambda * ones(d, 1);
else
    Lambda_new = reshape(Lambda, d, 1);
end
if strcmp(intercptchoice, 'simuopt2') & Nu(1) ~= 0
    error('Wrong Nu parameter')
end
if exist('Nu', 'var')    
    if max(Nu)>.1 && ~strcmp(thresholdingWay, 'hybrid') && ~strcmp(thresholdingWay, 'hybrid-prop')
        % if not hybrid, 0 or a very small value which helps decorrelation
        error('Nu should be close to 0')
    end
    if numel(Nu) == 1
        Nu_new = Nu * ones(d, 1);
    else
        Nu_new = reshape(Nu, d, 1);
    end
else
    if strcmp(thresholdingWay, 'hybrid') || strcmp(thresholdingWay, 'hybrid-prop')
        disp('Nu not specified; set to be lambda/4')
        Nu_new = (Lambda_new)/4;% for snr low or medium, not huge; good init
    else
        Nu_new = [];
    end    
end

if ~exist('relaxWay', 'var')
    relaxWay = 0;
end
if relaxWay == 1
    omega = 2;
    xi_cur = zeros(d, 1); 
else
    omega = 1;
end

j = 0; 
vecHXy = X' * y;
realInnErrBnd = errBnd;
gamma_E = zeros(size(beta_cur));

% recorrIT = 50; %maxIT + 1; % 
%%%%%%%%%%% ITERATION starts %%%%%%%%%%%%%%%%%%%%
while 1
    j = j + 1;
%     j, k
%     beta_cur'

	%The following recorrection after a few iterations does not speed the convergence. The solution path can be different, and is slower.
%     if d > 1
%         if strcmp(updating, 'synchronous') && (mod(j, recorrIT) == 1 ) %|| mod(j, recorrIT) == 2 || mod(j, recorrIT) == 3)
%             oldupdating = updating;
%             updating =  'asynchronous';  %'coordes'; %  'synchronous' %
%         elseif exist('oldupdating', 'var') & ~isempty(oldupdating)
%             updating = oldupdating;
%             oldupdating = [];
%         end
%     end
    %The following final-correction cannot be used to speed the convergence. Every time it is done, the iterates stop updating. 
%     if mod(j, recorrIT) == 0 %mod(j, maxIT+1) == 0 % 1 %  
%         if ~strcmp(thresholdingWay, 'hard') && ~strcmp(thresholdingWay, 'hybrid')
%             error('not implemented yet for other thresholdings')
%         end
%         if strcmp(intercptchoice, 'simuopt')
%             alphaEst = GLM_opt(ones(n, 1), y, 0, family, X*beta_cur, realInnErrBnd) ;
%             alpha = alphaEst * ones(n, 1); 
%         end        
%         gamma_E = beta_cur;
%         if strcmp(intercptchoice, 'none') | strcmp(intercptchoice, 'fixedopt')
%             gamma_E(gamma_E~=0) = GLM_opt(X(:, gamma_E~=0), y, Nu_new(gamma_E~=0), family, alpha); % alpha might be nz for 'fixedopt'
%         elseif strcmp(intercptchoice, 'simuopt')
%             tmpw = GLM_opt([ones(n, 1), X(:, gamma_E~=0)], y, [0; Nu_new(gamma_E~=0)], family); % no penalty for intercept
%             gamma_E(gamma_E~=0) = tmpw(2:end); 
%             alpha = tmpw(1)*ones(n,1);
%         elseif strcmp(intercptchoice, 'simuopt2')
%             % Nu(1)== 0
%             gamma_E(gamma_E~=0) = GLM_opt(X(:, gamma_E~=0), y, Nu_new(gamma_E~=0), family, alpha); % alpha might be nz for 'fixedopt'
%         end    
%     else
    switch lower(updating)
    case {'synchronous'}
        if strcmp(intercptchoice, 'simuopt')
            alphaEst = GLM_opt(ones(n, 1), y, 0, family, X*beta_cur, realInnErrBnd) ;
            alpha = alphaEst * ones(n, 1); 
        end
        mu = GLM_mean(X, beta_cur, family, alpha); %exp(X * beta_cur) ./ (exp(X * beta_cur) + 1);      

        xi_new =  beta_cur + vecHXy - X' * mu;
        if j > 1 && relaxWay == 1
            xi_new = (1 - omega) * xi_cur + omega * xi_new; 
        end
        
        % thresholding
        if isempty(grps)
            switch lower(thresholdingWay)
                case {'soft'}    
                    gamma_E(:) = 0; 
                    ttInds1 = find(xi_new>Lambda_new);
                    ttInds2 = find(xi_new<-Lambda_new);
                    
                    gamma_E(ttInds1) =  xi_new(ttInds1) - Lambda_new(ttInds1); 
                    gamma_E(ttInds2) = xi_new(ttInds2) + Lambda_new(ttInds2);  
                case {'hard'}
                    gamma_E(:) = 0; 
            %             gamma_E(xi_new>Lambda_new) =  xi_new(xi_new>Lambda_new);  
            %             gamma_E(xi_new<-Lambda_new) = xi_new(xi_new<-Lambda_new);
                    ttInds = find(abs(xi_new)>Lambda_new);            
                    gamma_E(ttInds) = xi_new(ttInds);            
                case {'none'}
                    gamma_E = xi_new; % no thresholding -- takes more iterations
                case {'scad'}
                    a = 3.7;
                    %%%
                    gamma_E(:) = 0; 
                    ttInds1 = find(xi_new>Lambda_new);
                    ttInds2 = find(xi_new>2*Lambda_new);
                    ttInds3 = find(abs(xi_new)>a*Lambda_new);
                    
                    gamma_E(ttInds1) =  xi_new(ttInds1) - Lambda_new(ttInds1); 
                    gamma_E(ttInds2) =  ( (a-1)*xi_new(ttInds2) - a * Lambda_new(ttInds2) ) / (a-2); 
                    gamma_E(ttInds3) = xi_new(ttInds3);
                    
                    ttInds1 = find(xi_new<-Lambda_new);
                    ttInds2 = find(xi_new<-2*Lambda_new);
                    gamma_E(ttInds1) =  xi_new(ttInds1) + Lambda_new(ttInds1); 
                    gamma_E(ttInds2) =  ( (a-1)*xi_new(ttInds2) + a * Lambda_new(ttInds2) ) / (a-2); 
                    
                    %%%                    
%                     gamma_E(:) = 0; 
%                     gamma_E(xi_new>Lambda_new) =  xi_new(xi_new>Lambda_new) - Lambda_new(xi_new>Lambda_new); 
%                     gamma_E(xi_new<-Lambda_new) = xi_new(xi_new<-Lambda_new) + Lambda_new(xi_new<-Lambda_new);              
% 
%                     gamma_E(xi_new>2*Lambda_new) =  ( (a-1)*xi_new(xi_new>2*Lambda_new) - a * Lambda_new(xi_new>2*Lambda_new) ) / (a-2); 
%                     gamma_E(xi_new<-2*Lambda_new) =  ( (a-1)*xi_new(xi_new<-2*Lambda_new) + a * Lambda_new(xi_new<-2*Lambda_new) ) / (a-2);             
% 
%                     gamma_E(abs(xi_new)>a*Lambda_new) = xi_new(abs(xi_new)>a*Lambda_new);  
                case {'hybrid'}
                    gamma_E(:) = 0; 
                    ttInds = find(abs(xi_new)>Lambda_new);            
                    gamma_E(ttInds) =  xi_new(ttInds) ./ ( 1+Nu_new(ttInds));                         
                case {'hybrid-prop'}
                    if strcmp(intercptchoice, 'simuopt2') % The Lambda(1) corresponds to the intercept which should arise
                        tmpinds = [1; isinf(Lambda_new(2:end))]; % inf: unpenalized
                        quan = 1 - Lambda_new / (numel(Lambda_new) -sum(tmpinds)); %use the rest to do quantile-thresholding
                        quan(quan < 0) =0; 
                        thval = zeros(size(xi_new));
                        thval(~tmpinds) = quantile(abs(xi_new(~tmpinds)), quan(~tmpinds));                     
                        thval(quan==0) = 0;

%                         quan = 1 - Lambda(2:end)/(d-1);
%                         quan(quan<0) = 0;
%                         thval = quantile(abs(xi_new(2:end)), quan); % Lambda(2:end) correspond to the slope parameter beta, and should be nonzero
%                         thval(quan==0) = 0;
%                         thval= [0; thval]; % intercept, no penalty
                    else
                        tmpinds = (isinf(Lambda_new)); % inf: unpenalized
                        quan = 1 - Lambda_new / (numel(Lambda_new) -sum(tmpinds));%use the rest to do quantile-thresholding
                        quan(quan < 0) =0; 
                        thval = zeros(size(xi_new));
                        thval(~tmpinds) = quantile(abs(xi_new(~tmpinds)), quan(~tmpinds));                     
                        thval(quan==0) = 0;
                        
%                         quan = 1 - Lambda / d;
%                         quan(quan < 0) =0; 
%                         thval = quantile(abs(xi_new), quan);                     
%                         thval(quan==0) = 0;
                    end
                        % The reason of doing in the above way: due to the implementation of quantile, thval(1) is not zero even if Lambda(1) = 0
                    gamma_E(:) = 0;
                    ttInds = find(abs(xi_new) > thval);
                    gamma_E(ttInds) = xi_new(ttInds) ./ ( 1+Nu_new(ttInds));
                case {'ridge'}
                    gamma_E =  xi_new ./ (1+Lambda_new); 
                otherwise
                    error('not implemented yet')
            end          
        else
            %%%%%%%%%%% Group form only %%%%%%%%%%%
            
%             xi_new_norm = xi_new;
%             for grpInd = 1:numGrps
%                 xi_new_norm(grps==grpInd) = norm(xi_new(grps==grpInd),2);
%             end
%             The above way is too slow

            if grpForm == 0 % not so many groups
                xi_new_norm = xi_new.^2;
                for grpInd = 1:numGrps
                    xi_new_norm(groups{grpInd}) = sqrt(sum(xi_new_norm(groups{grpInd})));
                end            
            else % too many groups
                % The following way can be more efficient to compute the
                % group form
                tt = [xi_new; 0];
                grpnorms = sqrt(sum(tt(groups).^2));
                xi_new_norm = grpnorms(grps)';
            end

            switch lower(thresholdingWay)
                case {'soft'}    
                    gamma_E(:) = 0; 
                    ttInds = find(xi_new_norm>Lambda_new);
                    gamma_E(ttInds) =  xi_new(ttInds)./xi_new_norm(ttInds).*(xi_new_norm(ttInds) - Lambda_new(ttInds)); 
                case {'hard'}
                    gamma_E(:) = 0; 
                    ttInds = xi_new_norm>Lambda_new;
                    gamma_E(ttInds) = xi_new(ttInds);            
                case {'none'}
                    gamma_E = xi_new; % no thresholding -- usually take more iterations to converge
                case {'scad'}
                    a = 3.7;
                    gamma_E(:) = 0; 
                    ttInds1 = find(xi_new_norm>Lambda_new);
                    ttInds2 = find(xi_new_norm>2*Lambda_new);
                    ttInds3 = find(xi_new_norm>a*Lambda_new);
                    
                    gamma_E(ttInds1) =  xi_new(ttInds1)./xi_new_norm(ttInds1).*(xi_new_norm(ttInds1) - Lambda_new(ttInds1)); 
                    gamma_E(ttInds2) =  xi_new(ttInds2)./xi_new_norm(ttInds2).*( (a-1)*xi_new_norm(ttInds2) - a * Lambda_new(ttInds2) ) / (a-2); 
                    gamma_E(ttInds3) = xi_new(ttInds3);
  
                case {'hybrid'}
                    gamma_E(:) = 0; 
                    ttInds = xi_new_norm > Lambda_new;
                    gamma_E(ttInds) =  xi_new(ttInds) ./ ( 1+Nu_new(ttInds));                         
                case {'hybrid-prop'}
                    % In this case, Lambda specifies the total number of nonzeros
                    if strcmp(intercptchoice, 'simuopt2') % The Lambda(1) corresponds to the intercept which should arise
                        tmpinds = [1, isinf(Lambda_new(2:end))]; % inf: unpenalized
                        quan = 1 - Lambda_new / (numel(Lambda_new) -sum(tmpinds)); %use the rest to do quantile-thresholding
                        quan(quan < 0) =0; 
                        thval = zeros(size(xi_new_norm));
                        thval(~tmpinds) = quantile(abs(xi_new_norm(~tmpinds)), quan(~tmpinds));                     
                        thval(quan==0) = 0;
                        
%                         quan = 1 - Lambda(2:end)/(d-1);
%                         quan(quan<0) = 0;
%                         thval = quantile(xi_new_norm(2:end), quan); % Lambda(2:end) correspond to the slope parameter beta, and are usually nonzero
%                         thval(quan==0) = 0;
%                         thval= [0; thval]; % intercept, no penalty
                    else
                        tmpinds = (isinf(Lambda_new)); % inf: unpenalized
                        quan = 1 - Lambda_new / (numel(Lambda_new) -sum(tmpinds));%use the rest to do quantile-thresholding
                        quan(quan < 0) =0; 
                        thval = zeros(size(xi_new_norm));
                        thval(~tmpinds) = quantile(abs(xi_new_norm(~tmpinds)), quan(~tmpinds));                     
                        thval(quan==0) = 0;
                        
%                         quan = 1 - Lambda / d;
%                         quan(quan < 0) =0; 
%                         thval = quantile(xi_new_norm, quan); 
%                         thval(quan==0) = 0;
                    end
                        % The reason of doing in the above way: due to the implementation of quantile, thval(1) is not zero even if Lambda(1) = 0
                    gamma_E(:) = 0;
                    ttInds = xi_new_norm > thval;
                    gamma_E(ttInds) = xi_new(ttInds) ./ ( 1+Nu_new(ttInds));
                case {'ridge'}
                    gamma_E =  xi_new ./ (1+Lambda_new); 
                otherwise
                    error('not implemented yet')
            end 
            %%%% Group form done %%%%%
        end
    case {'asynchronous'}  
%         disp('inside')
        tmpgammae = beta_cur; 
        for i = 1:d          
            if strcmp(intercptchoice, 'simuopt')
                alphaEst = GLM_opt(ones(n, 1), y, 0, family, X*tmpgammae, realInnErrBnd) ;
                alpha = alphaEst * ones(n, 1); 
            end
            mu = GLM_mean(X, tmpgammae, family, alpha); %exp(X * beta_cur) ./ (exp(X * beta_cur) + 1);      

            tmpxi = tmpgammae(i) + vecHXy(i) - X(:,i)' * mu;

            switch lower(thresholdingWay)
                case {'soft'}
                    if tmpxi > Lambda_new(i)
                        tmpgammae(i) = tmpxi - Lambda_new(i);
                    elseif tmpxi < -Lambda_new(i)
                        tmpgammae(i) = tmpxi + Lambda_new(i);
                    else
                        tmpgammae(i) = 0;
                    end
                case {'hard'}
                    if abs(tmpxi) > Lambda_new(i)
                        tmpgammae(i) = tmpxi;
                    else
                        tmpgammae(i) = 0;
                    end
                case {'none'}
                    tmpgammae(i) = tmpxi;
                case {'scad'}
                    a = 3.7;
                    tmpgammae(i) = 0;
                    if tmpxi > Lambda_new(i)
                        tmpgammae(i) = tmpxi - Lambda_new(i);
                    elseif tmpxi < -Lambda_new(i)
                        tmpgammae(i) = tmpxi + Lambda_new(i);
                    end
                    if tmpxi > 2*Lambda_new(i)
                        tmpgammae(i) = ( (a-1)*tmpxi-a*Lambda_new(i) )/(a-2);
                        tmpgammae(i) = ( (a-1)*tmpxi+a*Lambda_new(i) )/(a-2);
                    elseif tmpxi < -2*Lambda_new(i)
                        tmpgammae(i) = tmpxi;
                    end                
                    if tmpxi > a*Lambda_new(i)
                        tmpgammae(i) = tmpxi;
                    elseif tmpxi < -a*Lambda_new(i)
                        tmpgammae(i) = tmpxi;
                    end
                case {'hybrid'}
                    if abs(tmpxi) > Lambda_new(i)
                        tmpgammae(i) = tmpxi / (1+Nu_new(i));
                    else
                        tmpgammae(i) = 0;
                    end
                case {'ridge'}
                    tmpgammae(i) = tmpxi/(1+Lambda_new(i));
                otherwise
                    error('not implemented yet')
            end         

        end    
        gamma_E = tmpgammae; xi_new = tmpxi;
    case {'coordes'}
        tmpgammae = beta_cur; 
        for i = 1:d          
            if strcmp(intercptchoice, 'simuopt')
                alphaEst = GLM_opt(ones(n, 1), y, 0, family, X*tmpgammae, realInnErrBnd) ;
                alpha = alphaEst * ones(n, 1); 
            end

            tmpshift = (X*tmpgammae - X(:,i)*tmpgammae(i)) + alpha; % applies to d=1, otherwise same as %X(:, [1:(i-1),(i+1):end]) * tmpgammae([1:(i-1), (i+1):end])
            tmpgammae(i) = TISP_GLM(X(:, i), y, Lambda_new(i), family, thresholdingWay, realInnErrBnd, maxIT, tmpgammae(i), Nu_new(i), 'fixedopt', tmpshift, 'synchronous');
        end    
        gamma_E = tmpgammae; 
    otherwise
        error('wrong updating parameter')
    end
%     end
    beta_new = gamma_E;
%     find(gamma_E~=0)'
	

    if  (max(abs(beta_new-beta_cur)) < realInnErrBnd ) % &&mod(j, recorrIT) > recorrIT/10
        break;
    end
    if j >= maxIT % 1e+6 %1e+5 %
%         disp('maxIT reached!!')
        switch lower(thresholdingWay)
            case {'hard', 'hybrid', 'hybrid-prop'}
                if strcmp(intercptchoice, 'none') | strcmp(intercptchoice, 'fixedopt')
                    beta_new(beta_new~=0) = GLM_opt(X(:, beta_new~=0), y, Nu_new(beta_new~=0), family, alpha); % alpha might be nz for 'fixedopt'
                       % logRegFun(y, X(:, beta_new~=0), 1e-8); % only for logistic!
                       % GLM_cvxopt(X(:, beta_new~=0), y, family, 'l2', 1e-8);
                       % glmfit(X(:, beta_new~=0), y, family, 'constant', 'off'); % unpenalized fit, might be singular
                       % TISP_GLM(X(:, beta_new~=0), y, 1e-8, family, 'ridge', errBnd, maxIT, beta_new( beta_new~=0));  % use l2-pen with mild lambda
                       % TISP_GLM(X(:, beta_new~=0), y,    0, family, 'ridge', errBnd, maxIT, beta_new( beta_new~=0));  % use l2-pen with lambda=0
                elseif strcmp(intercptchoice, 'simuopt')
                    tmpw = GLM_opt([ones(n, 1), X(:, beta_new~=0)], y, [0; Nu_new(beta_new~=0)], family); % no penalty for intercept
                    beta_new(beta_new~=0) = tmpw(2:end); 
                    alpha = tmpw(1)*ones(n,1);
                elseif strcmp(intercptchoice, 'simuopt2')
                    % Nu(1)== 0
                    beta_new(beta_new~=0) = GLM_opt(X(:, beta_new~=0), y, Nu_new(beta_new~=0), family, alpha); % alpha might be nz for 'fixedopt'
                end
%            case {'hybrid'} % same as 'hard' because of the existence of Nu
%                if strcmp(intercptchoice, 'none') | strcmp(intercptchoice, 'fixedopt')
%                     % note: no scaling for this function
%                     beta_new(beta_new~=0) = GLM_opt(X(:, beta_new~=0), y, Nu, family, alpha);
%                         %logRegFun(y, X(:, beta_new~=0), Nu); % only for logistic!
%                         %GLM_cvxopt(X(:, beta_new~=0), y, family, 'l2', Nu);
%                         %TISP_GLM(X(:, beta_new~=0), y, Nu, family, 'ridge', errBnd, maxIT, beta_new( beta_new~=0));
%                             % may use another way to get the partial l2-logistic solution!
%                elseif strcmp(intercptchoice, 'simuopt')
%                     tmpw = GLM_opt([ones(n, 1), X(:, beta_new~=0)], y, [0; Nu*ones(sum(beta_new~=0),1)], family); % no penalty for intercept
%                     beta_new(beta_new~=0) = tmpw(2:end); 
%                     alpha = tmpw(1)*ones(n,1);
%                elseif strcmp(intercptchoice, 'simuopt2')
%                    beta_new(beta_new~=0) = GLM_opt(X(:, beta_new~=0), y, [0; Nu*ones(sum(beta_new~=0)-1,1)], family, alpha); % alpha might be nz for 'fixedopt'
%                end

            otherwise
            	%warning([thresholdingWay, ': not implemented yet for maxIT final correction'])
        end                  
        break;
    end
    
    beta_cur = beta_new;
    if relaxWay == 1 
        xi_cur = xi_new; % relaxation
    end
    
    %j, beta_cur
end

betaEst = beta_new;
totNum = j;

% disp(totNum);
% % if ~strcmp(updating, 'asynchronous') | strcmp(oldupdating, 'synchronous') % d>1
% disp([num2str(updating) , ' | Lambda, j: ', num2str(Lambda(end)), ', ', num2str(j), '; num of nz: ', num2str(sum(betaEst~=0))]) %
% % end