%%%%%%%%%%%%%%%%%%%% Tuning (2 - for hybrid TISP only) %%%%%%%%%%%%%%%%%%%
% This tuning is for the ridge paramter in hybrid-thresholding only, where lambda is fixed.

if ~strcmp(thresholdingWay, 'hybrid'), error('Thresholding should be hybrid'), end

% tuningMethod = 'BICm' % 'BIC' %'validation' %  

% Remove reduant estimates -- beta
redundantInds = find(sum(abs(matBetaEsts(:,2:end)-matBetaEsts(:,1:end-1)))<1e-4)+1;
matBetaEsts(:, redundantInds) = []; alphaEsts(redundantInds) = []; nus(redundantInds) = [];%not scaled 
% sprintf(['num of distinct betas:', num2str(size(matBetaEsts,2))])
            
% Estimate-correction (penalized-unpenalized hybrid method)
% and DF computation
switch lower(thresholdingWay)
    case {'hybrid', 'hybrid-prop'} 
        if strcmp(intercptchoice, 'none') 
            corrt = 0; %1; %  
                % 0 % no further correction 
                % 1 % correct beta  using unpenalized with fixed intercept 
                % 2 % correct alpha using unpenalized  % 3 % correct beta and alpha using unpenalized 
            if unpenCorr
                corrt = 1;
            end
            % claim: alphaEsts == 0
            if ~all(alphaEsts == 0)
                error('wrong intercept calculation')
            end
        elseif strcmp(intercptchoice, 'fixedopt')
            % problem: fixed alpha est is not the MLE est ????????
            corrt = 0; %3; % 2; % 
            if unpenCorr
                corrt = 3;
            end
        elseif strcmp(intercptchoice, 'simuopt') | strcmp(intercptchoice, 'simuopt2')
            % Note that when 'simuopt2', corrt must be 0 because the implementation uses the original X matrix
            corrt = 0; % 3; %
            if unpenCorr
                corrt = 3;
            end
        end
        tmpNu = nus; %1e-8 %  
        if unpenCorr
            tmpNu = 1e-8;
        end          
        [matBetaEsts, alphaEsts] = EstsCorrection(corrt, thresholdingWay, matBetaEsts, alphaEsts, X, X_scl, y, k0, family, tmpNu, intercept);

        
        DF = zeros(1, size(matBetaEsts, 2));
        for tmpai = 1:size(matBetaEsts, 2)
            tmpNu = nus(tmpai); 
            tmpNzs = matBetaEsts(:, tmpai)~=0;
            if unpenCorr
                tmpNu = 1e-8;
            end             
            if ~strcmp(intercptchoice, 'none')
                DF(tmpai) = hybridTISP_DF([ones(n, 1),X(:, tmpNzs)], y, [alphaEsts(tmpai); matBetaEsts( tmpNzs, tmpai)], [0; k0^2*tmpNu*ones(sum(tmpNzs),1)], family);
                % the same as: %  hybridTISP_DF([ones(n, 1),X_scl(:, tmpNzs)], y, [alphaEsts(tmpai); k0*matBetaEsts( tmpNzs, tmpai)], [0; Nu*ones(sum(tmpNzs),1)], family);
            else
                DF(tmpai) = hybridTISP_DF([X(:, tmpNzs)], y, [matBetaEsts( tmpNzs, tmpai)], [k0^2*tmpNu*ones(sum(tmpNzs),1)], family);
            end
        end

    otherwise
        error('Wrong thresholding for this tuning function!')
end

% Calculate risk using different methods
if strcmp(tuningMethod, 'validation')  
    riskEst = GLM_negLogLik(valX, valY, matBetaEsts, family, ones(size(valX, 1), 1)*alphaEsts); 
%     DF = sum(matBetaEsts~=0) + (alphaEsts~=0); % No dispersion 
    optSet = find( riskEst == min(riskEst) );
	betaOptInd = optSet(find(DF(optSet) == min(DF(optSet)), 1, 'first'));  
    betaOpt = matBetaEsts(:, betaOptInd); alphaOpt = alphaEsts(betaOptInd);
elseif strcmp(tuningMethod, 'selCV')
    % DF available
    %[nCV, dataIndsCV, dataIndsCVStarts, dataIndsCVEnds] must be available
    [betaOpt, alphaOpt, betaOptInd, riskEst] = TISPTuning_GLM_wSelCV(nCV, matBetaEsts, alphaEsts, family, X, y, k0, ...
        dataIndsCV, dataIndsCVStarts, dataIndsCVEnds, minTh0, DF, thresholdingWay, intercptchoice, nus, scvbiascorrt, matchLocEst, unpenCorr, output);
    
else    
    if strcmp(tuningMethod, 'BIC')        %BIC
        riskEst = ( GLM_negLogLik(X, y, matBetaEsts, family, ones(n,1)* alphaEsts) + 1/2*log(n).* DF )/n;  %
        if strcmp(family, 'gaussian')
            % consider the scale estimate
            riskEst = ( n/2*log(GLM_negLogLik(X, y, matBetaEsts, family, ones(n,1)* alphaEsts)) + 1/2*log(n).* (DF+1) )/n; 
        end        
    elseif strcmp(tuningMethod, 'BICm')   %BICm
        riskEst = ( GLM_negLogLik(X, y, matBetaEsts, family, ones(n,1)* alphaEsts) + 1/2*(log(n)+1) .* DF )/n; 
        if strcmp(family, 'gaussian')
            % consider the scale estimate
            riskEst = ( n/2*log(GLM_negLogLik(X, y, matBetaEsts, family, ones(n,1)* alphaEsts)) + 1/2*(log(n)+1).* (DF+1) )/n; 
        end        
    end

%             betaOptInd = LocMinLargestNeigh_Func(riskEst, DF);

    optSet = find( riskEst == min(riskEst) );
    betaOptInd = optSet(find(DF(optSet) == min(DF(optSet)), 1, 'first'));  

    betaOpt = matBetaEsts(:, betaOptInd); 
    alphaOpt = alphaEsts(betaOptInd);
end
if output, figure; plot(DF, riskEst, 'rx'); end

disp([tuningMethod, ' | DF: ', num2str(DF(betaOptInd)), ',optInd: ', num2str(betaOptInd)])

%%% Summarize %%%%%%%%%
if exist('tstY', 'var')
    if exist('betaTrue', 'var')
        modelErr = GLM_negLogLik(tstX, tstY, betaOpt, family, alphaOpt*ones(size(tstX,1),1)) / GLM_negLogLik(tstX, tstY, betaTrue, family, alphaTrue*ones(size(tstX,1),1)) -1;
    else
        if strcmp(family, 'binomial')
            modelErr = sum( xor(tstX * betaOpt + alphaOpt > 0, tstY) );
        end
        if strcmp(family, 'gaussian') % squared prediction error
            if numel(betaOpt) > size(tstX,2)
                modelErr = sum( (tstY - (tstX * betaOpt(1:size(tstX,2)) + sum( betaOpt((size(tstX,2)+1):end) .* alphaCenterAdj((size(tstX,2)+1):end) ) + alphaOpt)).^2 );
                    % though the above considers the outlier mean and
                    % should be incorrect, it actually gives better mse on
                    % test data (sugar dataset)??
                modelErr = sum( (tstY - (tstX * betaOpt(1:size(tstX,2)) + alphaOpt)).^2 ); % this is seemingly the correct way
                % Note that X can be augmented to include case params (and then screened)
            else
                modelErr = sum( (tstY - (tstX * betaOpt + alphaOpt)).^2 );
            end            
            
        end        
    end
else
    modelErr = NaN; %[];
end
disp(['modelErr=', num2str(modelErr)])
if output, betaOpt', end

