function [alphaOpt, betaOpt, X_scl, Nu, k0, intercept] = HybridTISP_SingleRun(X, y, family, Lambda, Nu, thresholdingWay, errBnd, maxIT, ...
    intercptchoice, updating, relaxWay, grps)
% Compute the hybrid hard-ridge TISP estimate using the given parameters
% Same arguments as function TISP_GLM.

global totalTispTime;%*%

[n ,d] = size(X);
if ~exist('grps', 'var') | isempty(grps)
    grps = [];
else
    grps = reshape(grps, 1, d);
    numGrps = max(grps);
end
if strcmp(intercptchoice, 'simuopt2')
    oldX = X;
    X = [ones(size(X,1),1), X];
    d = d + 1;
end
%%% scaling
switch lower(family)
   case {'binomial'}
        k0 = .5*norm(X, 2);
   case 'poisson'
        sprintf('no universal bound!')
        k0 = max(exp(X* glmfit(X, y, 'poisson', 'constant', 'off')/2)) * norm(X, 2);  
   case 'gaussian'
        k0 = norm(X, 2);  
   otherwise
      error('not implemented yet')
end  
X_scl = X ./ k0;
%%%%%%%%%

%%%%%%%%% initialization %%%%%%%%%%
   
% thresholdingWay = 'soft' %'hard' %'scad' %  'none' %
% family = 'binomial' % 'poisson' % 'gaussian' %
% nPoints = 50; % 200;
% maxIT = 1e+4 %1e+5 %  5e+5
% errBnd = 1e-5 % 1e-7%
betaInit = zeros(d, 1); % b;   

% intercptchoice = 'simuopt' %'fixedopt' % 'none' %  

% if exist('centerX', 'var') && centerX == 1 && strcmp(intercptchoice, 'none'), error('Intercept should be included in the model'), end

if strcmp(intercptchoice, 'none') |  strcmp(intercptchoice, 'simuopt2')
    intercept = 0; %[];
elseif strcmp(intercptchoice, 'simuopt')
    % used in the contruction of the UPPER bound of Lambda
    intercept = 0; %[]; %GLM_canlink(mean(y), family) ; % a better est????
elseif strcmp(intercptchoice, 'fixedopt')
    intercept = GLM_canlink(mean(y), family) ; %  zeros(n, 1); %1; % []; %
end
 
%%%%%%%% compute the single estimate determined by Lambda & Nu  %%%%%

    if abs(Lambda) < 1e-6  % == 0 %
        disp('lambda=0 (maybe approx)')
        if strcmp(intercptchoice, 'none') | strcmp(intercptchoice, 'fixedopt') % with intercept (fixed or 0)
            alphavec = intercept*ones(n, 1);
            betaEst = GLM_opt(X_scl, y, Nu, family, alphavec);
    %         logRegFun(y, X_scl, 1e-8); % only for logistic regression!
    %         betaEst = glmfit(X_scl, y, family, 'constant', 'off'); % might be singular; consider the following l2-pen with lambda really small
    %         betaEst = TISP_GLM(X_scl, y, 1e-8, family, 'ridge', errBnd, maxIT, betaInit); % how to set the iteration limit? usually lambda too small to converge within maxIT
    %         betaEst = TISP_GLM(X_scl, y,    0, family, 'ridge', errBnd, maxIT, betaInit); % how to set the iteration limit? not converge within maxIT
        elseif strcmp(intercptchoice, 'simuopt')
            tmpw = GLM_opt([ones(n, 1),X_scl], y, [0; Nu*ones(d,1)], family);
            betaEst = tmpw(2:end);
            alphavec = tmpw(1)*ones(n, 1);
        elseif strcmp(intercptchoice, 'simuopt2')
            alphavec = intercept*ones(n, 1);
            betaEst = GLM_opt(X_scl, y, [0; Nu*ones(d-1, 1)], family, alphavec);            
        end
    else
        tempTime=clock;%*%
        if ~strcmp(intercptchoice, 'simuopt2')
            wts = Lambda;
            [betaEst, alphavec, totNum] = TISP_GLM(X_scl, y, wts, family, thresholdingWay, errBnd, maxIT, betaInit, Nu, intercptchoice, intercept*ones(n, 1), updating, relaxWay, grps);   
        else % if 'simuopt2', no penalty for the first column (intercept)
            wts = Lambda*ones(d, 1); wts(1) = 0; 
            [betaEst, alphavec, totNum] = TISP_GLM(X_scl, y, wts, family, thresholdingWay, errBnd, maxIT, betaInit, [0; Nu*ones(d-1,1)], intercptchoice, intercept*ones(n, 1), updating, relaxWay, grps);   
        end
        totalTispTime = totalTispTime+etime(clock,tempTime);%*%
    end
    %%% Scale back!!
    betaEst = betaEst / k0; % alpha: not necessary
     
if strcmp(intercptchoice, 'simuopt2')
    X = oldX;
    d = d - 1;
    alphaOpt = betaEst(1);
    betaOpt = betaEst(2:end);
else
    alphaOpt = alphavec(1);
    betaOpt = betaEst;
end
        