function [matBetaEsts, alphaEsts, nzBs, lambdas, nzPatts, numBs, k0] = ...
    Func_TISPPath_GLM(X, y, intercptchoice, family, lambdasGiven, nPoints, maxIT, errBnd, nzUBnd, updating, relaxWay, thresholdingWay, grps, Nu)

% This function is based on the script 'TISPPath_GLM' that 
% computes the solution-path of TISP. 

% The threshold parameter denoted by 'Lambda' varies over a natural range
% determined by the TISP equation. 
% The solution path is recorded in matBetaEsts and alphaEsts, corresponding
% to slope and intercept estimates respectively.
%%%
% The parameter 'intercptchoice' specifies how to estimate the intercept
% parameter. More details: if 'none', no intercept is included in the
% model; 'fixedopt' gets the intercept from the unpenalized MLE and fixes it 
% during the iteration; 'simuopt': use alternative optimization to solve for 
% the intercept and slope; 'simuopt2' (recommended if intercept is present in the model):
% use the weighted form (setting the first component of lambda to be zero)
%%%
%%%
% Parameter 'lambdasGiven' is for the original data (X, y) without scaling
% Output 'lambdas' is the grid of lambda for scaled data
%%%
[n, d] = size(X);
output = false;
if strcmp(intercptchoice, 'simuopt2')
    oldX = X;
    X = [ones(size(X,1),1), X];
    d = d + 1;
end
%%% scaling
switch lower(family)
   case {'binomial'}
        k0 = .5*norm(X, 2);
   case 'poisson'
        disp('no universal bound!')
        k0 = max(exp(X* glmfit(X, y, 'poisson', 'constant', 'off')/2)) * norm(X, 2);  
   case 'gaussian'
        k0 = norm(X, 2);  
   otherwise
      error('not implemented yet')
end  
X_scl = X ./ k0;
%%%%%%%%%

%%%%%%%%% initialization %%%%%%%%%%
   
% thresholdingWay = 'soft' %'hard' %'scad' %  'none' %
% family = 'binomial' % 'poisson' % 'gaussian' %
% nPoints = 50; % 200;
% maxIT = 1e+4 %1e+5 %  5e+5
% errBnd = 1e-5 % 1e-7%
betaInit = zeros(d, 1); % b;   

% intercptchoice = 'simuopt' %'fixedopt' % 'none' %  

if exist('centerX', 'var') && centerX == 1 && strcmp(intercptchoice, 'none'), error('Intercept should be included in the model'), end

if strcmp(intercptchoice, 'none') |  strcmp(intercptchoice, 'simuopt2')
    intercept = 0; %[];
elseif strcmp(intercptchoice, 'simuopt')
    % used in the contruction of the UPPER bound of Lambda
    intercept = 0; %[]; %GLM_canlink(mean(y), family) ; % a better est????
elseif strcmp(intercptchoice, 'fixedopt')
    intercept = GLM_canlink(mean(y), family) ; %  zeros(n, 1); %1; % []; %
end
if exist('lambdasGiven', 'var') && ~isempty(lambdasGiven)
        lambdas = lambdasGiven /k0; %lambdasGiven;
        % Note that here we only scale X but not y, and thus the lambdas
        % for the scale data times k0 is the lambdas for the original data
else
    lamUBnd_1 = betaInit + X_scl'*y - X_scl' * GLM_mean(X_scl, betaInit, family, intercept);
    if strcmp(intercptchoice, 'simuopt2') % no lambda for the first column
        lamUBnd = max( abs(lamUBnd_1(2:end)) ); 
    else
        lamUBnd = max( abs(lamUBnd_1) ); % 'fixedopt' or 'none'
    end
    lambdas = 0:lamUBnd/nPoints:(lamUBnd+lamUBnd/nPoints); % 1  %0.01:.005:2
    lambdas = lambdas(end:-1:1);
end
alphaEsts = -ones(1, numel(lambdas));
matBetaEsts = []; 
%%%%%%%% compute the solution path %%%%%
for tLambInd = 1:numel(lambdas) % Lambda = lambdas
    Lambda = lambdas(tLambInd); 
    if abs(Lambda) < 1e-6  % == 0 %
        if output, disp('lambda = 0 or close'), end
        if strcmp(intercptchoice, 'none') | strcmp(intercptchoice, 'fixedopt') % with intercept (fixed or 0)
            alphavec = intercept*ones(n, 1);
            betaEst = GLM_opt(X_scl, y, Nu, family, alphavec);
    %         logRegFun(y, X_scl, 1e-8); % only for logistic regression!
    %         betaEst = glmfit(X_scl, y, family, 'constant', 'off'); % might be singular; consider the following l2-pen with lambda really small
    %         betaEst = TISP_GLM(X_scl, y, 1e-8, family, 'ridge', errBnd, maxIT, betaInit); % how to set the iteration limit? usually lambda too small to converge within maxIT
    %         betaEst = TISP_GLM(X_scl, y,    0, family, 'ridge', errBnd, maxIT, betaInit); % how to set the iteration limit? not converge within maxIT
        elseif strcmp(intercptchoice, 'simuopt')
            tmpw = GLM_opt([ones(n, 1),X_scl], y, [0; Nu*ones(d,1)], family);
            betaEst = tmpw(2:end);
            alphavec = tmpw(1)*ones(n, 1);
        elseif strcmp(intercptchoice, 'simuopt2')
            alphavec = intercept*ones(n, 1);
            betaEst = GLM_opt(X_scl, y, [0; Nu*ones(d-1, 1)], family, alphavec);            
        end
    else
        if ~strcmp(intercptchoice, 'simuopt2')
            wts = Lambda;
            [betaEst, alphavec, totNum] = TISP_GLM(X_scl, y, wts, family, thresholdingWay, errBnd, maxIT, betaInit, Nu, intercptchoice, intercept*ones(n, 1), updating, relaxWay, grps);   
        else % if 'simuopt2', no penalty for the first column (intercept)
            wts = Lambda*ones(d, 1); wts(1) = 0; 
            [betaEst, alphavec, totNum] = TISP_GLM(X_scl, y, wts, family, thresholdingWay, errBnd, maxIT, betaInit, [0; Nu*ones(d-1,1)], intercptchoice, intercept*ones(n, 1), updating, relaxWay, grps);   
        end
    end
%     matBetaEsts = [matBetaEsts, betaEst];
%     alphaEsts = [alphaEsts, alphavec(1)];
    if isempty(matBetaEsts)
        matBetaEsts = -ones(numel(betaEst), numel(lambdas));
    end
    matBetaEsts(:,tLambInd) = betaEst;
    alphaEsts(tLambInd) = alphavec(1);

    if sum(betaEst~=0) > nzUBnd
        matBetaEsts(:,lambdas<Lambda) = [];
        alphaEsts(lambdas<Lambda) = [];
        lambdas(lambdas<Lambda) = [];   
        if output, disp('Early termination of the path computation (too many nzs)!'), end
        break; 
    end
        % apply warm starts
        if strcmp(thresholdingWay, 'soft') 
            betaInit = betaEst;
        end
end
if output, figure; plot(lambdas, matBetaEsts); end

%%% Scale back!!
matBetaEsts = matBetaEsts / k0; % alpha: not necessary

if strcmp(intercptchoice, 'simuopt2')
    X = oldX;
    d = d - 1;
    alphaEsts = matBetaEsts(1,:);
    matBetaEsts = matBetaEsts(2:end,:);
end

numBs = size(matBetaEsts,2);
nzPatts = -ones(numBs, size(X, 2));
for indB = 1:numBs
    nzPatts(indB, :) = abs(matBetaEsts(:,indB)) > (1e-4); % no need for back scaling because X and Y are both scaled down by k0
end
nzBs = sum(nzPatts,2);

