function [X, valX, tstX, trnCenters, trnScales] = DataStand(centerX, scaleX, X, valX, tstX)
% Use the parameters obtained from the training data to standardize the
% data (including the validation and the test data) but for the design
% only.
trnCenters = []; trnScales = [];
if centerX == 1 % X should not include the intercept column
    % X-centering, y-centering is not appropriate in GLM (change the distr)
    % Use the same(!) params to center valX and tstX
    trnCenters = mean(X);
    X = X - repmat(trnCenters, size(X, 1), 1);
    if exist('valX', 'var')  & ~isempty(valX)
        valX = valX - repmat(trnCenters, size(valX, 1), 1);
    else
        valX = [];
    end
    if exist('tstX', 'var')  & ~isempty(tstX)
        tstX = tstX - repmat(trnCenters, size(tstX, 1), 1);
    else
        tstX = [];
    end
end
if scaleX == 1 % X should not include the intercept column
    % normalize X to L2-norm sqrt(n)/sqrt(valN)/sqrt(tstN)
        % not using var, but sum/n, n is nec 'cause the sample
        % size for trn, val, tst may be diff.
    % Use the same params to scale val & tst % y-scaling is not appropriate. 
    
    % Col-normalize X
    trnScales = sqrt(sum(X.^2)/size(X, 1));
    X = X .* repmat(1./trnScales, size(X, 1), 1); % X * diag(1./(trnScales));
    if exist('valX', 'var')  & ~isempty(valX)
        valX = valX .* repmat(1./trnScales, size(valX, 1), 1);
    else
        valX = [];
    end
    if exist('tstX', 'var')  & ~isempty(tstX)
        tstX = tstX .* repmat(1./trnScales, size(tstX, 1), 1);
    else
        tstX = [];
    end
end