%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Function for SCV Tuning %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [betaOpt, alphaOpt, betaOptInd, riskEst] = TISPTuning_GLM_wSelCV(nCV, matBetaEsts, alphaEsts, family, dataX, dataY, orik0, ...
        dataIndsCV, dataIndsCVStarts, dataIndsCVEnds, minTh0, DF, thresholdingWay, intercptchoice, Nu, biascorrt, matchLocEst, unpenCorr, output)
% SCV tuning. For each global estimate along the solution path, we fit nCV
% local estimates to match it by its DF. The CV errors are summarized to the vector riskEst.

nzPatts = (matBetaEsts ~= 0);

expTuningParamsCV = cell(nCV, 1);
expBetasCV = cell(nCV, 1);
expTotErr22sCV = cell(nCV, 1);
for indCV = 1:nCV
%     disp(['indCV-', num2str(indCV)]);
    valInds = dataIndsCV( dataIndsCVStarts(indCV):dataIndsCVEnds(indCV) );
    tmpInds = 1:size(dataY, 1); tmpInds(valInds) = [];
    X = dataX(tmpInds, :); y = dataY(tmpInds, :);    

    switch lower(family)
       case {'binomial'}
            k0 = .5*norm(X, 2);
       case 'poisson'
            disp('no universal bound!')
            k0 = max(exp(X* glmfit(X, y, 'poisson', 'constant', 'off')/2)) * norm(X, 2);  
       case 'gaussian'
            k0 = norm(X, 2);  
       otherwise
          error('not implemented yet')
    end  
    X_scl = X ./ k0;

    if strcmp(intercptchoice, 'none') | strcmp(intercptchoice, 'fixedopt')
        corrt = 1; % estimate beta only
        intercept = 0; % even for 'fixedopt' here, we use joint estimation
        
    elseif strcmp(intercptchoice, 'simuopt') | strcmp(intercptchoice, 'simuopt2')
        corrt = 3; % estimate both alpha & beta
        intercept = 0;
    end
    
        
    if ~strcmp(thresholdingWay, 'hybrid') & ~strcmp(thresholdingWay, 'hybrid-prop')
        tmpNu = Nu; %1e-8 %  
        if tmpNu > 1e-8,  error('probably wrong entrance???'), end
        if unpenCorr
            tmpNu = 1e-8;
        end
        
        [betas, alphas] = EstsCorrection(corrt, thresholdingWay, matBetaEsts, alphaEsts, X, X_scl, y, k0, family, tmpNu, intercept);
    else % thresholdingWay = 'hybrid'
        betas = matBetaEsts;
        alphas = alphaEsts;
        for tmpai = 1:size(matBetaEsts, 2)
            tmpNzs = matBetaEsts(:, tmpai)~=0;
            switch lower(matchLocEst)
                case {'df'} % match the degrees of freedom 
                    wts = 0;
                    if numel(Nu) > 1
                        tmpNu = Nu(tmpai)*orik0^2; %better than k0^2 ????????
                    else
                        tmpNu = Nu*orik0^2; %k0^2 %better than k0^2 ????????
                    end
                    [tmpw, tmpnuVal] = GLM_DFInv(X(:, tmpNzs), y, DF(tmpai), family, tmpNu, intercptchoice, wts); 
                    % tmpnuVal/k0^2, % tmpw

                case {'l2'} % match the l2-norm of the slope estimate
                    wts = 0;
                    if numel(Nu) > 1
                        tmpNu = Nu(tmpai)*orik0^2; %better than k0^2 ????????
                    else
                        tmpNu = Nu*orik0^2; %k0^2 %better than k0^2 ????????
                    end
                    [tmpw, tmpnuVal] = GLM_DFInv(X(:, tmpNzs), y, sum(matBetaEsts(:, tmpai).^2), ...
                        family, tmpNu, intercptchoice, wts, 'l2'); 
                    
                case {'naive'} % directly use the penalized parameter
                    if numel(Nu) > 1
                        tmpNu = Nu(tmpai)*orik0^2;
                    else
                        tmpNu = Nu*orik0^2;
                    end
                    if strcmp(intercptchoice, 'none') 
                        tmpw = GLM_opt(X(:, tmpNzs), y, tmpNu, family, intercept);
                    elseif strcmp(intercptchoice, 'simuopt2') 
                        tmpw = GLM_opt([ones(size(X,1), 1),X(:, tmpNzs)], y, ...
                            [0; tmpNu *ones(sum(tmpNzs),1)], family, intercept);
                    end    
                otherwise
                    error('unnknown method to look for specific ests')                
            end
            if strcmp(intercptchoice, 'none')
                betas(tmpNzs, tmpai) = tmpw;
            elseif strcmp(intercptchoice, 'simuopt2')
                betas(tmpNzs, tmpai) = tmpw(2:end);
                alphas(tmpai) = tmpw(1);
            else
                error('Intercetp choice not implemented yet!!')
            end 
        end
    end


    expTotErr22sCV{indCV} = GLM_negLogLik(dataX(valInds,:), dataY(valInds), betas, family, ones(numel(valInds), 1)*alphas);     
    expTuningParamsCV{indCV} = sum(nzPatts);
    expBetasCV{indCV} = betas;    

end

% Calculate the true error curve

%  NO  interploatation!! Because we're CVing the nz-indices
commonTuningParams = sum(nzPatts);
interpTotErr22sCV = zeros(nCV, size(commonTuningParams, 2));
for indCV = 1:nCV 
    interpTotErr22sCV(indCV, :) = expTotErr22sCV{indCV};
end  

% riskEst = mean(interpTotErr22sCV, 1); 

riskEst = sum(interpTotErr22sCV, 1); % if ridge, we use scv-err without correction
if strcmp(biascorrt, 'bic') % if hybrid with lambda ~= 0, use SCV-BIC
    riskEst = riskEst + 1/2*log(size(dataX, 1)).* DF; %+ 1/2* 2 *DF; %;  %
    if strcmp(family, 'gaussian')
        % consider the scale estimate
        riskEst = size(dataX,1)/2*log(riskEst) + 1/2*log(size(dataX,1)).* (DF+1) ; 
    end    
elseif strcmp(biascorrt, 'aic') % if hybrid with lambda ~= 0, use SCV-AIC
    riskEst = riskEst + 1/2*2* DF; %+ 1/2* 2 *DF; %;  %
    if strcmp(family, 'gaussian')
        % consider the scale estimate
        riskEst = size(dataX,1)/2*log(riskEst) + 1/2*2.* (DF+1) ; 
    end    
    
end

if minTh0 < 0
    riskEstStd = std(interpTotErr22sCV);
    minTh = min(riskEstStd(find(riskEst == min(riskEst))))
else
    minTh = minTh0;
end

if output
    figure; plot(commonTuningParams, riskEst, 'r.'); %debugging
    figure; plot(expTuningParamsCV{1}, expTotErr22sCV{1}, expTuningParamsCV{2}, expTotErr22sCV{2}, ...
        expTuningParamsCV{3}, expTotErr22sCV{3}, expTuningParamsCV{4}, expTotErr22sCV{4}, expTuningParamsCV{5}, expTotErr22sCV{5}) %debugging
end

optSet = find( riskEst <= min(riskEst)+minTh );   
betaOptInd = optSet(find(DF(optSet) == min(DF(optSet)), 1, 'first'));  
betaOpt = matBetaEsts(:, betaOptInd); 
alphaOpt = alphaEsts(betaOptInd);

