%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% Path computation (2 -- for hybrid TISP only) %%%%%%%%%%%%%%%%%%%%%%%
% Compute the eta solution-path of the hybrid hard-ridge TISP. 
% We fix the lambda parameter at 'Lambda' and vary the ridge parameter ('Nu'). 

if ~strcmp(thresholdingWay, 'hybrid'), error('Thresholding should be hybrid'), end

if strcmp(intercptchoice, 'simuopt2')
    oldX = X;
    X = [ones(size(X,1),1), X];
    d = d + 1;
end
%%% scaling
switch lower(family)
   case {'binomial'}
        k0 = .5*norm(X, 2);
   case 'poisson'
        sprintf('no universal bound!')
        k0 = max(exp(X* glmfit(X, y, 'poisson', 'constant', 'off')/2)) * norm(X, 2);  
   case 'gaussian'
        k0 = norm(X, 2);  
   otherwise
      error('not implemented yet')
end  
X_scl = X ./ k0;
%%%%%%%%%

%%%%%%%%% initialization %%%%%%%%%%
   
% thresholdingWay = 'soft' %'hard' %'scad' %  'none' %
% family = 'binomial' % 'poisson' % 'gaussian' %
% nPoints = 50; % 200;
% maxIT = 1e+4 %1e+5 %  5e+5
% errBnd = 1e-5 % 1e-7%
betaInit = zeros(d, 1); % b;   

% intercptchoice = 'simuopt' %'fixedopt' % 'none' %  

% if exist('centerX', 'var') && centerX == 1 && strcmp(intercptchoice, 'none'), error('Intercept should be included in the model'), end

if strcmp(intercptchoice, 'none') |  strcmp(intercptchoice, 'simuopt2')
    intercept = 0; %[];
elseif strcmp(intercptchoice, 'simuopt')
    % used in the contruction of the UPPER bound of Lambda
    intercept = 0; %[]; %GLM_canlink(mean(y), family) ; % a better est????
elseif strcmp(intercptchoice, 'fixedopt')
    intercept = GLM_canlink(mean(y), family) ; %  zeros(n, 1); %1; % []; %
end
% % nus=[0,2.^[-15:.2:0]]; % for scaled X!!!
% % nus=[2.^[-14:.2:1]]; % for scaled X!!!
% nus=[2.^[-15:.2:10]]; % for scaled X!!!
nus=[2.^[-12:.25:0]]; % for scaled X!!!
nus=[10.^[-4:1:0]]; % for scaled X!!!
nus = nus(end:-1:1);
alphaEsts = -ones(1,numel(nus));
matBetaEsts = []; 
%%%%%%%% compute the solution path %%%%%
for nuInd = 1:numel(nus) % Nu = nus
    Nu = nus(nuInd); 
    if abs(Lambda) < 1e-6  % == 0 %
%         disp('lambda=0 (maybe approx)')
        if strcmp(intercptchoice, 'none') | strcmp(intercptchoice, 'fixedopt') % with intercept (fixed or 0)
            alphavec = intercept*ones(n, 1);
            betaEst = GLM_opt(X_scl, y, Nu, family, alphavec);
    %         logRegFun(y, X_scl, 1e-8); % only for logistic regression!
    %         betaEst = glmfit(X_scl, y, family, 'constant', 'off'); % might be singular; consider the following l2-pen with lambda really small
    %         betaEst = TISP_GLM(X_scl, y, 1e-8, family, 'ridge', errBnd, maxIT, betaInit); % how to set the iteration limit? usually lambda too small to converge within maxIT
    %         betaEst = TISP_GLM(X_scl, y,    0, family, 'ridge', errBnd, maxIT, betaInit); % how to set the iteration limit? not converge within maxIT
        elseif strcmp(intercptchoice, 'simuopt')
            tmpw = GLM_opt([ones(n, 1),X_scl], y, [0; Nu*ones(d,1)], family);
            betaEst = tmpw(2:end);
            alphavec = tmpw(1)*ones(n, 1);
        elseif strcmp(intercptchoice, 'simuopt2')
            alphavec = intercept*ones(n, 1);
            betaEst = GLM_opt(X_scl, y, [0; Nu*ones(d-1, 1)], family, alphavec);            
        end
    else
        tempTime=clock; %*%
        if ~strcmp(intercptchoice, 'simuopt2')
            [betaEst, alphavec, totNum] = TISP_GLM(X_scl, y, Lambda, family, thresholdingWay, errBnd, maxIT, betaInit, Nu, intercptchoice, intercept*ones(n, 1), updating, relaxWay, grps);   
        else % if 'simuopt2', no penalty for the first column (intercept)
            [betaEst, alphavec, totNum] = TISP_GLM(X_scl, y, [0; Lambda*ones(d-1,1)], family, thresholdingWay, errBnd, maxIT, betaInit, [0; Nu*ones(d-1,1)], intercptchoice, intercept*ones(n, 1), updating, relaxWay, grps);   
        end
        totalTispTime = totalTispTime+etime(clock,tempTime); %*%
    end
    if isempty(matBetaEsts)
        matBetaEsts = -ones(numel(betaEst), numel(nus));
    end
    matBetaEsts(:,nuInd) = betaEst;
    alphaEsts(nuInd) = alphavec(1);
    
%     matBetaEsts = [matBetaEsts, betaEst];
%     alphaEsts = [alphaEsts, alphavec(1)];

%     if sum(betaEst~=0) > nzUBnd
%         nus(nus<Nu) = []; 
%         break; 
%     end
end
if output, figure; plot(nus, matBetaEsts); end

%%% Scale back!!
matBetaEsts = matBetaEsts / k0; % alpha: not necessary

if strcmp(intercptchoice, 'simuopt2')
    X = oldX;
    d = d - 1;
    alphaEsts = matBetaEsts(1,:);
    matBetaEsts = matBetaEsts(2:end,:);
end
