
function [val] = GLM_mean(X, beta, family, alpha)
% Compute the mean vector in GLM
if nargin == 3 | ~exist('alpha', 'var') | isempty(alpha)
    alpha = zeros(size(X, 1), size(beta, 2));
end
switch lower(family)
   case {'binomial'}
      val = 1./(1+exp(-X*beta-alpha));  % better than the following due to INF
%       val = exp(X * beta + alpha) ./ (exp(X * beta + alpha) + 1); 
   case 'poisson'
      val = exp(X * beta + alpha);
   case 'gaussian'
      val = X * beta + alpha;  
   otherwise
      error('not implemented yet')
end