function [cmean] = CentMean(data, low, upp)
% Compute the cented (or trimmed) mean for the given data (column-wise)
if nargin < 3
    low = 0.10;
    upp = 0.90;
end
lBnd = quantile(data, low);
uBnd = quantile(data, upp);
if size(data, 1) == 1
    lBnd = data; uBnd = data;
end
cmean = [];
for i = 1:size(data, 2)
    if sum(lBnd(i) <= data(:,i) & uBnd(i) >= data(:,i)) == 0
        cmean = [cmean, mean( data(:, i) )];
    else
        cmean = [cmean, mean( data(lBnd(i) <= data(:,i) & uBnd(i) >= data(:,i), i) )];
    end
end
