% This Matlab program implements the 3+1 parameter search for the hard-ridge penalty which has two parameters.
% It works well and is more efficient than a full two-dimensional grid search. (Y. She)

if ~strcmp(thresholdingWay, 'hybrid')& ~ strcmp(thresholdingWay, 'hybrid-prop')
    error('Thresholding should be hybrid or hybrid-prop'), end
tmpRes = []; tmpBetas = []; tmpAlphas = [];

if strcmp(hybridTuningWay, '3+1')
% disp('3+1') 
% Get the optimal ridge parameter
    if output>0, disp('....................Ridge regression....................'), end
    Lambda = 0;
    run TISPPathHybrid2_GLM; % fit a series of ridge models (corresponding to lambda=0 in the hard-ridge penalty)
    unpenCorr = false;  
    scvbiascorrt = scvbiascorrt0; % which can be 'aic', 'bic', or [] 
    matchLocEst = matchLocEst0; % which can be 'df', 'naive', or 'l2' 
    run TISPTuningHybrid2_GLM; % use SCV to tune the parameter
    
    ridgeEta = nus(betaOptInd);
    tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; Lambda; nus(betaOptInd); sum(betaOpt~=0)]];
    tmpBetas = [tmpBetas, betaOpt];
    tmpAlphas = [tmpAlphas, alphaOpt];        
    disp(['opt nu: ', num2str(nus(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))])

% Find the optimal lambda
    % first path (1) 
    if output>0, disp('....................1st path: lambda-path (eta=.5*ridgeeta)....................'), end   
    Nu = ridgeEta * .5; % 1e-2; % 

    run TISPPath_GLM; % obtain the solution path in Lambda, with Nu fixed
    unpenCorr = false; 
    scvbiascorrt = scvbiascorrt1; % which can be 'aic', 'bic', or []  
    matchLocEst = matchLocEst1;
    run TISPTuning_GLM; % use SCV to tune the parameter

    tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; lambdas(betaOptInd); Nu; sum(betaOpt~=0)]];
    tmpBetas = [tmpBetas, betaOpt];
    tmpAlphas = [tmpAlphas, alphaOpt];
    if output>0, disp(['opt lamb: ', num2str(lambdas(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))]), end
    
    % second path  
    if ridgeEta ~= 0
        if output>0, disp('....................2nd path: lambda-path (eta=.05*ridgeeta)...................'), end    
        Nu = ridgeEta * .05;

        run TISPPath_GLM; % obtain the solution path in Lambda, with Nu fixed
        unpenCorr = false; 
        scvbiascorrt = scvbiascorrt1;  
        matchLocEst = matchLocEst1;
        run TISPTuning_GLM; % use SCV to tune the parameter

        tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; lambdas(betaOptInd); Nu; sum(betaOpt~=0)]];
        tmpBetas = [tmpBetas, betaOpt];
        tmpAlphas = [tmpAlphas, alphaOpt];
        if output>0, disp(['opt lamb: ', num2str(lambdas(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))]), end
    end
    
    % third path  
    if ridgeEta ~= 0
        if output>0, disp('....................3rd path: lambda-path (eta=.005*ridgeeta)..................'), end    
        Nu = ridgeEta * .005;

        run TISPPath_GLM; % obtain the solution path in Lambda, with Nu fixed
        unpenCorr = false; 
        scvbiascorrt = scvbiascorrt1;   
        matchLocEst = matchLocEst1;
        run TISPTuning_GLM; % use SCV to tune the parameter

        tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; lambdas(betaOptInd); Nu; sum(betaOpt~=0)]];
        tmpBetas = [tmpBetas, betaOpt];
        tmpAlphas = [tmpAlphas, alphaOpt];
        if output>0, disp(['opt lamb: ', num2str(lambdas(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))]), end
    end      

%     optInd = 1 + find(tmpRes(1, 2:end) == min(tmpRes(1, 2:end)), 1, 'first');
%     betaOpt = tmpBetas(:, optInd); alphaOpt = tmpAlphas(optInd);
% 
%     disp(['optInd: ', num2str(optInd), '; ridgeEta: ', num2str(ridgeEta), '; opt eta: ', num2str(tmpRes(4, optInd))])
% % Find the optimal ridge parameter
%     % The last path (type B)
%     if ridgeEta ~= 0
%         disp('....................4th path: eta-path (lambda from opt above).................') 
%         Lambda = tmpRes(3, optInd);
% 
%         run TISPPathHybrid2_GLM; % obtain the solution path in Nu, with Lambda fixed
%         unpenCorr = false; 
%         scvbiascorrt = scvbiascorrt1;   
%         matchLocEst = matchLocEst1;
%         run TISPTuningHybrid2_GLM; % use SCV to tune the parameter
% 
%         tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; Lambda; nus(betaOptInd); sum(betaOpt~=0)]];
%         tmpBetas = [tmpBetas, betaOpt];
%         tmpAlphas = [tmpAlphas, alphaOpt];
%         disp(['opt nu: ', num2str(nus(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))])
%     end

    optInd = 1 + find(tmpRes(1, 2:end) == min(tmpRes(1, 2:end)), 1, 'first'); 
    betaOpt = tmpBetas(:, optInd); alphaOpt = tmpAlphas(optInd);

    if output>0, disp(num2str(tmpRes)), disp(['optInd: ', num2str(optInd), '; ridgeEta: ', num2str(ridgeEta), '; opt eta: ', num2str(tmpRes(4, optInd))]), end
%     betaOpt'
elseif strcmp(hybridTuningWay, 'simple')
% disp('simple') 

% % Get the optimal ridge parameter
%     disp('....................Ridge regression....................')
%     Lambda = 0;
%     run TISPPathHybrid2_GLM; % fit a series of ridge models (corresponding to lambda=0 in the hard-ridge penalty)
%     unpenCorr = false;  
%     scvbiascorrt = scvbiascorrt0; % which can be 'aic', 'bic', or [] 
%     matchLocEst = matchLocEst0; % which can be 'df', 'naive', or 'l2' 
%     run TISPTuningHybrid2_GLM; % use SCV to tune the parameter
%     
%     ridgeEta = nus(betaOptInd);
%     tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; Lambda; nus(betaOptInd); sum(betaOpt~=0)]];
%     tmpBetas = [tmpBetas, betaOpt];
%     tmpAlphas = [tmpAlphas, alphaOpt];        
%     disp(['opt nu: ', num2str(nus(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))])

    ridgeEta = 1e-1;
% Find the optimal lambda
    % first path (1) 
    if output>0, disp('....................1st path: lambda-path (eta=0.01 * ridgeeta)....................'), end
    Nu = ridgeEta * .01; % 

    run TISPPath_GLM; % obtain the solution path in Lambda, with Nu fixed
    unpenCorr = false; 
    scvbiascorrt = scvbiascorrt1; % which can be 'aic', 'bic', or []  
    matchLocEst = matchLocEst1;
    run TISPTuning_GLM; % use SCV to tune the parameter

    tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; lambdas(betaOptInd); Nu; sum(betaOpt~=0)]];
    tmpBetas = [tmpBetas, betaOpt];
    tmpAlphas = [tmpAlphas, alphaOpt];
    if output>0, disp(['opt lamb: ', num2str(lambdas(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))]), end

%     optInd = find(tmpRes(1, 1:end) == min(tmpRes(1, 1:end)), 1, 'first');
    optInd = size(tmpRes, 2);
    
% % Find the optimal ridge parameter
%     % The last path (type B)
%     if ridgeEta ~= 0
%         disp('....................2nd path: eta-path (lambda from opt above).................') 
%         Lambda = tmpRes(3, optInd);
% 
%         run TISPPathHybrid2_GLM; % obtain the solution path in Nu, with Lambda fixed
%         unpenCorr = false; 
%         scvbiascorrt = scvbiascorrt1;   
%         matchLocEst = matchLocEst1;
%         run TISPTuningHybrid2_GLM; % use SCV to tune the parameter
% 
%         tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; Lambda; nus(betaOptInd); sum(betaOpt~=0)]];
%         tmpBetas = [tmpBetas, betaOpt];
%         tmpAlphas = [tmpAlphas, alphaOpt];
%         disp(['opt nu: ', num2str(nus(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))])
%     end
% 
%     optInd = 1 + find(tmpRes(1, 2:end) == min(tmpRes(1, 2:end)), 1, 'first'); 
% %     optInd = size(tmpRes, 2);

    betaOpt = tmpBetas(:, optInd); alphaOpt = tmpAlphas(optInd);

%     disp(num2str(tmpRes))
    if output>0, disp(['optInd: ', num2str(optInd), '; ridgeEta: ', num2str(ridgeEta), '; opt eta: ', num2str(tmpRes(4, optInd))]), end
%     betaOpt'
      
elseif strcmp(hybridTuningWay, 'x+1') % Run an adpative grid for eta (usually larger than the above '3+1'
disp('x+1') 
    % 0-th run (ridge)
    disp('....................Ridge path....................')
    Lambda = 0;
    run TISPPathHybrid2_GLM;
    unpenCorr = false; %true %   
    scvbiascorrt = scvbiascorrt0;  
    matchLocEst = matchLocEst0; 
    run TISPTuningHybrid2_GLM;
    
    ridgeEta = nus(betaOptInd);

    tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; Lambda; nus(betaOptInd); sum(betaOpt~=0)]];
    tmpBetas = [tmpBetas, betaOpt];
    tmpAlphas = [tmpAlphas, alphaOpt];        
    disp(['opt nu: ', num2str(nus(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))])

    % first run (1) 
    disp('....................1st path: lambda-path (eta=.5*ridgeeta)....................')    
    Nu = ridgeEta * .5;

    run TISPPath_GLM;
    unpenCorr = false; 
    scvbiascorrt = scvbiascorrt1;  
    matchLocEst = matchLocEst1; 
    run TISPTuning_GLM;

    tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; lambdas(betaOptInd); Nu; sum(betaOpt~=0)]];
    tmpBetas = [tmpBetas, betaOpt];
    tmpAlphas = [tmpAlphas, alphaOpt];
    disp(['opt lamb: ', num2str(lambdas(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))])
    
        
    % Additional runs  
    if ridgeEta ~= 0
        factor = 0.5/10;
        while 1
            disp(['....................x: lambda-path (eta=', num2str(factor), '*ridgeeta).........................'])                
            Nu = ridgeEta * factor;

            run TISPPath_GLM;
            unpenCorr = false;  
            scvbiascorrt = scvbiascorrt1; 
            matchLocEst = matchLocEst1; 
            run TISPTuning_GLM;

            tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; lambdas(betaOptInd); Nu; sum(betaOpt~=0)]];
            tmpBetas = [tmpBetas, betaOpt];
            tmpAlphas = [tmpAlphas, alphaOpt];
            disp(['opt lamb: ', num2str(lambdas(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))])
            if tmpRes(1, end) > tmpRes(1, end-1) || abs(tmpRes(1, end) - tmpRes(1, end-1))/max(1, tmpRes(1, end-1)) < 0.05
                break;
            else
                factor = factor /10;
            end
        end

    end
    
    
    optInd = 1 + find(tmpRes(1, 2:end) == min(tmpRes(1, 2:end)), 1, 'first'); %find(tmpRes(1,:) == min(tmpRes(1,:)), 1, 'first');
    betaOpt = tmpBetas(:, optInd); alphaOpt = tmpAlphas(optInd);
    disp(['optInd: ', num2str(optInd), '; ridgeEta: ', num2str(ridgeEta), '; opt eta: ', num2str(tmpRes(4, optInd))])

    % The last run (type B)
    if ridgeEta ~= 0
        disp('....................Last path: eta-path (lambda from opt above).................') 
        Lambda = tmpRes(3, optInd);

        run TISPPathHybrid2_GLM;
        unpenCorr = false; %true % 
        scvbiascorrt = scvbiascorrt1;  
        matchLocEst = matchLocEst1; 
        run TISPTuningHybrid2_GLM;

        tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; Lambda; nus(betaOptInd); sum(betaOpt~=0)]];
        tmpBetas = [tmpBetas, betaOpt];
        tmpAlphas = [tmpAlphas, alphaOpt];
        disp(['opt nu: ', num2str(nus(betaOptInd)), ', # of nonzeros: ', num2str(sum(betaOpt~=0))])
    end
    optInd = 1 + find(tmpRes(1, 2:end) == min(tmpRes(1, 2:end)), 1, 'first'); %find(tmpRes(1,:) == min(tmpRes(1,:)), 1, 'first');
    betaOpt = tmpBetas(:, optInd); alphaOpt = tmpAlphas(optInd);

    disp(num2str(tmpRes)), disp(['optInd: ', num2str(optInd), '; ridgeEta: ', num2str(ridgeEta)])
%     betaOpt'

else
    error('Unknown tuning')
end