function [DF] = hybridTISP_DF(X, y, betaEst, Lambda, family)
% Compute the degrees of freedom of an l2-penalized estimate for a GLM.
% The ridge parameter here is Lambda.
[n, d] = size(X);
if numel(Lambda) == 1
    Lambda = Lambda * ones(d, 1);
else
    Lambda = reshape(Lambda, d, 1);
end
mu = GLM_mean(X, betaEst, family, 0); 
switch lower(family)
   case {'binomial'}
      A = diag(mu.*(1-mu));
   case 'poisson'
      A = diag(mu);
   case 'gaussian'
      A = eye(size(mu, 1));
   otherwise
      error('not implemented yet')
end

C1 = X' * A * X;
B = C1 + diag(Lambda);

if max(abs((Lambda))) < 1e-9
    DF = size(X, 2);
else
    warning off;
    DF = trace(B \ C1);
    warning on;
end