%%%%%%%%%%%%%%%%%%%%%%% Proportional TISP screening %%%%%%%%%%%%%%%%%%%%%
% Implement proportional hybrid hard-ridge TISP screening

if ~strcmp(thresholdingWay, 'hybrid'), error('Thresholding should be hybrid'), end

tmpRes = []; tmpBetas = []; tmpAlphas = [];

screeningPaths = 1 %0 % 
if screeningPaths == 0
    
    % 0-th run (ridge)
    disp('+++++++++++++++Ridge path+++++++++++++++++++')
    Lambda = 0;
    run TISPPathHybrid2_GLM;
    unpenCorr = false %true %   
    scvbiascorrt = [];
    matchLocEst = 'naive' %'l2' %'df' %  
    run TISPTuningHybrid2_GLM;
    ridgeEta = nus(betaOptInd)

    % first run (1) 
    disp('++++++++++++++++++lambda-path (eta=.5*ridgeeta)++++++++++++++++++++++')    
    [alphaOpt, betaOpt, X_scl, Nu, k0, intercept] = HybridTISP_SingleRun(X, y, family, nzExpected, ridgeEta * .5, 'hybrid-prop', 1e-5, 1e+4, ...
         'simuopt2', 'synchronous', 1, grps);
    matBetaEsts = betaOpt;
    alphaEsts = alphaOpt;

    unpenCorr = false %true % 
    scvbiascorrt = []; % 'bic';% 
    matchLocEst = 'df'
    run TISPTuning_GLM; % lambdas not defined

    tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; nzExpected; Nu; sum(betaOpt~=0)]]
    tmpBetas = [tmpBetas, betaOpt];
    tmpAlphas = [tmpAlphas, alphaOpt];
    disp(['# of nonzeros: ', num2str(sum(betaOpt~=0))])

    % second run  
    if ridgeEta ~= 0
        disp('+++++++++++++++++++++2nd path: lambda-path (eta=.05*ridgeeta)+++++++++++++++++++++++')    
        [alphaOpt, betaOpt, X_scl, Nu, k0, intercept] = HybridTISP_SingleRun(X, y, family, nzExpected, ridgeEta * .05, 'hybrid-prop', 1e-5, 1e+4, ...
             'simuopt2', 'synchronous', 1, grps);
        matBetaEsts = betaOpt;
        alphaEsts = alphaOpt;

        unpenCorr = false %true % 
        scvbiascorrt = []; % 'bic';% 
        matchLocEst = 'df'
        run TISPTuning_GLM; % lambdas not defined
        tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; nzExpected; Nu; sum(betaOpt~=0)]]
        tmpBetas = [tmpBetas, betaOpt];
        tmpAlphas = [tmpAlphas, alphaOpt];
        disp(['# of nonzeros: ', num2str(sum(betaOpt~=0))])

        % third run  
        disp('++++++++++++++++++++3rd path: lambda-path (eta=.005*ridgeeta)++++++++++++++++++++++++++')    
        [alphaOpt, betaOpt, X_scl, Nu, k0, intercept] = HybridTISP_SingleRun(X, y, family, nzExpected, ridgeEta * .005, 'hybrid-prop', 1e-5, 1e+4, ...
             'simuopt2', 'synchronous', 1, grps);
        matBetaEsts = betaOpt;
        alphaEsts = alphaOpt;

        unpenCorr = false %true % 
        scvbiascorrt = []; % 'bic';% 
        matchLocEst = 'df'
        run TISPTuning_GLM; % lambdas not defined
        tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; nzExpected; Nu; sum(betaOpt~=0)]]
        tmpBetas = [tmpBetas, betaOpt];
        tmpAlphas = [tmpAlphas, alphaOpt];
        disp(['# of nonzeros: ', num2str(sum(betaOpt~=0))])    
    end
else %screeningPaths == 1
    
    ridgeEta = 1; % guessed value, subjecto to change in applications
    etaRatios =  1e-2; %10.^[-3:-1]; %10.^[-5:0]; %10.^[-6:0]; %  
    for scrPathInd = 1:size(etaRatios,2)

        disp(['++++++++++++++++++++ lambda-path-', num2str(scrPathInd), ',eta=', num2str(etaRatios(scrPathInd)), ' ++++++++++++++++++++++++++'])    
%         [alphaOpt, betaOpt, X_scl, Nu, k0, intercept] = HybridTISP_SingleRun(X, y, family, nzExpected, ridgeEta * etaRatios(scrPathInd), 'hybrid-prop', 1e-5, 1e+4, ...
%              'simuopt2', 'synchronous', 1, grps);
        [alphaOpt, betaOpt, X_scl, Nu, k0, intercept] = HybridTISP_SingleRun(X, y, family, nzExpected, ridgeEta * etaRatios(scrPathInd), 'hybrid-prop', errBnd, maxIT, ...
             intercptchoice, 'synchronous', 1, grps);
        
        matBetaEsts = betaOpt;
        alphaEsts = alphaOpt;

        unpenCorr = false; %true % 
        scvbiascorrt = 'aic'; %[]; % 'bic';% 
        matchLocEst = 'naive'; % 'df';
        run TISPTuning_GLM; % lambdas not defined
        tmpRes = [tmpRes, [riskEst(betaOptInd); modelErr; nzExpected; Nu; sum(betaOpt~=0); sum(log(find(betaOpt~=0)))]];
        tmpBetas = [tmpBetas, betaOpt];
        tmpAlphas = [tmpAlphas, alphaOpt];
        disp(['# of nonzeros: ', num2str(sum(betaOpt~=0))])
        if scrPathInd>= 3 && (tmpRes(1,end) > 1.2 * tmpRes(1,end-1) && tmpRes(1,end-1) > 1.2* tmpRes(1, end-2))
            break;
        end
    end
end
    

optInd = 0 + find(tmpRes(1, 1:end) == min(tmpRes(1, 1:end)), 1, 'first'); %find(tmpRes(1,:) == min(tmpRes(1,:)), 1, 'first');
betaOpt = tmpBetas(:, optInd); alphaOpt = tmpAlphas(optInd);

disp(num2str(tmpRes)), disp(['optInd: ', num2str(optInd), '; # of nonzeros: ', num2str(sum(betaOpt~=0))])

predScreened = find(betaOpt~=0);
