function [alphaOpt, betaOpt, scales, optTuningParams, otherParams, lastSolPath] = Func_HardRidgeGLM_tuned(X, y, family, standData, ...
    intercptchoice, updating, relaxWay,  errBnd, maxIT, nPoints, nzUBnd, grps, ...
    screening, nzExpected, nCV, scvbiascorrt_ref)            
% This Matlab function fits the hard-ridge penalized model with 
%   selective cross-validation tuning (SCV). 
%%%%% Parameters: %%%%%
%   X: design matrix
%   y: response vector
%   family: distribution family of y // 'binomial' or 'gaussian'
%   standData: standardize the predictors or not. 0: no operations; 1:
%      center and scale each column of X to have mean 0 and var 1. Note
%      that y is not changed because of the glm distribution ('binomial')
%   intercptchoice: 'simuopt2' or 'simuopt': simultaneously estimate the 
%       intercept and slope params, 'simuopt2' faster; 'none': assume no
%       intercept available; 'fixedopt': use the mean of y as the (fixed)
%       intercept estimate, not simulanously estimated jointly with the
%       slope.
%   updating: 'synchronous'; 'coordes'  'asynchronous'. If not gaussian,
%     recommend 'synchronous'.
%   relaxWay: use relaxation or not. 0, 1, 2. Recomend 1. 
%   errBnd: termination criterion based on error. 
%   maxIT: termination criteroin based on maximum iteration number allowed
%   nPoints: In computing the lambda solution path (ridge parameter fixed
%       at some value), nPoints determine the grid size for lambda. 
%   nzUBnd: In computing the lambda solution path, nzUBnd can terminate the
%       computation earlier (i.e., stop decreasing lambda) if the number of
%       nonzero coefficients is greater than nzUBnd * sample size. Under
%       the sparsity assumption, we can probably safely assume nzUnbd=0.5.
%   grps: how predictors are grouped. []: none. 
%   screening: perform screening before fitting the hard-ridge penalized 
%       GLM. 'tisp': quantile TISP screening based on L0+L2. Others:
%       'none', 't-test'. 
%   nzExpected: the ratio of the after-screening dimension to the sample
%       size. Typically nzExpected < 1. nzExpected*samplesize gives the 
%       upper bound of the number of truly relevant predictors (support) of
%       the model. (Independent of the grouping status)
%%%	The following params are used for SCV: nCV, scvbiascorrt_ref
%   nCV: fold value in CV. Usually nCV=5.
%   scvbiascorrt_ref: the scv bias correction for the tuning paths
%       'bic': add a BIC correction term to the SCV errors, 'aic': add an
%       AIC correction term to the SCV errors, []: add no correction.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1. Preprecossing - standardize the data
    dataX = X; dataY = y;
    
%     tstDataAvail = false;   
   
    % Standardize data. (No operations for Y, because it may not be gaussian)
    if standData == 1 % we must have size(dataX, 2) == size(predDataX, 2)
        % Center dataX
        centers = mean(dataX);
        dataX = dataX - repmat(centers, size(dataX, 1), 1);
        % Col-normalize dataX
        scales = sqrt(sum(dataX.^2)/(size(dataX, 1)-1));
        dataX = dataX ./ repmat(scales, size(dataX, 1), 1); % or dataX * diag(1./(scales)); 
    end
    X = dataX; y = dataY; 

    [n ,d] = size(X);
    
% 2. Specify some other parameters

    thresholdingWay = 'hybrid' %'scad' %'soft' %'hard' %    'none' %
    hybridTuningWay = '3+1'; % how to search for the opt params
    
    tuningMethod = 'selCV' %'BICm' %'validation' %'BIC' %  
    %%%% The following params are used for SCV  
        % Specify the bias correction to the SCV
        scvbiascorrt0 = scvbiascorrt_ref; % the scv bias correction for the ridge path
        scvbiascorrt1 = scvbiascorrt_ref; % the scv bias correction for the tuning paths
                % 'bic': add a BIC correction term to the SCV errors, 'aic': add an
                % AIC correction term to the SCV errors, []: add no correction.

        % Specify how to find the appropriate eta's in scv trainings (to match the global eta)
        % Ideally all should use 'df'. But for convex penalties which result in
        % continous solution paths, naively using the penalty parameter in all CV
        % trainings are OK (more efficient than 'df')
        matchLocEst0 = 'naive'; % how to find the appropriate eta's in cv, for the ridge path. 'df' is more reasonable, but 'naive' is faster and ok
        matchLocEst1 = 'df';   % how to find the appropriate eta's in cv, for the tuning paths. 'df' is more reasonable.     
    %%%
    unpenCorr = false; % true %   
    output = false; %true; %  

%     nCV = 5; %10 %20 % round( size(X, 1)/1 )%5; % LOOCV
    minTh0 = 0;
    [nCV, dataIndsCV, dataIndsCVStarts, dataIndsCVEnds] = CVSplit(size(X, 1), nCV); % make sure it runs only ONCE when fitting the path using both more than 1 paths.
    disp(nCV)
    
    nzExpected = nzExpected * n % Upper bound for # of nzs. Used only in the screening stage. (Independent of the grouping status)
    nzUBnd = nzUBnd * n; % Solution path computing truncation. If there are more than nzUBnd zeros, stop computation.
                         % Used in the lambda-path computation. 
    if nzExpected > d
        screening = 'none'
    end

%     scvbiascorrt0 = scvbiascorrtRef; % the scv bias correction for the ridge path
%     scvbiascorrt1 = scvbiascorrtRef; % the scv bias correction for the tuning paths
%     matchLocEst0 = matchLocEstRef;   % how to find the appropriate eta's in cv, for the ridge path
%     matchLocEst1 = matchLocEstRef;   % how to find the appropriate eta's in cv, for the tuning paths     

% 3. Screening
    if ~strcmp(screening, 'none') 
        disp('==================== Screening stage starts ============================')
        
        if strcmp(screening, 'tisp')
        % %%%%%%%%%%%%%
            run TISPScreening_PHTISP;
        % %%%%%%%%%%%%%
        elseif strcmp(screening, 't-test')
            [h,p,ci,stats] = ttest2(X(y==0, :),X(y==1, :));
            quan = 1 - nzExpected / d;
            quan(quan < 0) =0; 
            thval = quantile(abs(stats.tstat), quan); % Lambda of the components of beta are nonzeros                    
            thval(quan==0) = 0;
            predScreened = find(abs(stats.tstat)>thval)';

        elseif strcmp(screening, 'read')
            pvalsTrnFromR = dlmread([pathinit, 'pvalsTrnFromR_', num2str(dataInd), '.txt'], ' '); 
            quan = 1 - nzExpected / d;
            quan(quan < 0) =0; 
            thval = quantile(1 - pvalsTrnFromR, quan); % Lambda of the components of beta are nonzeros                    
            thval(quan==0) = 0;
            predScreened = find((1 - pvalsTrnFromR)>thval);

        end
        oriX = X; 

        X = X(:,predScreened); 
        if exist('grps', 'var') && ~isempty(grps) % We need to re-index the grp numbers
            oriGrps = grps;
            grps = grps(predScreened);
            screened_uniq_grps = unique(grps);
            tgrps = zeros(size(grps));
            for tgrpind = 1:numel(screened_uniq_grps)
                tgrps(grps ==  screened_uniq_grps(tgrpind)) = tgrpind;
            end
            grps = tgrps;
        end
        d = size(X, 2);
    end
% 4. Model fitting
    disp('==================== Fitting stage starts ==============================')
          
    % %%%%%%%%%%%%%
    % tuningMethod = 'validation' %'BICm' %  'BIC' %
    run hybridTISP_Tuned;
    % %%%%%%%%%%%%%

    if ~strcmp(screening, 'none') 
        X = oriX; 
        if exist('grps', 'var') && ~isempty(grps), grps = oriGrps; end
        d = size(X, 2);
        betaOpt0 = betaOpt; 
        betaOpt = zeros(d, 1); betaOpt(predScreened) = betaOpt0;
    end

    if standData == 1
        betaOpt = betaOpt ./ scales';
    end

% 5. Summarize some results    
    lastSolPath = matBetaEsts;
    optTuningParams = struct('Lambda',  tmpRes(3, optInd), 'Nu', tmpRes(4, optInd));
    otherParams = struct(...
        'thresholdingWay', thresholdingWay, 'hybridTuningWay', hybridTuningWay, ...
        'tuningMethod', tuningMethod, 'nCV', nCV, 'unpenCorr', unpenCorr, ...
        'scvbiascorrt0', scvbiascorrt0, 'matchLocEst0', matchLocEst0,...
        'scvbiascorrt1', scvbiascorrt1, 'matchLocEst1', matchLocEst1,...
        'nzExpected', nzExpected);
    