% Voiced frame extraction from a speech signal
% Take three input parameters: 
% 1. the sampled data of a speech signal 
% 2. Sampling rate of the speech signal
% 3. number of bits per sample used to encode the data
% return the indices of all voiced frames

function seg=utter(y,Fs,nbits)

t=length(y);
fl=floor(Fs/1000*30);
ws=round(Fs/1000*10);
p = floor((t-fl)/ws);
z=zeros(1,p);

%%%%%%%%%%%% energy%%%%%%%%%%%
dS = 0.99* 2^(nbits-1)/max(y);
for m=1:p
    g=y((m-1)*ws+1:(m-1)*ws+fl);
    z(m) = sum(g.^2);
    
    
    for k=1:fl
    if g(k)>dS
        z(m) = 0;
    break
    end
    end
end

[s,IX]=sort(z,'descend');

thre = floor(p/4);
index2 = find(z>z(IX(thre)));


%%%%%%%%%%%%%%%% zero crossing rate
zcr=zeros(1,length(index2));
l=1;
for m=index2
    g=y((m-1)*ws+1:(m-1)*ws+fl);
    for n=1:fl-1
        if g(n)*g(n+1)<0
    zcr(l) = zcr(l) + 1;
        end
    end
    l=l+1;
end

[s1,IX1]=sort(zcr,'ascend');
thre1 = floor(p/6);
index1 = find(zcr<zcr(IX1(thre1)));

% return the indices of voiced frames
seg = index2(index1);
