/* -*- c-basic-offset: 4; indent-tabs-mode: nil -*- */
 /*
  * Copyright (c) 2008 Beyond Access, Inc.  All rights reserved.
  * 
  * Redistribution and use in source and binary forms, with or without
  * modification, are permitted provided that the following conditions
  * are met:
  * 
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer. 
  * 
  * 2. Redistributions in binary form must reproduce the above copyright
  *    notice, this list of conditions and the following disclaimer in
  *    the documentation and/or other materials provided with the
  *    distribution.
  * 
  * THIS SOFTWARE IS PROVIDED BY BEYOND ACCESS, INC. ``AS IS'' AND ANY
  * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL BEYOND ACCESS, INC.  NOR
  * ITS EMPLOYEES BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
  * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  */
 
 #ifndef __YIN_H__
 #define __YIN_H__
 
 #ifdef __cplusplus
 extern "C"
 #endif
 #if 0
 } /* Fool Emacs. */
 #endif
 
 #include "prim_type.h"
 
 typedef struct yin_s yin_t;
 
 yin_t *yin_init(int frame_size, float search_threshold,
                 float search_range, int smooth_window);
 
 void yin_free(yin_t *pe);
 
 void yin_start(yin_t *pe);

 void yin_end(yin_t *pe);
 
 void yin_write(yin_t *pe, int16 const *frame);
 
 int yin_read(yin_t *pe, uint16 *out_period, uint16 *out_bestdiff);
 
 #ifdef __cplusplus
 //}
 #endif
 
 #endif /* __YIN_H__ */
 
