 /* -*- c-basic-offset: 4; indent-tabs-mode: nil -*- */
/* ====================================================================
  * Copyright (c) 1999-2004 Carnegie Mellon University.  All rights
  * reserved.
  *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
  *
  * 1. Redistributions of source code must retain the above copyright
  *    notice, this list of conditions and the following disclaimer. 
 *
  * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
  *    the documentation and/or other materials provided with the
  *    distribution.
  *
 * This work was supported in part by funding from the Defense Advanced 
  * Research Projects Agency and the National Science Foundation of the 
  * United States of America, and the CMU Sphinx Speech Consortium.
  *
 * THIS SOFTWARE IS PROVIDED BY CARNEGIE MELLON UNIVERSITY ``AS IS'' AND 
  * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
  * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY
  * NOR ITS EMPLOYEES BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
  * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
  * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
  * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  * ====================================================================
  *
 */
 /*
 * ckd_alloc.h -- Memory allocation package.
  *
  * **********************************************
  * CMU ARPA Speech Project
  *
  * Copyright (c) 1999 Carnegie Mellon University.
  * ALL RIGHTS RESERVED.
  * **********************************************
  * 
  * HISTORY
  * $Log: ckd_alloc.h,v $
  * Revision 1.10  2005/06/22 02:59:25  arthchan2003
  * Added  keyword
  *
  * Revision 1.3  2005/03/30 01:22:48  archan
  * Fixed mistakes in last updates. Add
  *
  * 
  * 19-Jun-97    M K Ravishankar (rkm@cs.cmu.edu) at Carnegie Mellon University
  *              Removed file,line arguments from free functions.
 * 
 * 01-Jan-96    M K Ravishankar (rkm@cs.cmu.edu) at Carnegie Mellon University
  *              Created.
  */
 
 
 /*********************************************************************
  *
  * $Header: /cvsroot/cmusphinx/sphinx3/src/libutil/ckd_alloc.h,v 1.10 2005/06/22 02:59:25 arthchan2003 Exp $
  *
  * Carnegie Mellon ARPA Speech Group
 *
 * Copyright (c) 1994 Carnegie Mellon University.
  * All rights reserved.
  *
  *********************************************************************
 *
  * file: ckd_alloc.h
  * 
  * traceability: 
  * 
  * description: 
 * 
  * author: 
  * 
  *********************************************************************/

 #ifndef _LIBUTIL_CKD_ALLOC_H_
 #define _LIBUTIL_CKD_ALLOC_H_
 
 #include <stdlib.h>
 #include <setjmp.h>
 
 /* Win32/WinCE DLL gunk */
 #include "sphinxbase_export.h"
 #include "prim_type.h"
 
 #ifdef __cplusplus
 extern "C" {
 #endif
#if 0
 /* Fool Emacs. */
 }
 #endif
 
 jmp_buf *ckd_set_jump(jmp_buf *env, int abort);
 
 void ckd_fail(char *format, ...);
 
 /*
  * The following functions are similar to the malloc family, except
 * that they have two additional parameters, caller_file and
  * caller_line, for error reporting.  All functions print a diagnostic
  * message if any error occurs, with any other behaviour determined by
  * ckd_set_jump(), above.
  */

 SPHINXBASE_EXPORT
void *__ckd_calloc__(size_t n_elem, size_t elem_size,
                     const char *caller_file, int caller_line);
 
 SPHINXBASE_EXPORT
 void *__ckd_malloc__(size_t size,
                      const char *caller_file, int caller_line);
 
 SPHINXBASE_EXPORT
 void *__ckd_realloc__(void *ptr, size_t new_size,
                     const char *caller_file, int caller_line);

 SPHINXBASE_EXPORT
 char *__ckd_salloc__(const char *origstr,
                     const char *caller_file, int caller_line);
 
 SPHINXBASE_EXPORT
void *__ckd_calloc_2d__(size_t d1, size_t d2,   /* In: #elements in the 2 dimensions */
                        size_t elemsize,        /* In: Size (#bytes) of each element */
                        const char *caller_file, int caller_line);      /* In */

 SPHINXBASE_EXPORT
 void *__ckd_calloc_3d__(size_t d1, size_t d2, size_t d3,        /* In: #elems in the dims */
                         size_t elemsize,                /* In: Size (#bytes) per element */
                        const char *caller_file, int caller_line);      /* In */

SPHINXBASE_EXPORT
void * __ckd_alloc_3d_ptr(size_t d1,
                          size_t d2,
                         size_t d3,
                         void *store,
                          size_t elem_size,
                        char *caller_file,
                          int caller_line);

 SPHINXBASE_EXPORT
 void *__ckd_alloc_2d_ptr(size_t d1,
                          size_t d2,
                         void *store,
                        size_t elem_size,
                         char *caller_file,
                         int caller_line);

 SPHINXBASE_EXPORT
 void ckd_free(void *ptr);
 
 SPHINXBASE_EXPORT
 void ckd_free_2d(void *ptr);

 
 SPHINXBASE_EXPORT
 void ckd_free_3d(void *ptr);
 
 #define ckd_calloc(n,sz)        __ckd_calloc__((n),(sz),__FILE__,__LINE__)
 
 #define ckd_malloc(sz)          __ckd_malloc__((sz),__FILE__,__LINE__)
 
 #define ckd_realloc(ptr,sz)     __ckd_realloc__(ptr,(sz),__FILE__,__LINE__)
 
 #define ckd_salloc(ptr)         __ckd_salloc__(ptr,__FILE__,__LINE__)
 
 #define ckd_calloc_2d(d1,d2,sz) __ckd_calloc_2d__((d1),(d2),(sz),__FILE__,__LINE__)
 
 #define ckd_calloc_3d(d1,d2,d3,sz) __ckd_calloc_3d__((d1),(d2),(d3),(sz),__FILE__,__LINE__)
 
 #define ckd_alloc_2d_ptr(d1, d2, bf, sz)    __ckd_alloc_2d_ptr((d1), (d2), (bf), (sz), __FILE__, __LINE__)
 
 #define ckd_free_2d_ptr(bf) ckd_free(bf)

 #define ckd_alloc_3d_ptr(d1, d2, d3, bf, sz) __ckd_alloc_3d_ptr((d1), (d2), (d3), (bf), (sz), __FILE__, __LINE__)
 
 #define ckd_free_3d_ptr(bf) ckd_free_2d(bf)
 
 #ifdef __cplusplus
 }
 #endif
 
#endif

