
#include "VE_ZCR.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;
class EnerCom
{
public:
	int fid;
	double fene;
	EnerCom() : fid(0), fene(0) {}
	EnerCom(int id, double ene) : fid(id), fene(ene) {}
protected:
private:
};

bool operator==(const EnerCom& x, const EnerCom& y)
{
	return x.fene == y.fene;
}
bool operator<(const EnerCom& x, const EnerCom& y)
{
	return x.fene < y.fene;
}

EnerCom x;

typedef vector<EnerCom> MYENERGY;

class ZcrCom
{
public:
	int vid;
	int vzcr;
	ZcrCom() : vid(0), vzcr(0) {}
	ZcrCom(int ide, int zcrv) : vid(ide), vzcr(zcrv) {}
protected:
private:
};

bool operator==(const ZcrCom& u, const ZcrCom& v)
{
	return u.vzcr == v.vzcr;
}
bool operator<(const ZcrCom& u, const ZcrCom& v)
{
	return u.vzcr < v.vzcr;
}

ZcrCom u;

typedef vector<ZcrCom> MYZCR;

int * VowelExt_ZCR(short *Data,unsigned int bps,int fl,int wl,int nFrame,int nS,int VowelFrame)
{
	MYENERGY theVector;
	MYENERGY::iterator theIterator;
	MYZCR theVector1;
	MYZCR::iterator theIterator1;
double *Eneg=new double[nFrame];
int EnerFrame=int(nFrame*0.45);

int *Zcr=new int[EnerFrame];
double *Da = new double[nS];
double Thresh = pow(double(2),double(bps));
for (int k=0;k<nFrame;k++)
{
Eneg[k]=0;
}

for (int k=0;k<EnerFrame;k++)
{
Zcr[k]=0;
}

double maxData = 0;
	for (int i=0; i<nS; i++)
	{
	
		double tem = abs(Data[i]);
		if ( tem > maxData)
		{
			maxData = tem;
		}
	}
	
	double NormConst = 0.97/maxData;
	Thresh = Thresh*NormConst*0.99;

	for (int i=0; i<nS; i++)
	{
		//normalize the data according to the maximum
		Da[i] = Data[i]*NormConst;
		
	}

for (int k=0;k<nFrame;k++)
{
	for (int i=0;i<fl;i++)
	{
		if(Da[k*wl+i]>Thresh)
		{
		Eneg[k] = 0;
		break;
		}
		else
		{
Eneg[k]+=pow(Da[k*wl+i],double(2));
	}
	}
	theVector.push_back(EnerCom(k,Eneg[k]));
}


stable_sort(theVector.begin(), theVector.end());	
			theIterator = theVector.end();	
			if (theVector.size() == 0)
				{
					cout<<"The utterrance is too short that no vowel frame can be extracted"<<endl;
				exit(-1);
				}

			if (theVector.size() > 0)
			{
				theIterator--;
			}
			
			int * Enerid = new int[EnerFrame];
			for (int m=0;m<EnerFrame;m++)
			{
						Enerid[m]=theIterator-> fid;
						theIterator--;
					}

/****************ZCR calculation added by 05/26/11******************/
		for (int k=0;k<EnerFrame;k++)
{
	short *STData = new short [fl];
	short avg = 0;
	for (int i=0;i<fl;i++)
	{
    STData[i] = Data[Enerid[k]*wl+i];
	avg = avg + STData[i];
}
avg = avg/fl;
for (int i=0;i<fl;i++)
	{
    STData[i] = STData[i] - avg;
}

for (int i=0;i<fl-1;i++)
	{
	if(STData[i]*STData[i+1]<0)
    Zcr[k]++;
}
theVector1.push_back(ZcrCom(Enerid[k],Zcr[k]));

delete[]STData;

		}


stable_sort(theVector1.begin(), theVector1.end());	
			theIterator1 = theVector1.begin();	
			if (theVector1.size() == 0)
				{
					cout<<"The utterrance is too short that no vowel frame can be extracted"<<endl;
				exit(-1);
				}
		

					int * Vowelid = new int[VowelFrame];
			for (int m=0;m<VowelFrame;m++)
			{
						Vowelid[m]=theIterator1-> vid;
						theIterator1++;
					}
			
			
		

/******************************************************/

			delete[]Eneg;
			delete[]Zcr;
			delete[]Enerid;
				delete[]Da;
			return Vowelid;
}
