%PSNR Feature Extraction of Positive Pulse
% Take two input parameters: 
% 1. directory of speech data 2. directory of feature data
% no return value

function PSNR_Pos(data_dir,fea_dir)

A = dir(data_dir);
 leng = length(A);
 relp = cell(1,leng-2);
 
% LP order determined by sampling rate. 
% 8kHz: 10-12  11.025kHz: 13-15  16kHz: 18-20  20kHz: 22-24  44.1kHz 46-48
p = 14;

for du = 3:leng

til = A(du).name;
pf = dir([data_dir '\' til]);
pf1 = pf(3).name;
wa = [data_dir '\' til '\' pf1];

[y, Fs, nbits] = wavread(wa);

fl=floor(Fs/1000*30);
ws=round(Fs/1000*10);

%%Voiced Frame Extraction 
ind = utter(y,Fs,nbits);

l=1;
for k=ind
 left = 0;
right =0;

%% linear prediction and residual signal extraction
sg = y((k-1)*ws+1:(k-1)*ws+fl);
t=length(sg);
pre_c = xcorr(sg,'biased');
coe = pre_c(t+1)/pre_c(t);
pre_sg=filter([1,-coe],1,sg);
pre_t=length(pre_sg);
 w=hamming(pre_t);
 win_sg=pre_sg.*w;

c = xcorr(win_sg,'biased');
r = c(t:(t+p));
a = levinson(r,p);
e = filter(a,1,sg);
re1 = e(p:end-p+1);

%% PSNR feature extraction
[lk,am]=findpeaks(re1,'',30);
if(length(am)>=3)
[sam ID] = sort(am,'descend');


slk = sort([lk(ID(1)) lk(ID(2)) lk(ID(3))]);

[mslk IDD] = min(diff(slk));

 for nn = slk(IDD)-1:-1:1
     if(re1(nn)<=0.2*re1(slk(IDD)))
         left = nn;
         break
     end
     left = nn;
 end
 
  for nn = slk(IDD+1)-1:-1:slk(IDD)+1
     if(re1(nn)<=0.2*re1(slk(IDD+1)))
         right = nn;
         break
     end
     right = nn;
  end
  
 if ((right-left)>=30)
relp{du-2}(l)  = max(re1(left:right))/sqrt(mean((re1(left:right)).^2));

l=l+1;
 end
end
end

%% store feature estimations
mkdir([fea_dir '\' til]);

fil = ([fea_dir '\' til '\re_fea.txt']);
fid=fopen(fil,'a');

for nnn =1:length(relp{du-2})
fprintf(fid,'%f\n',relp{du-2}(nnn));
end
fclose(fid);

end