// Train.cpp : Defines the entry point for the console application.
//


#include "MFCCTrain.h"
#include "wav_in.h"
#include "wav_out.h"
#include "errno.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "MathLib.h"
#include "gmr.h"

#define NBSTATES 1   // Number of states in the GMM 
#define NBSAMPLES 1  // Number of files used to train the GMM
#define NTRAIN 4000

// The one and only application object

//CWinApp theApp;

using namespace std;

inline void endian_swap(unsigned int& x)
{
	x = (x>>24) | 
		((x<<8) & 0x00FF0000) |
		((x>>8) & 0x0000FF00) |
		(x<<24);
}



/*int GetNumofUtterances(string strDataDir)
{
	//get the total number of speaker in the directory strDir
	//we assume each speaker has his/her files stored in a sub folder in strDir 
	//with the folder name same as his/her name
int nNUtterances=0;
DIR * dir1;
                        struct dirent * ptr1;
                        dir1 = opendir(strDataDir.c_str());
						
						
						while(ptr1 = readdir(dir1)) 
						{
							
							int d_len = strlen(ptr1->d_name);
							
								if(!(strcmp(&(ptr1->d_name[d_len-3]),"w")) && !(strcmp(&(ptr1->d_name[d_len-2]),"a")) && !(strcmp(&(ptr1->d_name[d_len-1]),"v")))
								{
						   
                       nNUtterances++;
							}
						}
					   closedir(dir1);

	return nNUtterances;
}*/

int GetNumofSpeakers(string strDataDir)
{
	//get the total number of speaker in the directory strDir
	//we assume each speaker has his/her files stored in a sub folder in strDir 
	//with the folder name same as his/her name
int nNSpeakers=0;
DIR * dir1;
                        struct dirent * ptr1;
                        dir1 = opendir(strDataDir.c_str());
						while(ptr1 = readdir(dir1)) 
						{
							//if(ptr1->d_type == 4 && (strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
									if((strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
							
							{
								
                       nNSpeakers++;
							}
							
						   
						}
					   closedir(dir1);

	return nNSpeakers;
}

/*void GetNamesAndUttNum(string strDataDir, string * pstrNames, int	 * nUtterances)
{
	//Get name and number of utterances of each speaker
                       DIR * dir1;
                        struct dirent * ptr1;
						int i = 0;
                        dir1 = opendir(strDataDir.c_str());
						
						while(ptr1 = readdir(dir1)) 
						{
							if(ptr1->d_type == 4 && (strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
							{
								
								string pathname = strDataDir + ("//") + ptr1->d_name;
								nUtterances[i] = GetNumofUtterances(pathname);
								
								pstrNames[i++] = ptr1->d_name;
					   }
						}
					   closedir(dir1);
}*/

void GetNames(string strDataDir, string * pstrNames)
{
	//Get name and number of utterances of each speaker
                       DIR * dir1;
                        struct dirent * ptr1;
						int i = 0;
                        dir1 = opendir(strDataDir.c_str());
						
						while(ptr1 = readdir(dir1)) 
						{
							//if(ptr1->d_type == 4 && (strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
								if((strcmp(ptr1->d_name,".")) && (strcmp(ptr1->d_name,"..")))
							{
								
								//string pathname = strDataDir + ("//") + ptr1->d_name;
								//nUtterances[i] = GetNumofUtterances(pathname);
								
								pstrNames[i++] = ptr1->d_name;
					   }
						}
					   closedir(dir1);
}

int MyPreProcess(string strSrcFile, string strDesDir, string strFileTitle, float fNormal, float fThresh, int nCep, int nFRate, float fWLen)
{
	//Pre-Process: normalization, silence mark
	//nCep:	number of MFCCs
	//nFRate:	 frame rate (frames/sec)
	//fWlen:	window length in seconds
	
    	int FILESIZE = strSrcFile.length();
	char * myfn = (char *)malloc((FILESIZE+1)*sizeof(char));
	
	strcpy(myfn,strSrcFile.c_str());

WAV_IN infile(myfn);

free(myfn);
	
	
	
	//char * myfn;
	
	//strcpy(myfn,strSrcFile.c_str());

	
	
	
	double sampleRate = infile.get_sample_rate_hz();
	unsigned int bitsPerSample = infile.get_bits_per_sample();
	unsigned int channels = infile.get_num_channels();
	int nSamples = infile.get_num_samples();

	

	double * pData = new double [nSamples];	//for storing .wav data

	int nWLen = int(fWLen*sampleRate);	//window length in samples
	
	int nFrameShift = int(sampleRate/nFRate+0.5);	//shift between two consecutive frames

	if (channels != 1)
	{
		cout<<"Only support 1 channel wave right now."<<endl;
		exit(-1);
	}

	double maxData = 0;
	for (int i=0; i<nSamples; i++)
	{
		//read data and search for the maximum
		pData[i] = infile.read_current_input();
		double tem = fabs(pData[i]);
		if ( tem > maxData)
		{
			maxData = tem;
		}
	}
	


	if ( infile.more_data_available())
	{
		cout<<"More than nSamples("<<nSamples<<") samples available"<<endl;
	}

	int nFrames = (nSamples - nWLen + 1)/nFrameShift + 1;	//int/int === int (float(int)/int)
	unsigned char * pSilenceMark = new unsigned char [nFrames];

	int myidx = 0;
	double myThresh = fThresh* pow(double(2),double(bitsPerSample-1));
	double dMySaturated = 0.99* pow(double(2),double(bitsPerSample-1));
	int bSaturated = 0;
	
	for (int i=0; i<= nSamples - nWLen; i += nFrameShift, myidx++)
	{
		//calculate the energy of each frame, if it is smaller than fThresh, it is considered silence frame
		//save results in strFilename.mrk file, 1 for silence frame, 0 for speech frame
		//Also, frames with over saturated signals should also be removed.
		double MeanValue = 0;
		bSaturated = 0;
		for (int j=i; j<i+nWLen; j++)
		{
			MeanValue += fabs(pData[j]);
			if (pData[j] > dMySaturated)
			{
				bSaturated = 1;	//contain over saturated signal
			}
		}
		MeanValue /= nWLen;
		if (MeanValue < myThresh || bSaturated == 1)
		{
			pSilenceMark[myidx] = 1;
		}
		else
		{
			pSilenceMark[myidx] = 0;
		}
	}
	delete [] pData;

	FILE *stream;
	int TITLE_SIZE = strFileTitle.length();
		string strFileTitle1 = strFileTitle; 
		strFileTitle1.replace(TITLE_SIZE-3,TITLE_SIZE-1,"mrk");
	string strMarkFile = strDesDir + strFileTitle1;
	

	if((stream = fopen(strMarkFile.c_str(), "w")) != NULL)	//success
	{
		fwrite(pSilenceMark, sizeof(unsigned char), nFrames, stream);
		fclose(stream);
	}

	delete [] pSilenceMark;

	/*WAV_OUT outfile(sampleRate, bitsPerSample, channels);
	
	double NormConst = pow(double(2),double(bitsPerSample-1)) * 0.97/maxData;
	
	//double NormConst = 1;
	for (int i=0; i<nSamples; i++)
	{
		//normalize the data according to the maximum
		pData[i] *= NormConst;
		outfile.write_current_output(pData[i]);
		
	}
	int FILE_SIZE = (strDesDir + strFileTitle).length();
	char * NewFile = (char *)malloc((FILE_SIZE+1)*sizeof(char));
	
	strcpy(NewFile,(strDesDir + strFileTitle).c_str());

	outfile.save_wave_file(NewFile);	//save the normalized wav files


free(NewFile);*/
	


	/************************************************************************/
	/* Calculate MFCC for the given wav file */
	char * strCmd = (char *)malloc(1000*sizeof(char));
	
	
	//int TITLE_SIZE = strFileTitle.length();
		//string strFileTitle1 = strFileTitle; 
		strFileTitle1.replace(TITLE_SIZE-3,TITLE_SIZE-1,"mfc");


	int le = sprintf (strCmd,"./wave2feat -mswav yes -wlen %f -nfilt %d -lowerf %f -upperf %f -nfft %d -srate %f -ncep %d -i %s -o %s", 0.0232, 31, 200.00000, 3500.0000, 256, sampleRate, nCep, strSrcFile.c_str(),(strDesDir+strFileTitle1).c_str());

	if (!system(NULL))
   {
   cout<<"command processor is not available for MFCC Calculation"<<endl;
   exit(1);
   }
    else
	{
   system(strCmd); 
   }
free(strCmd);
	/************************************************************************/

	return 1;
}

int MFCCTrain(string strDataDir, string strProcDir,float Thresh)
{
	int nRetCode = 0;
	int nCep = 13;		//Number of MFCCs
	int nFRate	= 100;	//frame rate, (frames/second)
//	float fWLen	= 0.025625;	//window length (seconds)
	float fWLen	= 0.0232;

	

	// initialize MFC and print and error on failure
	/*if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0))
	{
		// TODO: change error code to suit your needs
		_tprintf(_T("Fatal Error: MFC initialization failed\n"));
		nRetCode = 1;
	}*/
	//else
	//{
		// TODO: code your application's behavior here.
		/*if (argc<3)
		{
			cout<<"Not Enough! Please Input 3 Parameters"<<endl;
			exit(nRetCode);
		}

		string strDataDir(argv[1]);	//directory of raw input wav files
		
		string strProcDir(argv[2]);	//directory of pre-processed wav files and all intermediate files
		float Thresh = (float)atof(argv[3]);*/
		string strFilename;

		/************************************************************************/
		/* Count number of speakers and record their names */
		int nNSpeakers=0;		//used to record number of speakers
		string * pstrNames;		//record names of speakers (name of directory)
		
		//int	 * nUtterances;	//record number of utterances of each speaker
		
		nNSpeakers = GetNumofSpeakers(strDataDir);
		

		pstrNames = new string [nNSpeakers];	//allocate memory for names
		

		//nUtterances = new int [nNSpeakers];	//allocate memory for number of utterances

		GetNames(strDataDir,pstrNames);		
		
		/************************************************************************/

		/************************************************************************/
		/* Read wave files and do preprocessing, save to folder strProcDir*/
		int bDoOnce = 1;
		if (bDoOnce)
		{
			//if (GetFileAttributes(strProcDir) == -1)	//folder does not exist
			
				/*if (mkdir(strProcDir.c_str(),0777))
				{
					if (errno == EEXIST)
					{
						cout<<"Creating directory "<<strProcDir<<" failed! Path already exists!"<<endl;
						exit(-1);
					}
				}*/
				
				for (int i=0; i<nNSpeakers; i++)
				{	//for each training speaker
					
					if (mkdir((strProcDir +  ("//") + pstrNames[i]).c_str(),0777))
					{
						if (errno == EEXIST)
						{
							cout<<"Creating directory "<<pstrNames[i]<<" failed! Speaker with same name already exists!"<<endl;
							exit(-1);
						}
					}
					//else
						//successfully created a folder for each speaker
					//cout<<pstrNames[i]<<endl;
						string strDesDir = strProcDir + ("//") + pstrNames[i] + ("//");
						DIR * dir;
                        struct dirent * ptr;
                      
                        dir = opendir((strDataDir + ("//") + pstrNames[i]).c_str());
						
						while(ptr = readdir(dir)) {
							
							
							
							if((strcmp(ptr->d_name,".")) && (strcmp(ptr->d_name,"..")))
							{
								int d_len = strlen(ptr->d_name);
								
								
								if(!(strcmp(&(ptr->d_name[d_len-3]),"wav"))) 
						   {
                       
						   string strSrcFile = strDataDir + ("//") + pstrNames[i] + ("//");
						   
						  strSrcFile = strSrcFile + &(ptr->d_name[0]);
				   
    
							MyPreProcess(strSrcFile, strDesDir, ptr->d_name,0.97,Thresh,nCep, nFRate, fWLen);
							strSrcFile.clear();
						   }
							}
						}
					   closedir(dir);
					
				}
			
		}
		/************************************************************************/
		
		/************************************************************************/
		/* Read MFCC from saved .mfc files and save into one txt file*/
		//CFile fileMyFile;
		//CFileException e;
		FILE *MyOut;
		FILE *MyFile;
		FILE *MyFile1;
		string strMsg;
		unsigned int nLen;
		int nFrames;
		for (int i=0; i<nNSpeakers; i++)
		{
			/************************************************************************/
			/* Open a _train.txt file to write MFCC values */
			strFilename = pstrNames[i] + ("_train.txt");
			strFilename = strProcDir + ("//") + pstrNames[i] + ("//") + strFilename;
			
			//MyOut = fopen(strFilename.c_str(), "w");
			 if((MyOut = fopen(strFilename.c_str(), "w")) == NULL)
						   {
						   cout<<"Open file "<<strFilename<<" failed!"<<endl;
						   exit(-1);
						   }
			/************************************************************************/
			char * pBuf;
				float *pfrBuf;
				long int nMarkLen;
				unsigned char * pBuf1;
				

			string strDesDir = strProcDir + ("//") + pstrNames[i] + ("//");
			DIR * dir;
			struct dirent * ptr;
                       dir = opendir((strProcDir+("//")+pstrNames[i]+("//")).c_str());
					   while(ptr = readdir(dir)) 
					   {
						   int d_len = strlen(ptr->d_name);


if(!(strcmp(&(ptr->d_name[d_len-3]),"mrk")))
{
	 
 string strFilename = strProcDir+("//")+pstrNames[i]+("//")+ptr->d_name;
                           
 if((MyFile1 = fopen(strFilename.c_str(), "r")) == NULL)
						   {
						   cout<<"Open file "<<strFilename<<" failed!"<<endl;
						   exit(-1);
						   }
 


fseek (MyFile1, 0, SEEK_END);
     

// }
nMarkLen =  ftell (MyFile1);
pBuf1 = new unsigned char [nMarkLen];

fseek (MyFile1, 0, SEEK_SET);
				
				fread(pBuf1,nMarkLen,size_t(1),MyFile1);
				
				fclose(MyFile1);
					  
 
//}

string strMFC = ptr->d_name;
strMFC.replace(d_len-3,d_len-1,"mfc");

						   
						   //if(!(strcmp(&(ptr->d_name[d_len-3]),"mfc")))
								//if(!(strcmp(&(ptr->d_name[d_len-3]),"m")) && !(strcmp(&(ptr->d_name[d_len-2]),"f")) && !(strcmp(&(ptr->d_name[d_len-1]),"c")))
						   //{
                    
						   //string strSrcFile1 = strProcDir+("//")+pstrNames[i]+("//")+ptr->d_name;
						   string strSrcFile1 = strProcDir+("//")+pstrNames[i]+("//")+strMFC;
                          
						 
						   if((MyFile = fopen(strSrcFile1.c_str(), "r")) == NULL)
						   {
						   cout<<"Open file "<<strSrcFile1<<" failed!"<<endl;
						   exit(-1);
						   }
						   

                           fread(&nLen,4,(size_t)1,MyFile);
						  
				           endian_swap(nLen);
						    
						  
				           nFrames = nLen/nCep;
						   
				           pBuf = new char [nLen*4];
				           fread(pBuf,nLen*4,(size_t)1,MyFile);
				           pfrBuf = (float *)pBuf;
				           fclose(MyFile);	
						   
						   
						   
//string strFileTitle = ptr->d_name;
						   /* Read silence marks, 1 for silence frames, 0 otherwise */

				//strFilename = strDesDir + strFileTitle;
				//cout<<strFilename<<endl;

 
								
				/************************************************************************/
	
				/************************************************************************/
				/* save MFCC to a .txt file */
				for (int frame=0; frame<nFrames; frame++)
				{
					if (frame < nMarkLen && pBuf1[frame] == 0)
					{	//write to file, frame within file range and not a silence frame
						//fprintf_s(MyOut, "%d ",nIndex++);
						for (int cc=0;cc<nCep;cc++)
						{
							fprintf(MyOut,"%f ",pfrBuf[frame*nCep+cc]);
						}
						fprintf(MyOut,"\r\n");
					}
				}
 
				/************************************************************************/
			delete [] pBuf;
				delete [] pBuf1;
								
					   }
					   }
					   
                fclose(MyOut);
                closedir(dir);
		}
		

		///************************************************************************/

		/************************************************************************/
		/* Train for GMM model parameters */
		for (int spk =0; spk<nNSpeakers; spk++)
		{
			GaussianMixture g;
			strFilename = pstrNames[spk] + ("_train.txt");
			strFilename = strProcDir + ("//") + pstrNames[spk] + ("//") + strFilename;
			
			Matrix rawData[NBSAMPLES];
			unsigned int nbData=0;
			//char filename[256];
	//		int FILE_SIZE1 = sizeof(strFilename.c_str());
	//char * filename = (char *)malloc(FILE_SIZE1);
			
			//strcpy(filename,strFilename.c_str());
			
			rawData[0] = g.loadDataFile(strFilename.c_str()); 
			nbData += rawData[0].RowSize(); 
			nbData = (int)(nbData/NBSAMPLES);
			unsigned int nbVar = rawData[0].ColumnSize();

			cout<<"Estimating parameters of GMM using EM for "<<pstrNames[spk]<<endl;
			time_t start,end;
			time (&start);
			g.MyInitEM(NBSTATES,rawData[0]); // initialize the model
			int nIter = g.MyDoEM(rawData[0]); // performs EM
			//cout<<"calculate time"<<endl;
			time (&end);
            double dwDuration = difftime (end,start);


			strFilename = pstrNames[spk] + ("_GMM.txt");
			strFilename = strProcDir + ("//") + pstrNames[spk] + ("//") + strFilename;
			//strcpy(filename,strFilename.c_str());
			g.saveParams(strFilename.c_str());

			strFilename = pstrNames[spk] + ("_Complexity.txt");
			strFilename = strProcDir + ("//") + pstrNames[spk] + ("//") + strFilename;
			//MyOut = fopen(strFilename.c_str(), "w");
			 if((MyOut = fopen(strFilename.c_str(), "w")) == NULL)
						   {
						   cout<<"Open file"<<strFilename<<" failed!"<<endl;
						   exit(-1);
						   }
			//fprintf_s(MyOut,"Number of training samples = %d\n",NTRAIN);
			//fprintf(MyOut,"Dimension of data vector = %d\r\n", nCep);
			//fprintf(MyOut,"Number of components in GMM = %d\r\n", NBSTATES);
			fprintf(MyOut,"Number of iterations the EM algorithm takes = %d\r\n", nIter);
			fprintf(MyOut,"Computation time for EM algorithm (seconds) = %f\r\n", dwDuration);
			fclose(MyOut);
		}
		/************************************************************************/
	//}
delete[]pstrNames;
//delete[]nUtterances;
	return nRetCode;
}
