%%% construction of our six-level dicision tree
% Take 13 input parameters: 
% 1. directory of training data 
% 2. directory of Pitch feature data for training
% 3. directory of Positve Pulse PSNR feature data for training
% 4. directory of Negative Pusle PSNR feature data for training
% 5. directory of Positive Pulse Skewness feature data for training
% 6. directory of Negative Pulse Skewness feature data for training
% 7. directory of Positive Pulse Width feature data for training
% 8. directory of Pitch feature data for testing
% 9. directory of Positve Pulse PSNR feature data for testing
% 10. directory of negative Pulse PSNR feature data for testing
% 11. directory of Positve Pulse Skewness feature data for testing
% 12. directory of Negative Pulse Skewness feature data for testing
% 13. directory of Positve Pulse Width feature data for testing
% no return value but generate two new directory 'Train_6L' and 'Test_6L'.
% 'Train_6L' contains all directories representing leaf nodes of the tree,
% in each directory, a subdirectory is created for each speaker who belongs to the leaf node 
% 'Test_6L' contains all directories representing leaf nodes of the tree,
% if a speaker under test is determined to belong to a leaf node, a
% a subdirectory will be created for the speaker in the directory
% representing the leaf node

function 6L_Tree(data_train,Pit_train,P_P_train,P_N_train,S_P_train,S_N_train,W_P_train,Pit_test,P_P_test,P_N_test,S_P_test,S_N_test,W_P_test)

close all
clear all

A = dir(data_train);
leng = length(A);
D = [];
DD=cell(1,10);
num =16;
coe = 0.05;
num1 = 32;
num2 = 16;
%coe1 = 0.5;
clusize = 20;
S = cell(1,num);
CC = zeros(1,num);
I = cell(1,num);

%%%%%%%%%%%%%%%%%%%  training at level 1 using pitch feature
for du = 3:leng
til = A(du).name;
pf = ([Pit_train '\' til '\Raw_Pitch.txt']);
fid1=fopen(pf,'r');
C=textscan(fid1,'%f%f');
fclose(fid1);
Da1=C{1};
Da2=C{2};

Da2(find(Da1<0.8))=0;
Da2(find(Da2>log(550) | Da2<log(50)))=0;

D4 = Da2(find(Da2>0));

D=[D mean(D4)-coe*std(D4) mean(D4)+coe*std(D4)];

end

[P,C] = lloyds(D,num);

for du = 3:leng
til = A(du).name;
pf = ([Pit_train '\' til '\Raw_Pitch.txt']);
fid1=fopen(pf,'r');
C=textscan(fid1,'%f%f');
fclose(fid1);

Dat1=C{1};
Dat2=C{2};

Dat2(find(Dat1<0.8))=0;
Dat2(find(Dat2>log(550) | Dat2<log(50)))=0;
D2 = Dat2(find(Dat2>0));
D3 = D2(find(D2>(mean(D2)-coe*std(D2)) & D2<(mean(D2)+coe*std(D2))));
muu = mean(D2);
var = std(D2);
D4 = linspace(muu-coe*var,muu+coe*var,100);

if(find(D4<=P(1)))
    S{1} = [S{1} {til}];
    I{1} = [I{1} du-2];
end

if(find(D4>P(num-1)))
    S{num} = [S{num} {til}];
    I{num} = [I{num} du-2];
end
if(num>2)
for k=1:num-2
    if(find(D4>P(k) & D4<=P(k+1)))
        S{k+1} = [S{k+1} {til}];
        I{k+1} = [I{k+1} du-2];
    end
end
end
end


%%%%%%%%%%%%%%%%%%%%%training at Level 2 using Positive Pulse PSNR feature

SS=cell(num,num1);
II=cell(num,num1);
P1 = cell(1,num);
per = 0.85;
coee = 1.1;
for cl = 1:num
    if(length(I{cl})>clusize)
    DDD = [];
for du = 1:length(I{cl})
pf = ([P_P_train '\' S{cl}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
C2=textscan(fid2,'%f');
fclose(fid2);
Da3=C2{1};

le = length(Da3);
[SD IND] = sort(Da3);

IND1 = IND(floor(le*(1-per)/2):ceil(le*(1+per)/2));

%mu = mean(D(IND1));
%va = std(D(IND1));

DDD = [DDD mean(Da3(IND1))-coee*std(Da3(IND1)) mean(Da3(IND1))+coee*std(Da3(IND1))];
end

[P1{cl},CC1] = lloyds(DDD.',num1);


for du = 1:length(I{cl})

pf = ([P_P_train '\' S{cl}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
C2=textscan(fid2,'%f');
fclose(fid2);
Da3=C2{1};

le = length(Da3);
[SD IND] = sort(Da3);

IND1 = IND(floor(le*(1-per)/2):ceil(le*(1+per)/2));

D5 = linspace(mean(Da3(IND1))-coee*std(Da3(IND1)),mean(Da3(IND1))+coee*std(Da3(IND1)),100);

if(find(D5<=P1{cl}(1)))
    SS{cl,1} = [SS{cl,1} {S{cl}{du}}];
    II{cl,1} = [II{cl,1} du];
end

if(find(D5>P1{cl}(num1-1)))
    SS{cl,num1} = [SS{cl,num1} {S{cl}{du}}];
    II{cl,num1} = [II{cl,num1} du];
end
if(num1>2)
for m=1:num1-2
    if(find(D5>P1{cl}(m) & D5<=P1{cl}(m+1)))
        SS{cl,m+1} = [SS{cl,m+1} {S{cl}{du}}];
        II{cl,m+1} = [II{cl,m+1} du];
    end
end
end
end

    elseif(length(I{cl})>0 & length(I{cl})<=clusize)
            SS{cl,1}=S{cl};
            
             II{cl,1}=I{cl};
            
        end

end



%%%%%%%%%%%%%%%%%%%%%training at Level 3 using Positive Pulse Skewness feature



SSS=cell(num,num1,num2);
III=cell(num,num1,num2);
P2 = cell(num,num1);
per1 = 0.95;
coee1 = 0.55;
for cl1 = 1:num
    
    for cl2=1:num1
        if(length(II{cl1,cl2})>clusize)
    DDD = [];
for du = 1:length(II{cl1,cl2})
pf = ([S_P_train '\' SS{cl1,cl2}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
C3=textscan(fid2,'%f');
fclose(fid2);
Da4=C3{1};

le = length(Da4);
[SD IND] = sort(Da4);

IND1 = IND(floor(le*(1-per1)/2):ceil(le*(1+per1)/2));

%mu = mean(D(IND1));
%va = std(D(IND1));

DDD = [DDD mean(Da4(IND1))-coee1*std(Da4(IND1)) mean(Da4(IND1))+coee1*std(Da4(IND1))];
end

[P2{cl1,cl2},CC2] = lloyds(DDD.',num2);


for du = 1:length(II{cl1,cl2})

pf = ([S_P_train '\' SS{cl1,cl2}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
C3=textscan(fid2,'%f');
fclose(fid2);
Da4=C3{1};

le = length(Da4);
[SD IND] = sort(Da4);

IND1 = IND(floor(le*(1-per1)/2):ceil(le*(1+per1)/2));

D6 = linspace(mean(Da4(IND1))-coee1*std(Da4(IND1)),mean(Da4(IND1))+coee1*std(Da4(IND1)),100);

if(find(D6<=P2{cl1,cl2}(1)))
    SSS{cl1,cl2,1} = [SSS{cl1,cl2,1} {SS{cl1,cl2}{du}}];
    III{cl1,cl2,1} = [III{cl1,cl2,1} du];
end

if(find(D6>P2{cl1,cl2}(num2-1)))
    SSS{cl1,cl2,num2} = [SSS{cl1,cl2,num2} {SS{cl1,cl2}{du}}];
    III{cl1,cl2,num2} = [III{cl1,cl2,num2} du];
end
if(num2>2)
for m=1:num2-2
    if(find(D6>P2{cl1,cl2}(m) & D6<=P2{cl1,cl2}(m+1)))
        SSS{cl1,cl2,m+1} = [SSS{cl1,cl2,m+1} {SS{cl1,cl2}{du}}];
        III{cl1,cl2,m+1} = [III{cl1,cl2,m+1} du];
    end
end
end
end
        elseif(length(II{cl1,cl2})>0 & length(II{cl1,cl2})<=clusize)
            SSS{cl1,cl2,1}=SS{cl1,cl2};
            
             III{cl1,cl2,1}=II{cl1,cl2};
            
        end
       
            
            
    end
end


%%%%%%%%%%%%%%%  Training at level 4 using Negative Pulse PSNR feature
num3 = 16;
%coe2 = 0.5;
per2 = 0.95;
coee2 = 0.8;
SSSS=cell(num,num1,num2,num3);
IIII=cell(num,num1,num2,num3);
P3 = cell(num,num1,num2);
for cl1 = 1:num
    for cl2 = 1:num1
        for cl3 = 1:num2
            if(length(III{cl1,cl2,cl3})>clusize)
    DDD = [];
for du = 1:length(III{cl1,cl2,cl3})
pf = ([P_N_train '\' SSS{cl1,cl2,cl3}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
CD=textscan(fid2,'%f');
fclose(fid2);
DDa3=CD{1};

le = length(DDa3);
[SD IND] = sort(DDa3);

IND1 = IND(floor(le*(1-per2)/2):ceil(le*(1+per2)/2));

DDD = [DDD mean(DDa3(IND1))-coee2*std(DDa3(IND1)) mean(DDa3(IND1))+coee2*std(DDa3(IND1))];

end

[P3{cl1,cl2,cl3},CCC1] = lloyds(DDD.',num3);


for du = 1:length(III{cl1,cl2,cl3})

pf = ([P_N_train '\' SSS{cl1,cl2,cl3}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
CD=textscan(fid2,'%f');
fclose(fid2);
DDa3=CD{1};

le = length(DDa3);
[SD IND] = sort(DDa3);

IND1 = IND(floor(le*(1-per2)/2):ceil(le*(1+per2)/2));

DD5 = linspace(mean(DDa3(IND1))-coee2*std(DDa3(IND1)),mean(DDa3(IND1))+coee2*std(DDa3(IND1)),100);

if(find(DD5<=P3{cl1,cl2,cl3}(1)))
    SSSS{cl1,cl2,cl3,1} = [SSSS{cl1,cl2,cl3,1} {SSS{cl1,cl2,cl3}{du}}];
    IIII{cl1,cl2,cl3,1} = [IIII{cl1,cl2,cl3,1} du];
end

if(find(DD5>P3{cl1,cl2,cl3}(num3-1)))
    SSSS{cl1,cl2,cl3,num3} = [SSSS{cl1,cl2,cl3,num3} {SSS{cl1,cl2,cl3}{du}}];
    IIII{cl1,cl2,cl3,num3} = [IIII{cl1,cl2,cl3,num3} du];
end
if(num3>2)
for m=1:num3-2
    if(find(DD5>P3{cl1,cl2,cl3}(m) & DD5<=P3{cl1,cl2,cl3}(m+1)))
        SSSS{cl1,cl2,cl3,m+1} = [SSSS{cl1,cl2,cl3,m+1} {SSS{cl1,cl2,cl3}{du}}];
        IIII{cl1,cl2,cl3,m+1} = [IIII{cl1,cl2,cl3,m+1} du];
    end
end
end
end
            
elseif(length(III{cl1,cl2,cl3})>0 & length(III{cl1,cl2,cl3})<=clusize)
            SSSS{cl1,cl2,cl3,1}=SSS{cl1,cl2,cl3};
            
             IIII{cl1,cl2,cl3,1}=III{cl1,cl2,cl3};
            end
        end
    end
end


%%%%%%%%%%%%%%%  Training at level 5 using Negative Pulse Skewness feature
num4 = 8;
per3 = 0.85;
coee3 = 0.85;
SSSSS=cell(num,num1,num2,num3,num4);
IIIII=cell(num,num1,num2,num3,num4);
P4 = cell(num,num1,num2,num3);
for cl1 = 1:num
    for cl2 = 1:num1
        for cl3 = 1:num2
            for cl4 = 1:num3
            if(length(IIII{cl1,cl2,cl3,cl4})>clusize)
    DDD = [];
for du = 1:length(IIII{cl1,cl2,cl3,cl4})
pf = ([S_N_train '\' SSSS{cl1,cl2,cl3,cl4}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
CDD=textscan(fid2,'%f');
fclose(fid2);
DDa5=CDD{1};

%DDa5 = mean(reshape(DDa4,5,''));

le = length(DDa5);
[SD IND] = sort(DDa5);

IND1 = IND(floor(le*(1-per3)/2):ceil(le*(1+per3)/2));

DDD = [DDD mean(DDa5(IND1))-coee3*std(DDa5(IND1)) mean(DDa5(IND1))+coee3*std(DDa5(IND1))];
  
end

[P4{cl1,cl2,cl3,cl4},CCCC1] = lloyds(DDD.',num4);
%[CCCC1,P4{cl1,cl2,cl3,cl4}] = kmeans(DDD.',num4);


for du = 1:length(IIII{cl1,cl2,cl3,cl4})

pf = ([S_N_train '\' SSSS{cl1,cl2,cl3,cl4}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
CDD=textscan(fid2,'%f');
fclose(fid2);
DDa5=CDD{1};
%DDa5 = mean(reshape(DDa4,5,''));
le = length(DDa5);
[SD IND] = sort(DDa5);
IND1 = IND(floor(le*(1-per3)/2):ceil(le*(1+per3)/2));
 DD5 = linspace(mean(DDa5(IND1))-coee3*std(DDa5(IND1)),mean(DDa5(IND1))+coee3*std(DDa5(IND1)),100);

if(find(DD5<=P4{cl1,cl2,cl3,cl4}(1)))
    SSSSS{cl1,cl2,cl3,cl4,1} = [SSSSS{cl1,cl2,cl3,cl4,1} {SSSS{cl1,cl2,cl3,cl4}{du}}];
    IIIII{cl1,cl2,cl3,cl4,1} = [IIIII{cl1,cl2,cl3,cl4,1} du];
end

if(find(DD5>P4{cl1,cl2,cl3,cl4}(num4-1)))
    SSSSS{cl1,cl2,cl3,cl4,num4} = [SSSSS{cl1,cl2,cl3,cl4,num4} {SSSS{cl1,cl2,cl3,cl4}{du}}];
    IIIII{cl1,cl2,cl3,cl4,num4} = [IIIII{cl1,cl2,cl3,cl4,num4} du];
end
if(num4>2)
for m=1:num4-2
    if(find(DD5>P4{cl1,cl2,cl3,cl4}(m) & DD5<=P4{cl1,cl2,cl3,cl4}(m+1)))
        SSSSS{cl1,cl2,cl3,cl4,m+1} = [SSSSS{cl1,cl2,cl3,cl4,m+1} {SSSS{cl1,cl2,cl3,cl4}{du}}];
        IIIII{cl1,cl2,cl3,cl4,m+1} = [IIIII{cl1,cl2,cl3,cl4,m+1} du];
    end
end
end
end
            
elseif(length(IIII{cl1,cl2,cl3,cl4})>0 & length(IIII{cl1,cl2,cl3,cl4})<=clusize)
            SSSSS{cl1,cl2,cl3,cl4,1}=SSSS{cl1,cl2,cl3,cl4};
            
             IIIII{cl1,cl2,cl3,cl4,1}=IIII{cl1,cl2,cl3,cl4};
            end
        end
    end
    end
end



%%%%%%%%%%%%%%%  Training at level 6 using Positvie Pulse Width feature
num5 = 16;
per4 = 0.95;
coee4 = 0.7;
SSSSSS=cell(num,num1,num2,num3,num4,num5);
IIIIII=cell(num,num1,num2,num3,num4,num5);
P5 = cell(num,num1,num2,num3,num4);
for cl1 = 1:num
    for cl2 = 1:num1
        for cl3 = 1:num2
            for cl4 = 1:num3
                for cl5 = 1:num4
            if(length(IIIII{cl1,cl2,cl3,cl4,cl5})>clusize)
    DDD = [];
for du = 1:length(IIIII{cl1,cl2,cl3,cl4,cl5})
pf = ([W_P_train '\' SSSSS{cl1,cl2,cl3,cl4,cl5}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
CDDD=textscan(fid2,'%f');
fclose(fid2);
DDDa5=CDDD{1};

%DDa5 = mean(reshape(DDa4,5,''));

le = length(DDDa5);
[SD IND] = sort(DDDa5);

IND1 = IND(floor(le*(1-per4)/2):ceil(le*(1+per4)/2));

DDD = [DDD mean(DDDa5(IND1))-coee4*std(DDDa5(IND1)) mean(DDDa5(IND1))+coee4*std(DDDa5(IND1))];
  
end

[P5{cl1,cl2,cl3,cl4,cl5},CCCCC1] = lloyds(DDD.',num5);


for du = 1:length(IIIII{cl1,cl2,cl3,cl4,cl5})

pf = ([W_P_train '\' SSSSS{cl1,cl2,cl3,cl4,cl5}{du} '\re_fea.txt']);
fid2=fopen(pf,'r');
CDDD = textscan(fid2,'%f');
fclose(fid2);
DDDa5=CDDD{1};
%DDa5 = mean(reshape(DDa4,5,''));
le = length(DDDa5);
[SD IND] = sort(DDDa5);
IND1 = IND(floor(le*(1-per4)/2):ceil(le*(1+per4)/2));
 DDD5 = linspace(mean(DDDa5(IND1))-coee4*std(DDDa5(IND1)),mean(DDDa5(IND1))+coee4*std(DDDa5(IND1)),100);

if(find(DDD5<=P5{cl1,cl2,cl3,cl4,cl5}(1)))
    SSSSSS{cl1,cl2,cl3,cl4,cl5,1} = [SSSSSS{cl1,cl2,cl3,cl4,cl5,1} {SSSSS{cl1,cl2,cl3,cl4,cl5}{du}}];
    IIIIII{cl1,cl2,cl3,cl4,cl5,1} = [IIIIII{cl1,cl2,cl3,cl4,cl5,1} du];
end

if(find(DDD5>P5{cl1,cl2,cl3,cl4,cl5}(num5-1)))
    SSSSSS{cl1,cl2,cl3,cl4,cl5,num5} = [SSSSSS{cl1,cl2,cl3,cl4,cl5,num5} {SSSSS{cl1,cl2,cl3,cl4,cl5}{du}}];
    IIIIII{cl1,cl2,cl3,cl4,cl5,num5} = [IIIIII{cl1,cl2,cl3,cl4,cl5,num5} du];
end
if(num5>2)
for m=1:num5-2
    if(find(DDD5>P5{cl1,cl2,cl3,cl4,cl5}(m) & DDD5<=P5{cl1,cl2,cl3,cl4,cl5}(m+1)))
        SSSSSS{cl1,cl2,cl3,cl4,cl5,m+1} = [SSSSSS{cl1,cl2,cl3,cl4,cl5,m+1} {SSSSS{cl1,cl2,cl3,cl4,cl5}{du}}];
        IIIIII{cl1,cl2,cl3,cl4,cl5,m+1} = [IIIIII{cl1,cl2,cl3,cl4,cl5,m+1} du];
    end
end
end
end
            
elseif(length(IIIII{cl1,cl2,cl3,cl4,cl5})>0 & length(IIIII{cl1,cl2,cl3,cl4,cl5})<=clusize)
            SSSSSS{cl1,cl2,cl3,cl4,cl5,1}=SSSSS{cl1,cl2,cl3,cl4,cl5};
            
             IIIIII{cl1,cl2,cl3,cl4,cl5,1}=IIIII{cl1,cl2,cl3,cl4,cl5};
            end
        end
    end
    end
    end
end
tic
%%%%%%%%%%%%%%%%%%%%% thresholds for testing at each level
%B = dir('.\Fea_Test2\');
%len = length(B);
P =[0 P 100];
for k=1:num
P1{k} = [-1000 P1{k} 1000];
end

for k=1:num
    for n=1:num1
P2{k,n} = [-1000 P2{k,n} 1000];
end
end

for k=1:num
    for n=1:num1
        for m=1:num2
P3{k,n,m} = [-1000 P3{k,n,m} 1000];
end
    end
end

for k=1:num
    for n=1:num1
        for m=1:num2
            for u=1:num3
P4{k,n,m,u} = [-1000 P4{k,n,m,u} 1000];
end
    end
    end
end

for k=1:num
    for n=1:num1
        for m=1:num2
            for u=1:num3
                for v=1:num4
P5{k,n,m,u,v} = [-1000 P5{k,n,m,u,v} 1000];
end
    end
    end
    end
end


%%%%% testing 

CN = zeros(num,num1,num2,num3,num4,num5);
CNN = zeros(num,num1,num2,num3,num4,num5);
corr=0;
for du = 3:leng
til = A(du).name;
pf = ([Pit_test '\' til '\Raw_Pitch.txt']);
fid1=fopen(pf,'r');
C1=textscan(fid1,'%f%f');
fclose(fid1);
Da=C1{1};
Da1=C1{2};

Da1(find(Da<0.8))=0;
Da1(find(Da1>log(550) | Da1<log(50)))=0;
DD2 = Da1(find(Da1>0));
DD3 = DD2(find(DD2>(mean(DD2)-coe*std(DD2)) & DD2<(mean(DD2)+coe*std(DD2))));

mu = mean(DD3);

pf1 = ([P_P_test '\' til '\re_fea.txt']);
fid4=fopen(pf1,'r');
C4=textscan(fid4,'%f');
fclose(fid4);
Da5=C4{1};

le = length(Da5);
[SD IND] = sort(Da5);

IND1 = IND(floor(le*(1-per)/2):ceil(le*(1+per)/2));

mu1 = mean(Da5(IND1));

pf1 = ([S_P_test'\' til '\re_fea.txt']);
fid4=fopen(pf1,'r');
C5=textscan(fid4,'%f');
fclose(fid4);
Da6=C5{1};

le = length(Da6);
[SD IND] = sort(Da6);

IND1 = IND(floor(le*(1-per1)/2):ceil(le*(1+per1)/2));

mu2 = mean(Da6(IND1));

pf1 = ([P_N_test '\' til '\re_fea.txt']);
fid1=fopen(pf1,'r');
C6=textscan(fid1,'%f');
fclose(fid1);
Da7=C6{1};

le = length(Da7);
[SD IND] = sort(Da7);

IND1 = IND(floor(le*(1-per2)/2):ceil(le*(1+per2)/2));

mu3 = mean(Da7(IND1));

pf = ([S_N_test '\' til '\re_fea.txt']);
fid1=fopen(pf,'r');
C7=textscan(fid1,'%f');
fclose(fid1);
Da8=C7{1};

le = length(Da8);
[SD IND] = sort(Da8);

IND1 = IND(floor(le*(1-per3)/2):ceil(le*(1+per3)/2));

mu4 = mean(Da8(IND1));


pf = ([W_P_test '\' til '\re_fea.txt']);
fid1=fopen(pf,'r');
C8=textscan(fid1,'%f');
fclose(fid1);
Da9=C8{1};

le = length(Da9);
[SD IND] = sort(Da9);

IND1 = IND(floor(le*(1-per4)/2):ceil(le*(1+per4)/2));

mu5 = mean(Da9(IND1));


%%% determine which leaf node the speaker under test belongs to and create the directory, accordingly
 for k =1:num
     if(mu>P(k) & mu<=P(k+1))
         
         if(length(I{k})<=clusize)
             
                dn = ['.\Test_6L\C' int2str(k) '_1_1_1_1_1' '\' til];
mkdir(dn) 
                     
                CN(k,1,1,1,1,1)=CN(k,1,1,1,1,1)+1;
                if(ismember(til,SSSSSS{k,1,1,1,1,1}))
                    corr=corr+1;
                    CNN(k,1,1,1,1,1)=CNN(k,1,1,1,1,1)+1;
                end
                
                else
         
        for n=1:num1
            if (mu1>P1{k}(n) & mu1<=P1{k}(n+1))
                if(length(II{k,n})<=clusize)
                
                    dn = ['.\Test_6L\C' int2str(k) '_' int2str(n) '_1_1_1_1' '\' til];
mkdir(dn) 
                    
                CN(k,n,1,1,1,1)=CN(k,n,1,1,1,1)+1;
                if(ismember(til,SSSSSS{k,n,1,1,1,1}))
                    corr=corr+1;
                     CNN(k,n,1,1,1,1)=CNN(k,n,1,1,1,1)+1;
                end
                
                else
                    
                    for m=1:num2
                 if (mu2>P2{k,n}(m) & mu2<=P2{k,n}(m+1))
                    
                     if(length(III{k,n,m})<=clusize)
                
                          dn = ['.\Test_6L\C' int2str(k) '_' int2str(n) '_' int2str(m) '_1_1_1' '\' til];
mkdir(dn) 
                         
                CN(k,n,m,1,1,1)=CN(k,n,m,1,1,1)+1;
                if(ismember(til,SSSSSS{k,n,m,1,1,1}))
                    corr=corr+1;
                    CNN(k,n,m,1,1,1)=CNN(k,n,m,1,1,1)+1;
                end
                     else
                         for u = 1:num3
                     if (mu3>P3{k,n,m}(u) & mu3<=P3{k,n,m}(u+1))
                         if(length(IIII{k,n,m,u})<=clusize)
                             
                         dn = ['.\Test_6L\C' int2str(k) '_' int2str(n) '_' int2str(m) '_' int2str(u) '_1_1' '\' til];
 mkdir(dn) 
                                                  
                    CN(k,n,m,u,1,1)=CN(k,n,m,u,1,1)+1;
                    if(ismember(til,SSSSSS{k,n,m,u,1,1}))
                    corr=corr+1;
                     CNN(k,n,m,u,1,1)=CNN(k,n,m,u,1,1)+1;
                    end
                    
                         else
                                         for v = 1:num4
                     if (mu4>P4{k,n,m,u}(v) & mu4<=P4{k,n,m,u}(v+1))
                   if(length(IIIII{k,n,m,u,v})<=clusize)
                                   
                         dn = ['.\Test_6L\C' int2str(k) '_' int2str(n) '_' int2str(m) '_' int2str(u) '_' int2str(v) '_1' '\' til];
 mkdir(dn) 
                                                  
                    CN(k,n,m,u,v,1)=CN(k,n,m,u,v,1)+1;
                    if(ismember(til,SSSSSS{k,n,m,u,v,1}))
                    corr=corr+1;
                    CNN(k,n,m,u,v,1)=CNN(k,n,m,u,v,1)+1;
                    end
                    
                      else
                                         for w = 1:num5
                     if (mu5>P5{k,n,m,u,v}(w) & mu5<=P5{k,n,m,u,v}(w+1))
                   
                                   
                         dn = ['.\Test_6L\C' int2str(k) '_' int2str(n) '_' int2str(m) '_' int2str(u) '_' int2str(v) '_' int2str(w) '\' til];
 mkdir(dn) 
                                                  
                    CN(k,n,m,u,v,w)=CN(k,n,m,u,v,w)+1;
                    if(ismember(til,SSSSSS{k,n,m,u,v,w}))
                    corr=corr+1;
                    CNN(k,n,m,u,v,w)=CNN(k,n,m,u,v,w)+1;
                    end
                    
                 end
                    end
                
                    
                end
            end
        end
     end
            end
        end
     end
     end
 end
 end
     end
 end
     end
 end
 end
end

%%% average population rate calculation (leaf node/root node)
prr = 0;
for k =1:num 
    for n=1:num1
        for m=1:num2
            for u=1:num3
                for v=1:num4
                     for w=1:num5
    prr =  prr + CNN(k,n,m,u,v,w)*length(IIIIII{k,n,m,u,v,w});
    end
            end
        end
    end
    end
end
fprintf('The average population rate of the lead node to the root node is %f\n',prr/corr)
fprintf('The accuracy of the clustering at leaf-node level is %f\n',corr/(leng-2))






% %%%%%%%%%%%%%%%%%%%% directory creation for leaf nodes (only create for those leaf nodes which at least one speaker under test is put into)
for k=1:num
 for n=1:num1
    for m=1:num2
        for u=1:num3
  for v=1:num4
for w = 1:num5
            if(CN(k,n,m,u,v,w)>0)
                for b = 1:length(IIIIII{k,n,m,u,v,w})
        dn = ['.\Train_6L\C' int2str(k) '_' int2str(n) '_' int2str(m) '_' int2str(u) '_' int2str(v) '_' int2str(w) '\' SSSSSS{k,n,m,u,v,w}{b}];
   mkdir(dn) 
    end
 end
end
 end
        end
    end
 end
end

